/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchHandleResolver;
import io.prestosql.plugin.tpch.TpchRecordSetProvider;
import io.prestosql.plugin.tpch.TpchSplitManager;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;

public class MockConnectorFactory
implements ConnectorFactory {
    private final Function<ConnectorSession, List<String>> listSchemaNames;
    private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
    private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
    private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
    private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
    private final ApplyProjection applyProjection;
    private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout;
    private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout;
    private final Supplier<Iterable<EventListener>> eventListeners;
    private final ListRoleGrants roleGrants;

    private MockConnectorFactory(Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, ApplyProjection applyProjection, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout, Supplier<Iterable<EventListener>> eventListeners, ListRoleGrants roleGrants) {
        this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
        this.listTables = Objects.requireNonNull(listTables, "listTables is null");
        this.getViews = Objects.requireNonNull(getViews, "getViews is null");
        this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
        this.getColumns = getColumns;
        this.applyProjection = applyProjection;
        this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
        this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
        this.eventListeners = Objects.requireNonNull(eventListeners, "eventListeners is null");
        this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
    }

    public String getName() {
        return "mock";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return new MockConnector(context, this.listSchemaNames, this.listTables, this.getViews, this.getTableHandle, this.getColumns, this.applyProjection, this.getInsertLayout, this.getNewTableLayout, this.eventListeners, this.roleGrants);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<ConnectorSession, List<String>> listSchemaNames = Builder.defaultListSchemaNames();
        private BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables = Builder.defaultListTables();
        private BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews = Builder.defaultGetViews();
        private BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle = Builder.defaultGetTableHandle();
        private Function<SchemaTableName, List<ColumnMetadata>> getColumns = Builder.defaultGetColumns();
        private ApplyProjection applyProjection = (session, handle, projections, assignments) -> Optional.empty();
        private BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout = Builder.defaultGetInsertLayout();
        private BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout = Builder.defaultGetNewTableLayout();
        private Supplier<Iterable<EventListener>> eventListeners = ImmutableList::of;
        private ListRoleGrants roleGrants = Builder.defaultRoleAuthorizations();

        public Builder withListSchemaNames(Function<ConnectorSession, List<String>> listSchemaNames) {
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            return this;
        }

        public Builder withListRoleGrants(ListRoleGrants roleGrants) {
            this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
            return this;
        }

        public Builder withListTables(BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables) {
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            return this;
        }

        public Builder withGetViews(BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews) {
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            return this;
        }

        public Builder withGetTableHandle(BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle) {
            this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
            return this;
        }

        public Builder withGetColumns(Function<SchemaTableName, List<ColumnMetadata>> getColumns) {
            this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
            return this;
        }

        public Builder withApplyProjection(ApplyProjection applyProjection) {
            this.applyProjection = applyProjection;
            return this;
        }

        public Builder withGetInsertLayout(BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout) {
            this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
            return this;
        }

        public Builder withGetNewTableLayout(BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout) {
            this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
            return this;
        }

        public Builder withEventListener(EventListener listener) {
            Objects.requireNonNull(listener, "listener is null");
            this.withEventListener(() -> listener);
            return this;
        }

        public Builder withEventListener(Supplier<EventListener> listenerFactory) {
            Objects.requireNonNull(listenerFactory, "listenerFactory is null");
            this.eventListeners = () -> ImmutableList.of((Object)((EventListener)listenerFactory.get()));
            return this;
        }

        public MockConnectorFactory build() {
            return new MockConnectorFactory(this.listSchemaNames, this.listTables, this.getViews, this.getTableHandle, this.getColumns, this.applyProjection, this.getInsertLayout, this.getNewTableLayout, this.eventListeners, this.roleGrants);
        }

        public static Function<ConnectorSession, List<String>> defaultListSchemaNames() {
            return session -> ImmutableList.of();
        }

        public static ListRoleGrants defaultRoleAuthorizations() {
            return (session, roles, grantees, limit) -> ImmutableSet.of();
        }

        public static BiFunction<ConnectorSession, String, List<SchemaTableName>> defaultListTables() {
            return (session, schemaName) -> ImmutableList.of();
        }

        public static BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> defaultGetViews() {
            return (session, schemaTablePrefix) -> ImmutableMap.of();
        }

        public static BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> defaultGetTableHandle() {
            return (session, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName);
        }

        public static BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> defaultGetInsertLayout() {
            return (session, tableHandle) -> Optional.empty();
        }

        public static BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> defaultGetNewTableLayout() {
            return (session, tableHandle) -> Optional.empty();
        }

        public static Function<SchemaTableName, List<ColumnMetadata>> defaultGetColumns() {
            return table -> (List)IntStream.range(0, 100).boxed().map(i -> new ColumnMetadata("column_" + i, (Type)VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        }
    }

    private static class MockConnectorOutputTableHandle
    implements ConnectorOutputTableHandle {
        private MockConnectorOutputTableHandle() {
        }
    }

    private static class MockConnectorInsertTableHandle
    implements ConnectorInsertTableHandle {
        private MockConnectorInsertTableHandle() {
        }
    }

    public static class MockConnectorTableHandle
    implements ConnectorTableHandle {
        private final SchemaTableName tableName;

        @JsonCreator
        public MockConnectorTableHandle(@JsonProperty SchemaTableName tableName) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        }

        @JsonProperty
        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MockConnectorTableHandle other = (MockConnectorTableHandle)o;
            return Objects.equals(this.tableName, other.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName);
        }
    }

    public static class MockConnector
    implements Connector {
        private final ConnectorContext context;
        private final Function<ConnectorSession, List<String>> listSchemaNames;
        private final BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables;
        private final BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews;
        private final BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle;
        private final Function<SchemaTableName, List<ColumnMetadata>> getColumns;
        private final ApplyProjection applyProjection;
        private final BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout;
        private final BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout;
        private final Supplier<Iterable<EventListener>> eventListeners;
        private final ListRoleGrants roleGrants;

        private MockConnector(ConnectorContext context, Function<ConnectorSession, List<String>> listSchemaNames, BiFunction<ConnectorSession, String, List<SchemaTableName>> listTables, BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorViewDefinition>> getViews, BiFunction<ConnectorSession, SchemaTableName, ConnectorTableHandle> getTableHandle, Function<SchemaTableName, List<ColumnMetadata>> getColumns, ApplyProjection applyProjection, BiFunction<ConnectorSession, SchemaTableName, Optional<ConnectorNewTableLayout>> getInsertLayout, BiFunction<ConnectorSession, ConnectorTableMetadata, Optional<ConnectorNewTableLayout>> getNewTableLayout, Supplier<Iterable<EventListener>> eventListeners, ListRoleGrants roleGrants) {
            this.context = Objects.requireNonNull(context, "context is null");
            this.listSchemaNames = Objects.requireNonNull(listSchemaNames, "listSchemaNames is null");
            this.listTables = Objects.requireNonNull(listTables, "listTables is null");
            this.getViews = Objects.requireNonNull(getViews, "getViews is null");
            this.getTableHandle = Objects.requireNonNull(getTableHandle, "getTableHandle is null");
            this.getColumns = Objects.requireNonNull(getColumns, "getColumns is null");
            this.applyProjection = Objects.requireNonNull(applyProjection, "applyProjection is null");
            this.getInsertLayout = Objects.requireNonNull(getInsertLayout, "getInsertLayout is null");
            this.getNewTableLayout = Objects.requireNonNull(getNewTableLayout, "getNewTableLayout is null");
            this.eventListeners = Objects.requireNonNull(eventListeners, "eventListeners is null");
            this.roleGrants = Objects.requireNonNull(roleGrants, "roleGrants is null");
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
            return new ConnectorTransactionHandle(){};
        }

        public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
            return new MockConnectorMetadata();
        }

        public ConnectorSplitManager getSplitManager() {
            return new TpchSplitManager(this.context.getNodeManager(), 1);
        }

        public ConnectorRecordSetProvider getRecordSetProvider() {
            return new TpchRecordSetProvider();
        }

        public Iterable<EventListener> getEventListeners() {
            return this.eventListeners.get();
        }

        private class MockConnectorMetadata
        implements ConnectorMetadata {
            private MockConnectorMetadata() {
            }

            public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle handle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
                return MockConnector.this.applyProjection.apply(session, handle, projections, assignments);
            }

            public List<String> listSchemaNames(ConnectorSession session) {
                return MockConnector.this.listSchemaNames.apply(session);
            }

            public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
                return MockConnector.this.getTableHandle.apply(session, tableName);
            }

            public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
                MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
                return new ConnectorTableMetadata(table.getTableName(), MockConnector.this.getColumns.apply(table.getTableName()));
            }

            public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
                if (schemaName.isPresent()) {
                    return MockConnector.this.listTables.apply(session, schemaName.get());
                }
                ImmutableList.Builder tableNames = ImmutableList.builder();
                for (String schema : this.listSchemaNames(session)) {
                    tableNames.addAll((Iterable)MockConnector.this.listTables.apply(session, schema));
                }
                return tableNames.build();
            }

            public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
                MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
                return (Map)MockConnector.this.getColumns.apply(table.getTableName()).stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new TpchColumnHandle(column.getName(), column.getType())));
            }

            public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
                TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)columnHandle;
                return new ColumnMetadata(tpchColumnHandle.getColumnName(), tpchColumnHandle.getType());
            }

            public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
                return (Map)this.listTables(session, prefix.getSchema()).stream().filter(arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)).collect(ImmutableMap.toImmutableMap(table -> table, MockConnector.this.getColumns));
            }

            public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
                return MockConnector.this.getViews.apply(session, schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new));
            }

            public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
                return Optional.ofNullable(MockConnector.this.getViews.apply(session, viewName.toSchemaTablePrefix()).get(viewName));
            }

            public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
                return new MockConnectorInsertTableHandle();
            }

            public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
                MockConnectorTableHandle table = (MockConnectorTableHandle)tableHandle;
                return MockConnector.this.getInsertLayout.apply(session, table.getTableName());
            }

            public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
                return new MockConnectorOutputTableHandle();
            }

            public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
                return MockConnector.this.getNewTableLayout.apply(session, tableMetadata);
            }

            public boolean usesLegacyTableLayouts() {
                return false;
            }

            public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
                return new ConnectorTableProperties();
            }

            public Set<String> listRoles(ConnectorSession session) {
                return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().map(grant -> grant.getRoleName()).collect(ImmutableSet.toImmutableSet());
            }

            public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
                return (Set)MockConnector.this.roleGrants.apply(session, Optional.empty(), Optional.empty(), OptionalLong.empty()).stream().filter(grant -> grant.getGrantee().equals((Object)principal)).collect(ImmutableSet.toImmutableSet());
            }

            public Set<RoleGrant> listAllRoleGrants(ConnectorSession session, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
                return MockConnector.this.roleGrants.apply(session, roles, grantees, limit);
            }

            public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
                return this.listRoleGrants(session, principal);
            }

            public Set<String> listEnabledRoles(ConnectorSession session) {
                return this.listRoles(session);
            }
        }
    }

    @FunctionalInterface
    public static interface ListRoleGrants {
        public Set<RoleGrant> apply(ConnectorSession var1, Optional<Set<String>> var2, Optional<Set<String>> var3, OptionalLong var4);
    }

    @FunctionalInterface
    public static interface ApplyProjection {
        public Optional<ProjectionApplicationResult<ConnectorTableHandle>> apply(ConnectorSession var1, ConnectorTableHandle var2, List<ConnectorExpression> var3, Map<String, ColumnHandle> var4);
    }
}

