/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.cost.FilterStatsCalculator;
import io.prestosql.cost.PlanNodeStatsAssertion;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.ScalarStatsCalculator;
import io.prestosql.cost.StatsNormalizer;
import io.prestosql.cost.SymbolStatsAssertion;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.ExpressionTestUtils;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.tree.Expression;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TestingTransactionManager;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.Map;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFilterStatsCalculator {
    private static final VarcharType MEDIUM_VARCHAR_TYPE = VarcharType.createVarcharType((int)100);
    private SymbolStatsEstimate xStats;
    private SymbolStatsEstimate yStats;
    private SymbolStatsEstimate zStats;
    private SymbolStatsEstimate leftOpenStats;
    private SymbolStatsEstimate rightOpenStats;
    private SymbolStatsEstimate unknownRangeStats;
    private SymbolStatsEstimate emptyRangeStats;
    private SymbolStatsEstimate mediumVarcharStats;
    private FilterStatsCalculator statsCalculator;
    private PlanNodeStatsEstimate standardInputStatistics;
    private PlanNodeStatsEstimate zeroStatistics;
    private TypeProvider standardTypes;
    private Session session;
    private Metadata metadata;

    @BeforeClass
    public void setUp() {
        this.xStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
        this.yStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
        this.zStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
        this.leftOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
        this.rightOpenStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.unknownRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.emptyRangeStats = SymbolStatsEstimate.builder().setAverageRowSize(0.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(Double.NaN).build();
        this.mediumVarcharStats = SymbolStatsEstimate.builder().setAverageRowSize(85.0).setDistinctValuesCount(165.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.34).build();
        this.standardInputStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), this.xStats).addSymbolStatistics(new Symbol("y"), this.yStats).addSymbolStatistics(new Symbol("z"), this.zStats).addSymbolStatistics(new Symbol("leftOpen"), this.leftOpenStats).addSymbolStatistics(new Symbol("rightOpen"), this.rightOpenStats).addSymbolStatistics(new Symbol("unknownRange"), this.unknownRangeStats).addSymbolStatistics(new Symbol("emptyRange"), this.emptyRangeStats).addSymbolStatistics(new Symbol("mediumVarchar"), this.mediumVarcharStats).setOutputRowCount(1000.0).build();
        this.zeroStatistics = PlanNodeStatsEstimate.builder().addSymbolStatistics(new Symbol("x"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("y"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("z"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("leftOpen"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("rightOpen"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("unknownRange"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("emptyRange"), SymbolStatsEstimate.zero()).addSymbolStatistics(new Symbol("mediumVarchar"), SymbolStatsEstimate.zero()).setOutputRowCount(0.0).build();
        this.standardTypes = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("x"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("y"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("z"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("leftOpen"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("rightOpen"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("unknownRange"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("emptyRange"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("mediumVarchar"), (Object)MEDIUM_VARCHAR_TYPE).build());
        this.session = TestingSession.testSessionBuilder().build();
        this.metadata = MetadataManager.createTestMetadataManager();
        this.statsCalculator = new FilterStatsCalculator(this.metadata, new ScalarStatsCalculator(this.metadata, new TypeAnalyzer(new SqlParser(), this.metadata)), new StatsNormalizer());
    }

    @Test
    public void testBooleanLiteralStats() {
        this.assertExpression("true").equalTo(this.standardInputStatistics);
        this.assertExpression("false").equalTo(this.zeroStatistics);
        this.assertExpression("CAST(NULL AS boolean)").equalTo(this.zeroStatistics);
    }

    @Test
    public void testComparison() {
        double lessThan3Rows = 487.5;
        this.assertExpression("x < 3e0").outputRowsCount(lessThan3Rows).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(3.0).distinctValuesCount(26.0).nullsFraction(0.0));
        this.assertExpression("-x > -3e0").outputRowsCount(lessThan3Rows);
        for (String minusThree : ImmutableList.of((Object)"DECIMAL '-3'", (Object)"-3e0", (Object)"(4e0-7e0)", (Object)"CAST(-3 AS DECIMAL(7,3))")) {
            for (String xEquals : ImmutableList.of((Object)"x = %s", (Object)"%s = x", (Object)"COALESCE(x * CAST(NULL AS BIGINT), x) = %s", (Object)"%s = CAST(x AS DOUBLE)")) {
                this.assertExpression(String.format(xEquals, minusThree)).outputRowsCount(18.75).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-3.0).highValue(-3.0).distinctValuesCount(1.0).nullsFraction(0.0));
            }
            for (String xLessThan : ImmutableList.of((Object)"x < %s", (Object)"%s > x", (Object)"%s > CAST(x AS DOUBLE)")) {
                this.assertExpression(String.format(xLessThan, minusThree)).outputRowsCount(262.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(-3.0).distinctValuesCount(14.0).nullsFraction(0.0));
            }
        }
    }

    @Test
    public void testOrStats() {
        this.assertExpression("x < 0e0 OR x < DOUBLE '-7.5'").outputRowsCount(375.0).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression("x = 0e0 OR x = DOUBLE '-7.5'").outputRowsCount(37.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("x = 1e0 OR x = 3e0").outputRowsCount(37.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("x = 1e0 OR 'a' = 'b' OR x = 3e0").outputRowsCount(37.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(1.0).highValue(3.0).distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("x = 1e0 OR (CAST('b' AS VARCHAR(3)) IN (CAST('a' AS VARCHAR(3)), CAST('b' AS VARCHAR(3)))) OR x = 3e0").equalTo(this.standardInputStatistics);
    }

    @Test
    public void testUnsupportedExpression() {
        this.assertExpression("sin(x)").outputRowsCountUnknown();
        this.assertExpression("x = sin(x)").outputRowsCountUnknown();
    }

    @Test
    public void testAndStats() {
        this.assertExpression("x < 0e0 AND x > 1e0").equalTo(this.zeroStatistics);
        this.assertExpression("x < 0e0 AND x > DOUBLE '-7.5'").outputRowsCount(281.25).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-7.5).highValue(0.0).distinctValuesCount(15.0).nullsFraction(0.0));
        this.assertExpression("x = (0e0 + 1e0) AND x = (0e0 + 3e0)").outputRowsCount(0.0).symbolStats(new Symbol("x"), SymbolStatsAssertion::emptyRange).symbolStats(new Symbol("y"), SymbolStatsAssertion::emptyRange);
        this.assertExpression("json_array_contains(JSON '[]', x) AND x < 0e0").outputRowsCount(337.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression("x < 0e0 AND json_array_contains(JSON '[]', x)").outputRowsCount(337.5).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.lowValue(-10.0).highValue(0.0).distinctValuesCount(20.0).nullsFraction(0.0));
        this.assertExpression("json_array_contains(JSON '[11]', x) AND json_array_contains(JSON '[13]', x)").outputRowsCountUnknown();
        this.assertExpression("'a' IN ('b', 'c') AND unknownRange = 3e0").outputRowsCount(0.0);
        this.assertExpression("CAST(NULL AS boolean) AND CAST(NULL AS boolean)").equalTo(this.zeroStatistics);
        this.assertExpression("CAST(NULL AS boolean) AND (x < 0e0 AND x > 1e0)").equalTo(this.zeroStatistics);
    }

    @Test
    public void testNotStats() {
        this.assertExpression("NOT(x < 0e0)").outputRowsCount(625.0).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(20.0).nullsFraction(0.4)).symbolStats(new Symbol("y"), symbolAssert -> symbolAssert.isEqualTo(this.yStats));
        this.assertExpression("NOT(x IS NULL)").outputRowsCount(750.0).symbolStats(new Symbol("x"), symbolAssert -> symbolAssert.averageRowSize(4.0).lowValue(-10.0).highValue(10.0).distinctValuesCount(40.0).nullsFraction(0.0)).symbolStats(new Symbol("y"), symbolAssert -> symbolAssert.isEqualTo(this.yStats));
        this.assertExpression("NOT(json_array_contains(JSON '[]', x))").outputRowsCountUnknown();
    }

    @Test
    public void testIsNullFilter() {
        this.assertExpression("x IS NULL").outputRowsCount(250.0).symbolStats(new Symbol("x"), symbolStats -> symbolStats.distinctValuesCount(0.0).emptyRange().nullsFraction(1.0));
        this.assertExpression("emptyRange IS NULL").outputRowsCount(1000.0).symbolStats(new Symbol("emptyRange"), SymbolStatsAssertion::empty);
    }

    @Test
    public void testIsNotNullFilter() {
        this.assertExpression("x IS NOT NULL").outputRowsCount(750.0).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(40.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("emptyRange IS NOT NULL").outputRowsCount(0.0).symbolStats("emptyRange", SymbolStatsAssertion::empty);
    }

    @Test
    public void testBetweenOperatorFilter() {
        this.assertExpression("x BETWEEN 7.5e0 AND 12e0").outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(7.5).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("x BETWEEN DOUBLE '-12' AND DOUBLE '-7.5'").outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x BETWEEN -12e0 AND -7.5e0").outputRowsCount(93.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-10.0).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x BETWEEN DOUBLE '-2.5' AND 2.5e0").outputRowsCount(187.5).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-2.5).highValue(2.5).nullsFraction(0.0));
        this.assertExpression("unknownRange BETWEEN 2.72e0 AND 3.14e0").outputRowsCount(112.5).symbolStats("unknownRange", symbolStats -> symbolStats.distinctValuesCount(6.25).lowValue(2.72).highValue(3.14).nullsFraction(0.0));
        this.assertExpression("leftOpen BETWEEN DOUBLE '-10' AND 10e0").outputRowsCount(180.0).symbolStats("leftOpen", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("rightOpen BETWEEN DOUBLE '-10' AND 10e0").outputRowsCount(180.0).symbolStats("rightOpen", symbolStats -> symbolStats.distinctValuesCount(10.0).lowValue(-10.0).highValue(10.0).nullsFraction(0.0));
        this.assertExpression("y BETWEEN 27.5e0 AND 107e0").outputRowsCount(0.0).symbolStats("y", SymbolStatsAssertion::empty);
        this.assertExpression("y BETWEEN DOUBLE '-100' AND 100e0").outputRowsCount(500.0).symbolStats("y", symbolStats -> symbolStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.0));
        this.assertExpression("z BETWEEN DOUBLE '-100' AND 100e0").outputRowsCount(900.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-100.0).highValue(100.0).nullsFraction(0.0));
        this.assertExpression("'a' IN ('a', 'b')").equalTo(this.standardInputStatistics);
        this.assertExpression("'a' IN ('b', 'c')").outputRowsCount(0.0);
        this.assertExpression("CAST('b' AS VARCHAR(3)) IN (CAST('a' AS VARCHAR(3)), CAST('b' AS VARCHAR(3)))").equalTo(this.standardInputStatistics);
        this.assertExpression("CAST('c' AS VARCHAR(3)) IN (CAST('a' AS VARCHAR(3)), CAST('b' AS VARCHAR(3)))").outputRowsCount(0.0);
    }

    @Test
    public void testSymbolEqualsSameSymbolFilter() {
        this.assertExpression("x = x").outputRowsCount(750.0).symbolStats("x", symbolStats -> SymbolStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).build());
    }

    @Test
    public void testInPredicateFilter() {
        this.assertExpression("x IN (7.5e0)").outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression("x IN (DOUBLE '-7.5')").outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x IN (BIGINT '2' + 5.5e0)").outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(7.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression("x IN (-7.5e0)").outputRowsCount(18.75).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(1.0).lowValue(-7.5).highValue(-7.5).nullsFraction(0.0));
        this.assertExpression("x IN (1.5e0, 2.5e0, 7.5e0)").outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0)).symbolStats("y", symbolStats -> symbolStats.distinctValuesCount(20.0).lowValue(0.0).highValue(5.0).nullsFraction(0.5));
        this.assertExpression("x IN (DOUBLE '-42', 1.5e0, 2.5e0, 7.5e0, 314e0)").outputRowsCount(56.25).symbolStats("x", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(1.5).highValue(7.5).nullsFraction(0.0));
        this.assertExpression("unknownRange IN (DOUBLE '-42', 1.5e0, 2.5e0, 7.5e0, 314e0)").outputRowsCount(90.0).symbolStats("unknownRange", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-42.0).highValue(314.0).nullsFraction(0.0));
        this.assertExpression(String.format("mediumVarchar IN (CAST('abc' AS %s))", MEDIUM_VARCHAR_TYPE.toString())).outputRowsCount(4.0).symbolStats("mediumVarchar", symbolStats -> symbolStats.distinctValuesCount(1.0).nullsFraction(0.0));
        this.assertExpression(String.format("mediumVarchar IN (CAST('abc' AS %1$s), CAST('def' AS %1$s))", MEDIUM_VARCHAR_TYPE.toString())).outputRowsCount(8.0).symbolStats("mediumVarchar", symbolStats -> symbolStats.distinctValuesCount(2.0).nullsFraction(0.0));
        this.assertExpression("y IN (DOUBLE '-42', 6e0, 31.1341e0, DOUBLE '-0.000000002', 314e0)").outputRowsCount(0.0).symbolStats("y", SymbolStatsAssertion::empty);
        this.assertExpression("z IN (DOUBLE '-1', 3.14e0, 0e0, 1e0, 2e0, 3e0, 4e0, 5e0, 6e0, 7e0, 8e0, DOUBLE '-2')").outputRowsCount(900.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(5.0).lowValue(-2.0).highValue(8.0).nullsFraction(0.0));
        this.assertExpression("z IN (DOUBLE '-1', 1e0, 0e0)").outputRowsCount(540.0).symbolStats("z", symbolStats -> symbolStats.distinctValuesCount(3.0).lowValue(-1.0).highValue(1.0).nullsFraction(0.0));
    }

    private PlanNodeStatsAssertion assertExpression(String expression) {
        return this.assertExpression(ExpressionTestUtils.planExpression(this.metadata, this.session, this.standardTypes, PlanBuilder.expression(expression)));
    }

    private PlanNodeStatsAssertion assertExpression(Expression expression) {
        return (PlanNodeStatsAssertion)TransactionBuilder.transaction((TransactionManager)new TestingTransactionManager(), (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, transactionSession -> PlanNodeStatsAssertion.assertThat(this.statsCalculator.filterStats(this.standardInputStatistics, expression, transactionSession, this.standardTypes)));
    }
}

