/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import io.prestosql.cost.BaseStatsCalculatorTest;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import org.testng.annotations.Test;

public class TestSortStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForSortNode() {
        PlanNodeStatsEstimate stats = PlanNodeStatsEstimate.builder().setOutputRowCount(100.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.3).setLowValue(1.0).setHighValue(30.0).setDistinctValuesCount(20.0).build()).addSymbolStatistics(new Symbol("b"), SymbolStatsEstimate.builder().setNullsFraction(0.6).setLowValue(13.5).setHighValue(Double.POSITIVE_INFINITY).setDistinctValuesCount(40.0).build()).build();
        this.tester().assertStatsFor(pb -> pb.output(outputBuilder -> {
            Symbol a = pb.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = pb.symbol("b", (Type)DoubleType.DOUBLE);
            outputBuilder.source((PlanNode)pb.values(a, b)).column(a, "a1").column(a, "a2").column(b, "b");
        })).withSourceStats(stats).check(outputStats -> outputStats.equalTo(stats));
    }
}

