/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.google.common.collect.ImmutableList;
import io.prestosql.cost.BaseStatsCalculatorTest;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.tree.Expression;
import io.prestosql.type.UnknownType;
import java.util.List;
import org.testng.annotations.Test;

public class TestValuesNodeStats
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForValuesNode() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT), (Object)pb.symbol("b", (Type)DoubleType.DOUBLE)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("3+3"), (Object)PlanBuilder.expression("13.5e0")), (Object)ImmutableList.of((Object)PlanBuilder.expression("55"), (Object)PlanBuilder.expression("null")), (Object)ImmutableList.of((Object)PlanBuilder.expression("6"), (Object)PlanBuilder.expression("13.5e0"))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(3.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.builder().setNullsFraction(0.0).setLowValue(6.0).setHighValue(55.0).setDistinctValuesCount(2.0).build()).addSymbolStatistics(new Symbol("b"), SymbolStatsEstimate.builder().setNullsFraction(0.3333333333333333).setLowValue(13.5).setHighValue(13.5).setDistinctValuesCount(1.0).build()).build()));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("v", (Type)VarcharType.createVarcharType((int)30))), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("'Alice'")), (Object)ImmutableList.of((Object)PlanBuilder.expression("'has'")), (Object)ImmutableList.of((Object)PlanBuilder.expression("'a cat'")), (Object)ImmutableList.of((Object)PlanBuilder.expression("null"))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(4.0).addSymbolStatistics(new Symbol("v"), SymbolStatsEstimate.builder().setNullsFraction(0.25).setDistinctValuesCount(3.0).build()).build()));
    }

    @Test
    public void testStatsForValuesNodeWithJustNulls() {
        PlanNodeStatsEstimate nullAStats = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.zero()).build();
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("3 + null"))))).check(outputStats -> outputStats.equalTo(nullAStats));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("null"))))).check(outputStats -> outputStats.equalTo(nullAStats));
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)UnknownType.UNKNOWN)), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)PlanBuilder.expression("null"))))).check(outputStats -> outputStats.equalTo(nullAStats));
    }

    @Test
    public void testStatsForEmptyValues() {
        this.tester().assertStatsFor(pb -> pb.values((List<Symbol>)ImmutableList.of((Object)pb.symbol("a", (Type)BigintType.BIGINT)), (List<List<Expression>>)ImmutableList.of())).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(0.0).addSymbolStatistics(new Symbol("a"), SymbolStatsEstimate.zero()).build()));
    }
}

