/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.CallTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.security.DenyAllAccessControl;
import io.prestosql.spi.block.MethodHandleUtil;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCallTask {
    private static ExecutorService executor;
    private static boolean invoked;

    @BeforeClass
    public void init() {
        executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"call-task-test-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void close() {
        executor.shutdownNow();
    }

    @BeforeMethod
    public void cleanup() {
        invoked = false;
    }

    @Test
    public void testExecute() {
        TransactionManager transactionManager = this.createTransactionManager();
        MetadataManager metadata = this.createMetadataManager(transactionManager);
        AllowAllAccessControl accessControl = new AllowAllAccessControl();
        QueryStateMachine stateMachine = this.stateMachine(transactionManager, metadata, (AccessControl)accessControl);
        Call procedure = this.getProcedureInvocation();
        new CallTask().execute(procedure, transactionManager, (Metadata)metadata, (AccessControl)accessControl, stateMachine, (List)ImmutableList.of());
        Assertions.assertThat((boolean)invoked).isTrue();
    }

    @Test
    public void testExecuteNoPermission() {
        TransactionManager transactionManager = this.createTransactionManager();
        MetadataManager metadata = this.createMetadataManager(transactionManager);
        DenyAllAccessControl accessControl = new DenyAllAccessControl();
        QueryStateMachine stateMachine = this.stateMachine(transactionManager, metadata, (AccessControl)accessControl);
        Call procedure = this.getProcedureInvocation();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestCallTask.lambda$testExecuteNoPermission$0(procedure, transactionManager, metadata, (AccessControl)accessControl, stateMachine)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot execute procedure test.test.testing_procedure");
        Assertions.assertThat((boolean)invoked).isFalse();
    }

    private Call getProcedureInvocation() {
        return new Call(QualifiedName.of((String)"testing_procedure"), (List)ImmutableList.of());
    }

    private MetadataManager createMetadataManager(TransactionManager transactionManager) {
        MetadataManager metadata = MetadataManager.createTestMetadataManager((TransactionManager)transactionManager, (FeaturesConfig)new FeaturesConfig());
        Procedure procedure = new Procedure("test", "testing_procedure", (List)ImmutableList.of(), MethodHandleUtil.methodHandle(TestCallTask.class, (String)"testingMethod", (Class[])new Class[0]));
        metadata.getProcedureRegistry().addProcedures(new CatalogName("test"), (Collection)ImmutableList.of((Object)procedure));
        return metadata;
    }

    private TransactionManager createTransactionManager() {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)"test"));
        return InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
    }

    private QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl) {
        return QueryStateMachine.begin((String)"CALL testing_procedure()", Optional.empty(), (Session)this.testSession(transactionManager), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP);
    }

    private Session testSession(TransactionManager transactionManager) {
        return TestingSession.testSessionBuilder().setCatalog("test").setSchema("test").setTransactionId(transactionManager.beginTransaction(true)).build();
    }

    public static void testingMethod() {
        invoked = true;
    }

    private static /* synthetic */ void lambda$testExecuteNoPermission$0(Call procedure, TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, QueryStateMachine stateMachine) throws Throwable {
        new CallTask().execute(procedure, transactionManager, (Metadata)metadata, accessControl, stateMachine, (List)ImmutableList.of());
    }
}

