/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.CreateSchemaTask;
import io.prestosql.metadata.AbstractMockMetadata;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.SchemaPropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateSchemaTask {
    private static final String CATALOG_NAME = "catalog";
    private Session testSession;
    MockMetadata metadata;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        SchemaPropertyManager schemaPropertyManager = new SchemaPropertyManager();
        schemaPropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of());
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(schemaPropertyManager, testCatalog.getConnectorCatalogName());
    }

    @Test
    public void testDuplicatedCreateSchema() {
        String schemaName = "test_db";
        CreateSchema statement = new CreateSchema(QualifiedName.of((String)schemaName), false, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateSchemaCount(), (int)1);
        Assertions.assertThatExceptionOfType(PrestoException.class).isThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()))).withMessage("Schema already exists");
    }

    @Test
    public void testDuplicatedCreateSchemaIfNotExists() {
        String schemaName = "test_db";
        CreateSchema statement = new CreateSchema(QualifiedName.of((String)schemaName), true, (List)ImmutableList.of());
        MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateSchemaCount(), (int)1);
        MoreFutures.getFutureValue((Future)new CreateSchemaTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateSchemaCount(), (int)1);
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final CatalogName catalogHandle;
        private final List<CatalogSchemaName> schemas;
        private SchemaPropertyManager schemaPropertyManager;

        public MockMetadata(SchemaPropertyManager schemaPropertyManager, CatalogName catalogHandle) {
            this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.schemas = new CopyOnWriteArrayList<CatalogSchemaName>();
        }

        @Override
        public SchemaPropertyManager getSchemaPropertyManager() {
            return this.schemaPropertyManager;
        }

        @Override
        public boolean schemaExists(Session session, CatalogSchemaName schema) {
            return false;
        }

        @Override
        public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, PrestoPrincipal principal) {
            if (this.schemas.contains(schema)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Schema already exists");
            }
            this.schemas.add(schema);
        }

        @Override
        public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        public int getCreateSchemaCount() {
            return this.schemas.size();
        }
    }
}

