/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.CreateTableTask;
import io.prestosql.metadata.AbstractMockMetadata;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.ColumnPropertyManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TablePropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorCapabilities;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.tree.ColumnDefinition;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateTableTask {
    private static final String CATALOG_NAME = "catalog";
    private Session testSession;
    private MockMetadata metadata;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        ColumnPropertyManager columnPropertyManager = new ColumnPropertyManager();
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        tablePropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        columnPropertyManager.addProperties(testCatalog.getConnectorCatalogName(), (List)ImmutableList.of());
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        this.metadata = new MockMetadata(tablePropertyManager, columnPropertyManager, testCatalog.getConnectorCatalogName(), Collections.emptySet());
    }

    @Test
    public void testCreateTableNotExistsTrue() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateTableNotExistsFalse() {
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT), true, Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of(), Optional.empty());
        try {
            MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e instanceof PrestoException));
            PrestoException prestoException = (PrestoException)((Object)e);
            Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode());
        }
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
    }

    @Test
    public void testCreateWithNotNullColumns() {
        this.metadata.setConnectorCapabilities(ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT);
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)inputColumns, true, (List)ImmutableList.of(), Optional.empty());
        MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()));
        Assert.assertEquals((int)this.metadata.getCreateTableCallCount(), (int)1);
        List columns = this.metadata.getReceivedTableMetadata().get(0).getColumns();
        Assert.assertEquals((int)columns.size(), (int)3);
        Assert.assertEquals((String)((ColumnMetadata)columns.get(0)).getName(), (String)"a");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(0)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"DATE");
        Assert.assertTrue((boolean)((ColumnMetadata)columns.get(0)).isNullable());
        Assert.assertEquals((String)((ColumnMetadata)columns.get(1)).getName(), (String)"b");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(1)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"VARCHAR");
        Assert.assertFalse((boolean)((ColumnMetadata)columns.get(1)).isNullable());
        Assert.assertEquals((String)((ColumnMetadata)columns.get(2)).getName(), (String)"c");
        Assert.assertEquals((String)((ColumnMetadata)columns.get(2)).getType().getDisplayName().toUpperCase(Locale.ENGLISH), (String)"VARBINARY");
        Assert.assertFalse((boolean)((ColumnMetadata)columns.get(2)).isNullable());
    }

    @Test
    public void testCreateWithUnsupportedConnectorThrowsWhenNotNull() {
        ImmutableList inputColumns = ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TypeSignatureTranslator.toSqlType((Type)DateType.DATE), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR), false, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TypeSignatureTranslator.toSqlType((Type)VarbinaryType.VARBINARY), false, Collections.emptyList(), Optional.empty()));
        CreateTable statement = new CreateTable(QualifiedName.of((String)"test_table"), (List)inputColumns, true, (List)ImmutableList.of(), Optional.empty());
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> MoreFutures.getFutureValue((Future)new CreateTableTask().internalExecute(statement, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), this.testSession, Collections.emptyList()))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage("Catalog 'catalog' does not support non-null column for column name 'b'");
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final MetadataManager metadata;
        private final TablePropertyManager tablePropertyManager;
        private final ColumnPropertyManager columnPropertyManager;
        private final CatalogName catalogHandle;
        private final List<ConnectorTableMetadata> tables = new CopyOnWriteArrayList<ConnectorTableMetadata>();
        private Set<ConnectorCapabilities> connectorCapabilities;

        public MockMetadata(TablePropertyManager tablePropertyManager, ColumnPropertyManager columnPropertyManager, CatalogName catalogHandle, Set<ConnectorCapabilities> connectorCapabilities) {
            this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
            this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
            this.connectorCapabilities = (Set)Objects.requireNonNull(Sets.immutableEnumSet(connectorCapabilities), "connectorCapabilities is null");
            this.metadata = MetadataManager.createTestMetadataManager();
        }

        @Override
        public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
            this.tables.add(tableMetadata);
            if (!ignoreExisting) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Table already exists");
            }
        }

        @Override
        public TablePropertyManager getTablePropertyManager() {
            return this.tablePropertyManager;
        }

        @Override
        public ColumnPropertyManager getColumnPropertyManager() {
            return this.columnPropertyManager;
        }

        @Override
        public Type getType(TypeSignature signature) {
            return this.metadata.getType(signature);
        }

        @Override
        public Type getType(TypeId id) {
            return this.metadata.getType(id);
        }

        @Override
        public Type fromSqlType(String sqlType) {
            return this.metadata.fromSqlType(sqlType);
        }

        @Override
        public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            return Optional.empty();
        }

        public int getCreateTableCallCount() {
            return this.tables.size();
        }

        public List<ConnectorTableMetadata> getReceivedTableMetadata() {
            return this.tables;
        }

        @Override
        public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogName catalogName) {
            return this.connectorCapabilities;
        }

        public void setConnectorCapabilities(ConnectorCapabilities ... connectorCapabilities) {
            this.connectorCapabilities = Sets.immutableEnumSet((Iterable)ImmutableList.copyOf((Object[])connectorCapabilities));
        }
    }
}

