/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Functions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.concurrent.Threads;
import io.airlift.stats.CounterStat;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.execution.MemoryRevokingScheduler;
import io.prestosql.execution.SqlTask;
import io.prestosql.execution.SqlTaskExecutionFactory;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.execution.TaskTestUtils;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.PipelineContext;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.sql.planner.LocalExecutionPlanner;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingSession;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMemoryRevokingScheduler {
    private final AtomicInteger idGeneator = new AtomicInteger();
    private final Session session = TestingSession.testSessionBuilder().build();
    private final SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
    private ScheduledExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private MemoryPool memoryPool;
    private Set<OperatorContext> allOperatorContexts;

    @BeforeMethod
    public void setUp() {
        this.memoryPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, DataSize.ofBytes((long)10L));
        TaskExecutor taskExecutor = new TaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        taskExecutor.start();
        this.executor = Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"task-notification-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"task-notification-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.executor, taskExecutor, planner, TaskTestUtils.createTestSplitMonitor(), new TaskManagerConfig());
        this.allOperatorContexts = null;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.memoryPool = null;
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testScheduleMemoryRevoking() throws Exception {
        SqlTask sqlTask1 = this.newSqlTask();
        SqlTask sqlTask2 = this.newSqlTask();
        TaskContext taskContext1 = sqlTask1.getQueryContext().addTaskContext(new TaskStateMachine(new TaskId("q1", 1, 1), (Executor)this.executor), this.session, false, false, OptionalInt.empty());
        PipelineContext pipelineContext11 = taskContext1.addPipelineContext(0, false, false, false);
        DriverContext driverContext111 = pipelineContext11.addDriverContext();
        OperatorContext operatorContext1 = driverContext111.addOperatorContext(1, new PlanNodeId("na"), "na");
        OperatorContext operatorContext2 = driverContext111.addOperatorContext(2, new PlanNodeId("na"), "na");
        DriverContext driverContext112 = pipelineContext11.addDriverContext();
        OperatorContext operatorContext3 = driverContext112.addOperatorContext(3, new PlanNodeId("na"), "na");
        TaskContext taskContext2 = sqlTask2.getQueryContext().addTaskContext(new TaskStateMachine(new TaskId("q2", 1, 1), (Executor)this.executor), this.session, false, false, OptionalInt.empty());
        PipelineContext pipelineContext21 = taskContext2.addPipelineContext(1, false, false, false);
        DriverContext driverContext211 = pipelineContext21.addDriverContext();
        OperatorContext operatorContext4 = driverContext211.addOperatorContext(4, new PlanNodeId("na"), "na");
        OperatorContext operatorContext5 = driverContext211.addOperatorContext(5, new PlanNodeId("na"), "na");
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testScheduleMemoryRevoking$0((Collection)tasks), this.executor, 1.0, 1.0);
        this.allOperatorContexts = ImmutableSet.of((Object)operatorContext1, (Object)operatorContext2, (Object)operatorContext3, (Object)operatorContext4, (Object)operatorContext5);
        this.assertMemoryRevokingNotRequested();
        this.requestMemoryRevoking(scheduler);
        Assert.assertEquals((long)10L, (long)this.memoryPool.getFreeBytes());
        this.assertMemoryRevokingNotRequested();
        LocalMemoryContext revocableMemory1 = operatorContext1.localRevocableMemoryContext();
        LocalMemoryContext revocableMemory3 = operatorContext3.localRevocableMemoryContext();
        LocalMemoryContext revocableMemory4 = operatorContext4.localRevocableMemoryContext();
        LocalMemoryContext revocableMemory5 = operatorContext5.localRevocableMemoryContext();
        revocableMemory1.setBytes(3L);
        revocableMemory3.setBytes(6L);
        Assert.assertEquals((long)1L, (long)this.memoryPool.getFreeBytes());
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingNotRequested();
        revocableMemory4.setBytes(7L);
        Assert.assertEquals((long)-6L, (long)this.memoryPool.getFreeBytes());
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext3);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext3);
        revocableMemory1.setBytes(0L);
        operatorContext1.resetMemoryRevokingRequested();
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext3);
        Assert.assertEquals((long)-3L, (long)this.memoryPool.getFreeBytes());
        revocableMemory5.setBytes(3L);
        Assert.assertEquals((long)-6L, (long)this.memoryPool.getFreeBytes());
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext3);
        revocableMemory5.setBytes(4L);
        Assert.assertEquals((long)-7L, (long)this.memoryPool.getFreeBytes());
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext3, operatorContext4);
    }

    @Test
    public void testCountAlreadyRevokedMemoryWithinAPool() throws Exception {
        SqlTask sqlTask1 = this.newSqlTask();
        MemoryPool anotherMemoryPool = new MemoryPool(new MemoryPoolId("test"), DataSize.ofBytes((long)10L));
        sqlTask1.getQueryContext().setMemoryPool(anotherMemoryPool);
        OperatorContext operatorContext1 = this.createContexts(sqlTask1);
        SqlTask sqlTask2 = this.newSqlTask();
        OperatorContext operatorContext2 = this.createContexts(sqlTask2);
        ImmutableList tasks = ImmutableList.of((Object)sqlTask1, (Object)sqlTask2);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Arrays.asList(this.memoryPool, anotherMemoryPool), () -> TestMemoryRevokingScheduler.lambda$testCountAlreadyRevokedMemoryWithinAPool$1((List)tasks), this.executor, 1.0, 1.0);
        this.allOperatorContexts = ImmutableSet.of((Object)operatorContext1, (Object)operatorContext2);
        operatorContext1.localRevocableMemoryContext().setBytes(12L);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext1);
        operatorContext2.localRevocableMemoryContext().setBytes(12L);
        this.requestMemoryRevoking(scheduler);
        this.assertMemoryRevokingRequestedFor(operatorContext1, operatorContext2);
    }

    @Test
    public void testImmediateMemoryRevoking() throws Exception {
        SqlTask sqlTask = this.newSqlTask();
        OperatorContext operatorContext = this.createContexts(sqlTask);
        this.allOperatorContexts = ImmutableSet.of((Object)operatorContext);
        ImmutableList tasks = ImmutableList.of((Object)sqlTask);
        MemoryRevokingScheduler scheduler = new MemoryRevokingScheduler(Collections.singletonList(this.memoryPool), () -> TestMemoryRevokingScheduler.lambda$testImmediateMemoryRevoking$2((List)tasks), this.executor, 1.0, 1.0);
        scheduler.registerPoolListeners();
        operatorContext.localRevocableMemoryContext().setBytes(12L);
        this.awaitAsynchronousCallbacksRun();
        this.assertMemoryRevokingRequestedFor(operatorContext);
    }

    private OperatorContext createContexts(SqlTask sqlTask) {
        TaskContext taskContext = sqlTask.getQueryContext().addTaskContext(new TaskStateMachine(new TaskId("q", 1, 1), (Executor)this.executor), this.session, false, false, OptionalInt.empty());
        PipelineContext pipelineContext = taskContext.addPipelineContext(0, false, false, false);
        DriverContext driverContext = pipelineContext.addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(1, new PlanNodeId("na"), "na");
        return operatorContext;
    }

    private void requestMemoryRevoking(MemoryRevokingScheduler scheduler) throws Exception {
        scheduler.requestMemoryRevokingIfNeeded();
        this.awaitAsynchronousCallbacksRun();
    }

    private void awaitAsynchronousCallbacksRun() throws Exception {
        this.executor.invokeAll(Collections.singletonList(() -> null));
    }

    private void assertMemoryRevokingRequestedFor(OperatorContext ... operatorContexts) {
        ImmutableSet operatorContextsSet = ImmutableSet.copyOf((Object[])operatorContexts);
        operatorContextsSet.forEach(operatorContext -> Assert.assertTrue((boolean)operatorContext.isMemoryRevokingRequested(), (String)("expected memory requested for operator " + operatorContext.getOperatorId())));
        Sets.difference(this.allOperatorContexts, (Set)operatorContextsSet).forEach(operatorContext -> Assert.assertFalse((boolean)operatorContext.isMemoryRevokingRequested(), (String)("expected memory  not requested for operator " + operatorContext.getOperatorId())));
    }

    private void assertMemoryRevokingNotRequested() {
        this.assertMemoryRevokingRequestedFor(new OperatorContext[0]);
    }

    private SqlTask newSqlTask() {
        TaskId taskId = new TaskId("query", 0, this.idGeneator.incrementAndGet());
        URI location = URI.create("fake://task/" + taskId);
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)new QueryContext(new QueryId("query"), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE), this.memoryPool, (GcMonitor)new TestingGcMonitor(), (Executor)this.executor, this.scheduledExecutor, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE), this.spillSpaceTracker), (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExecutorService)this.executor, (Function)Functions.identity(), (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (CounterStat)new CounterStat());
    }

    private static /* synthetic */ Collection lambda$testImmediateMemoryRevoking$2(List tasks) {
        return tasks;
    }

    private static /* synthetic */ Collection lambda$testCountAlreadyRevokedMemoryWithinAPool$1(List tasks) {
        return tasks;
    }

    private static /* synthetic */ Collection lambda$testScheduleMemoryRevoking$0(Collection tasks) {
        return tasks;
    }
}

