/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import io.prestosql.execution.ParameterExtractor;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestParameterExtractor {
    private final SqlParser sqlParser = new SqlParser();

    @Test
    public void testNoParameter() {
        Statement statement = this.sqlParser.createStatement("SELECT c1, c2 FROM test_table WHERE c1 = 1 AND c2 > 2", new ParsingOptions());
        Assertions.assertThat((List)ParameterExtractor.getParameters((Statement)statement)).isEmpty();
        Assertions.assertThat((int)ParameterExtractor.getParameterCount((Statement)statement)).isEqualTo(0);
    }

    @Test
    public void testParameterCount() {
        Statement statement = this.sqlParser.createStatement("SELECT c1, c2 FROM test_table WHERE c1 = ? AND c2 > ?", new ParsingOptions());
        Assertions.assertThat((List)ParameterExtractor.getParameters((Statement)statement)).containsExactly((Object[])new Parameter[]{new Parameter(new NodeLocation(1, 41), 0), new Parameter(new NodeLocation(1, 52), 1)});
        Assertions.assertThat((int)ParameterExtractor.getParameterCount((Statement)statement)).isEqualTo(2);
    }
}

