/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.execution.QueryManagerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestQueryManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((QueryManagerConfig)ConfigAssertions.recordDefaults(QueryManagerConfig.class)).setMinQueryExpireAge(new Duration(15.0, TimeUnit.MINUTES)).setMaxQueryHistory(100).setMaxQueryLength(1000000).setMaxStageCount(100).setStageCountWarningThreshold(50).setClientTimeout(new Duration(5.0, TimeUnit.MINUTES)).setScheduleSplitBatchSize(1000).setMinScheduleSplitBatchSize(100).setMaxConcurrentQueries(1000).setMaxQueuedQueries(5000).setInitialHashPartitions(100).setQueryManagerExecutorPoolSize(5).setRemoteTaskMinErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxErrorDuration(new Duration(5.0, TimeUnit.MINUTES)).setRemoteTaskMaxCallbackThreads(1000).setQueryExecutionPolicy("all-at-once").setQueryMaxRunTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxExecutionTime(new Duration(100.0, TimeUnit.DAYS)).setQueryMaxCpuTime(new Duration(1.0E9, TimeUnit.DAYS)).setRequiredWorkers(1).setRequiredWorkersMaxWait(new Duration(5.0, TimeUnit.MINUTES)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"query.client.timeout", (Object)"10s").put((Object)"query.min-expire-age", (Object)"30s").put((Object)"query.max-history", (Object)"10").put((Object)"query.max-length", (Object)"10000").put((Object)"query.max-stage-count", (Object)"12345").put((Object)"query.stage-count-warning-threshold", (Object)"12300").put((Object)"query.schedule-split-batch-size", (Object)"99").put((Object)"query.min-schedule-split-batch-size", (Object)"9").put((Object)"query.max-concurrent-queries", (Object)"10").put((Object)"query.max-queued-queries", (Object)"15").put((Object)"query.initial-hash-partitions", (Object)"16").put((Object)"query.manager-executor-pool-size", (Object)"11").put((Object)"query.remote-task.min-error-duration", (Object)"30s").put((Object)"query.remote-task.max-error-duration", (Object)"60s").put((Object)"query.remote-task.max-callback-threads", (Object)"10").put((Object)"query.execution-policy", (Object)"phased").put((Object)"query.max-run-time", (Object)"2h").put((Object)"query.max-execution-time", (Object)"3h").put((Object)"query.max-cpu-time", (Object)"2d").put((Object)"query-manager.required-workers", (Object)"333").put((Object)"query-manager.required-workers-max-wait", (Object)"33m").build();
        QueryManagerConfig expected = new QueryManagerConfig().setMinQueryExpireAge(new Duration(30.0, TimeUnit.SECONDS)).setMaxQueryHistory(10).setMaxQueryLength(10000).setMaxStageCount(12345).setStageCountWarningThreshold(12300).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setScheduleSplitBatchSize(99).setMinScheduleSplitBatchSize(9).setMaxConcurrentQueries(10).setMaxQueuedQueries(15).setInitialHashPartitions(16).setQueryManagerExecutorPoolSize(11).setRemoteTaskMinErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxErrorDuration(new Duration(60.0, TimeUnit.SECONDS)).setRemoteTaskMaxCallbackThreads(10).setQueryExecutionPolicy("phased").setQueryMaxRunTime(new Duration(2.0, TimeUnit.HOURS)).setQueryMaxExecutionTime(new Duration(3.0, TimeUnit.HOURS)).setQueryMaxCpuTime(new Duration(2.0, TimeUnit.DAYS)).setRequiredWorkers(333).setRequiredWorkersMaxWait(new Duration(33.0, TimeUnit.MINUTES));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

