/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.prestosql.Session;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.SetRoleTask;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.SetRole;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSetRoleTask {
    private static final String CATALOG_NAME = "foo";
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private ExecutorService executor;
    private SqlParser parser;

    @BeforeClass
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)CATALOG_NAME));
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-set-role-task-executor-%s"));
        this.parser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.metadata = null;
        this.accessControl = null;
        this.transactionManager = null;
        this.parser = null;
    }

    @Test
    public void testSetRole() {
        this.assertSetRole("SET ROLE ALL", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
        this.assertSetRole("SET ROLE bar", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("bar"))));
    }

    @Test
    public void testSetRoleInvalidCatalog() {
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.executeSetRole("invalid", "SET ROLE foo")).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND).hasMessage("Catalog does not exist: invalid");
    }

    private void assertSetRole(String statement, Map<String, SelectedRole> expected) {
        QueryStateMachine stateMachine = this.executeSetRole(CATALOG_NAME, statement);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Map)queryInfo.getSetRoles(), expected);
    }

    private QueryStateMachine executeSetRole(String catalog, String statement) {
        SetRole setRole = (SetRole)this.parser.createStatement(statement, new ParsingOptions());
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)statement, Optional.empty(), (Session)TestingSession.testSessionBuilder().setCatalog(catalog).build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
        new SetRoleTask().execute(setRole, this.transactionManager, this.metadata, this.accessControl, stateMachine, (List)ImmutableList.of());
        return stateMachine;
    }
}

