/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Functions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.stats.CounterStat;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.SqlTask;
import io.prestosql.execution.SqlTaskExecutionFactory;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TaskState;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.execution.TaskTestUtils;
import io.prestosql.execution.buffer.BufferResult;
import io.prestosql.execution.buffer.BufferState;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spiller.SpillSpaceTracker;
import io.prestosql.sql.planner.LocalExecutionPlanner;
import io.prestosql.testing.TestingSession;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSqlTask {
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private final TaskExecutor taskExecutor;
    private final ScheduledExecutorService taskNotificationExecutor;
    private final ScheduledExecutorService driverYieldExecutor;
    private final SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicInteger nextTaskId = new AtomicInteger();

    public TestSqlTask() {
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        this.driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.taskNotificationExecutor, this.taskExecutor, planner, TaskTestUtils.createTestSplitMonitor(), new TaskManagerConfig());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        this.taskExecutor.stop();
        this.taskNotificationExecutor.shutdownNow();
        this.driverYieldExecutor.shutdown();
    }

    @Test
    public void testEmptyQuery() {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), OptionalInt.empty());
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), OptionalInt.empty());
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testSimpleQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), OptionalInt.empty());
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        BufferResult results = (BufferResult)sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get();
        Assert.assertEquals((boolean)results.isBufferComplete(), (boolean)false);
        Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
        Assert.assertEquals((int)((SerializedPage)results.getSerializedPages().get(0)).getPositionCount(), (int)1);
        boolean moreResults = true;
        while (moreResults) {
            moreResults = !(results = (BufferResult)sqlTask.getTaskResults(OUT, results.getToken() + (long)results.getSerializedPages().size(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
        }
        Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
        TaskInfo info = sqlTask.abortTaskResults(OUT);
        Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testCancel() {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), OptionalInt.empty());
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.cancel();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
        Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
        Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
    }

    @Test
    public void testAbort() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), OptionalInt.empty());
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        sqlTask.abortTaskResults(OUT);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testBufferCloseOnFinish() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        OutputBuffers outputBuffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, outputBuffers);
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        TaskTestUtils.updateTask(sqlTask, (List<TaskSource>)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), outputBuffers);
        sqlTask.abortTaskResults(OUT);
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assert.assertTrue((boolean)bufferResult.isDone());
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferComplete());
    }

    @Test
    public void testBufferCloseOnCancel() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        sqlTask.cancel();
        Assert.assertEquals((Object)sqlTask.getTaskInfo().getTaskStatus().getState(), (Object)TaskState.CANCELED);
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assert.assertTrue((boolean)bufferResult.isDone());
        Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferComplete());
    }

    @Test
    public void testBufferNotCloseOnFail() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SOURCES, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assert.assertFalse((boolean)bufferResult.isDone());
        TaskState taskState = sqlTask.getTaskInfo().getTaskStatus().getState();
        sqlTask.failed((Throwable)new Exception("test"));
        Assert.assertEquals((Object)((TaskInfo)sqlTask.getTaskInfo(taskState).get(1L, TimeUnit.SECONDS)).getTaskStatus().getState(), (Object)TaskState.FAILED);
        try {
            Assert.assertTrue((boolean)((BufferResult)bufferResult.get(1L, TimeUnit.SECONDS)).isBufferComplete());
            Assert.fail((String)"expected TimeoutException");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).isDone());
    }

    private SqlTask createInitialTask() {
        TaskId taskId = new TaskId("query", 0, this.nextTaskId.incrementAndGet());
        URI location = URI.create("fake://task/" + taskId);
        QueryContext queryContext = new QueryContext(new QueryId("query"), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new MemoryPool(new MemoryPoolId("test"), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)this.taskNotificationExecutor, this.driverYieldExecutor, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        queryContext.addTaskContext(new TaskStateMachine(taskId, (Executor)this.taskNotificationExecutor), TestingSession.testSessionBuilder().build(), false, false, OptionalInt.empty());
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)queryContext, (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExecutorService)this.taskNotificationExecutor, (Function)Functions.identity(), (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (CounterStat)new CounterStat());
    }
}

