/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.node.NodeInfo;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.ScheduledSplit;
import io.prestosql.execution.SqlTaskManager;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagementExecutor;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TaskState;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.execution.TaskTestUtils;
import io.prestosql.execution.buffer.BufferResult;
import io.prestosql.execution.buffer.BufferState;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.execution.executor.TaskExecutor;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.NodeMemoryConfig;
import io.prestosql.memory.context.LocalMemoryContext;
import io.prestosql.metadata.InternalNode;
import io.prestosql.operator.ExchangeClient;
import io.prestosql.operator.ExchangeClientSupplier;
import io.prestosql.spi.QueryId;
import io.prestosql.spiller.LocalSpillManager;
import io.prestosql.spiller.NodeSpillConfig;
import io.prestosql.testing.TestingSession;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test
public class TestSqlTaskManager {
    private static final TaskId TASK_ID = new TaskId("query", 0, 1);
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private final TaskExecutor taskExecutor;
    private final TaskManagementExecutor taskManagementExecutor;
    private final LocalMemoryManager localMemoryManager = new LocalMemoryManager(new NodeMemoryConfig());
    private final LocalSpillManager localSpillManager = new LocalSpillManager(new NodeSpillConfig());

    public TestSqlTaskManager() {
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskManagementExecutor = new TaskManagementExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.taskExecutor.stop();
        this.taskManagementExecutor.close();
    }

    @Test
    public void testEmptyQuery() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testSimpleQuery() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            BufferResult results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get();
            Assert.assertEquals((boolean)results.isBufferComplete(), (boolean)false);
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
            Assert.assertEquals((int)((SerializedPage)results.getSerializedPages().get(0)).getPositionCount(), (int)1);
            boolean moreResults = true;
            while (moreResults) {
                moreResults = !(results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, results.getToken() + (long)results.getSerializedPages().size(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
            }
            Assert.assertEquals((boolean)results.isBufferComplete(), (boolean)true);
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
            TaskInfo info = sqlTaskManager.abortTaskResults(taskId, OUT);
            Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testCancel() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbort() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.abortTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbortResults() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            sqlTaskManager.abortTaskResults(taskId, OUT);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getState()).get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testRemoveOldTasks() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig().setInfoMaxAge(new Duration(5.0, TimeUnit.MILLISECONDS)));){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Thread.sleep(100L);
            sqlTaskManager.removeOldTasks();
            for (TaskInfo info : sqlTaskManager.getAllTaskInfo()) {
                Assert.assertNotEquals((Object)info.getTaskStatus().getTaskId(), (Object)taskId);
            }
        }
    }

    private SqlTaskManager createSqlTaskManager(TaskManagerConfig config) {
        return new SqlTaskManager(TaskTestUtils.createTestingPlanner(), (LocationFactory)new MockLocationFactory(), this.taskExecutor, TaskTestUtils.createTestSplitMonitor(), new NodeInfo("test"), this.localMemoryManager, this.taskManagementExecutor, config, new NodeMemoryConfig(), this.localSpillManager, new NodeSpillConfig(), (GcMonitor)new TestingGcMonitor());
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, ImmutableSet<ScheduledSplit> splits, OutputBuffers outputBuffers) {
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, splits, true)), outputBuffers, OptionalInt.empty());
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, OutputBuffers outputBuffers) {
        sqlTaskManager.getQueryContext(taskId.getQueryId()).addTaskContext(new TaskStateMachine(taskId, MoreExecutors.directExecutor()), TestingSession.testSessionBuilder().build(), false, false, OptionalInt.empty());
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), outputBuffers, OptionalInt.empty());
    }

    public static class MockLocationFactory
    implements LocationFactory {
        public URI createQueryLocation(QueryId queryId) {
            return URI.create("http://fake.invalid/query/" + queryId);
        }

        public URI createLocalTaskLocation(TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + taskId);
        }

        public URI createTaskLocation(InternalNode node, TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + node.getNodeIdentifier() + "/" + taskId);
        }

        public URI createMemoryInfoLocation(InternalNode node) {
            return URI.create("http://fake.invalid/" + node.getNodeIdentifier() + "/memory");
        }
    }

    public static class MockExchangeClientSupplier
    implements ExchangeClientSupplier {
        public ExchangeClient get(LocalMemoryContext systemMemoryContext) {
            throw new UnsupportedOperationException();
        }
    }
}

