/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.execution.StageStats;
import io.prestosql.spi.eventlistener.StageGcStatistics;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStageStats {
    private static final StageStats EXPECTED = new StageStats(new DateTime(0L), TestStageStats.getTestDistribution(1), 4, 5, 6, 7, 8, 10, 26, 11, 12.0, DataSize.ofBytes((long)13L), DataSize.ofBytes((long)14L), DataSize.ofBytes((long)15L), DataSize.ofBytes((long)16L), DataSize.ofBytes((long)17L), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)191L), 201L, new Duration(15.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)192L), 202L, DataSize.ofBytes((long)19L), 20L, DataSize.ofBytes((long)21L), 22L, DataSize.ofBytes((long)23L), DataSize.ofBytes((long)24L), 25L, DataSize.ofBytes((long)26L), new StageGcStatistics(101, 102, 103, 104, 105, 106, 107), (List)ImmutableList.of());

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(StageStats.class);
        String json = codec.toJson((Object)EXPECTED);
        StageStats actual = (StageStats)codec.fromJson(json);
        TestStageStats.assertExpectedStageStats(actual);
    }

    private static void assertExpectedStageStats(StageStats actual) {
        Assert.assertEquals((long)actual.getSchedulingComplete().getMillis(), (long)0L);
        Assert.assertEquals((Object)actual.getGetSplitDistribution().getCount(), (Object)1.0);
        Assert.assertEquals((int)actual.getTotalTasks(), (int)4);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)5);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)6);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)10);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)26);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)11);
        Assert.assertEquals((Object)actual.getCumulativeUserMemory(), (Object)12.0);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)DataSize.ofBytes((long)13L));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)14L));
        Assert.assertEquals((Object)actual.getTotalMemoryReservation(), (Object)DataSize.ofBytes((long)15L));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)DataSize.ofBytes((long)16L));
        Assert.assertEquals((Object)actual.getPeakRevocableMemoryReservation(), (Object)DataSize.ofBytes((long)17L));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getPhysicalInputDataSize(), (Object)DataSize.ofBytes((long)191L));
        Assert.assertEquals((long)actual.getPhysicalInputPositions(), (long)201L);
        Assert.assertEquals((Object)actual.getPhysicalInputReadTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getInternalNetworkInputDataSize(), (Object)DataSize.ofBytes((long)192L));
        Assert.assertEquals((long)actual.getInternalNetworkInputPositions(), (long)202L);
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)DataSize.ofBytes((long)19L));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)20L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)DataSize.ofBytes((long)21L));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)22L);
        Assert.assertEquals((Object)actual.getBufferedDataSize(), (Object)DataSize.ofBytes((long)23L));
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)DataSize.ofBytes((long)24L));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)25L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)DataSize.ofBytes((long)26L));
        Assert.assertEquals((int)actual.getGcInfo().getStageId(), (int)101);
        Assert.assertEquals((int)actual.getGcInfo().getTasks(), (int)102);
        Assert.assertEquals((int)actual.getGcInfo().getFullGcTasks(), (int)103);
        Assert.assertEquals((int)actual.getGcInfo().getMinFullGcSec(), (int)104);
        Assert.assertEquals((int)actual.getGcInfo().getMaxFullGcSec(), (int)105);
        Assert.assertEquals((int)actual.getGcInfo().getTotalFullGcSec(), (int)106);
        Assert.assertEquals((int)actual.getGcInfo().getAverageFullGcSec(), (int)107);
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

