/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.execution.TaskManagerConfig;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestTaskManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((TaskManagerConfig)ConfigAssertions.recordDefaults(TaskManagerConfig.class)).setInitialSplitsPerNode(Runtime.getRuntime().availableProcessors() * 2).setSplitConcurrencyAdjustmentInterval(new Duration(100.0, TimeUnit.MILLISECONDS)).setStatusRefreshMaxWait(new Duration(1.0, TimeUnit.SECONDS)).setInfoUpdateInterval(new Duration(3.0, TimeUnit.SECONDS)).setPerOperatorCpuTimerEnabled(true).setTaskCpuTimerEnabled(true).setMaxWorkerThreads(Runtime.getRuntime().availableProcessors() * 2).setMinDrivers(Runtime.getRuntime().availableProcessors() * 2 * 2).setMinDriversPerTask(3).setMaxDriversPerTask(Integer.MAX_VALUE).setInfoMaxAge(new Duration(15.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(2.0, TimeUnit.MINUTES)).setMaxIndexMemoryUsage(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setShareIndexLoading(false).setMaxPartialAggregationMemoryUsage(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxLocalExchangeBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setSinkMaxBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPagePartitioningBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setWriterCount(1).setTaskConcurrency(16).setHttpResponseThreads(100).setHttpTimeoutThreads(3).setTaskNotificationThreads(5).setTaskYieldThreads(3).setLevelTimeMultiplier(new BigDecimal("2")).setStatisticsCpuTimerEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"task.initial-splits-per-node", (Object)"1").put((Object)"task.split-concurrency-adjustment-interval", (Object)"1s").put((Object)"task.status-refresh-max-wait", (Object)"2s").put((Object)"task.info-update-interval", (Object)"2s").put((Object)"task.per-operator-cpu-timer-enabled", (Object)"false").put((Object)"task.cpu-timer-enabled", (Object)"false").put((Object)"task.max-index-memory", (Object)"512MB").put((Object)"task.share-index-loading", (Object)"true").put((Object)"task.max-partial-aggregation-memory", (Object)"32MB").put((Object)"task.max-local-exchange-buffer-size", (Object)"33MB").put((Object)"task.max-worker-threads", (Object)"3").put((Object)"task.min-drivers", (Object)"2").put((Object)"task.min-drivers-per-task", (Object)"5").put((Object)"task.max-drivers-per-task", (Object)"13").put((Object)"task.info.max-age", (Object)"22m").put((Object)"task.client.timeout", (Object)"10s").put((Object)"sink.max-buffer-size", (Object)"42MB").put((Object)"driver.max-page-partitioning-buffer-size", (Object)"40MB").put((Object)"task.writer-count", (Object)"4").put((Object)"task.concurrency", (Object)"8").put((Object)"task.http-response-threads", (Object)"4").put((Object)"task.http-timeout-threads", (Object)"10").put((Object)"task.task-notification-threads", (Object)"13").put((Object)"task.task-yield-threads", (Object)"8").put((Object)"task.level-time-multiplier", (Object)"2.1").put((Object)"task.statistics-cpu-timer-enabled", (Object)"false").build();
        TaskManagerConfig expected = new TaskManagerConfig().setInitialSplitsPerNode(1).setSplitConcurrencyAdjustmentInterval(new Duration(1.0, TimeUnit.SECONDS)).setStatusRefreshMaxWait(new Duration(2.0, TimeUnit.SECONDS)).setInfoUpdateInterval(new Duration(2.0, TimeUnit.SECONDS)).setPerOperatorCpuTimerEnabled(false).setTaskCpuTimerEnabled(false).setMaxIndexMemoryUsage(DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setShareIndexLoading(true).setMaxPartialAggregationMemoryUsage(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxLocalExchangeBufferSize(DataSize.of((long)33L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxWorkerThreads(3).setMinDrivers(2).setMinDriversPerTask(5).setMaxDriversPerTask(13).setInfoMaxAge(new Duration(22.0, TimeUnit.MINUTES)).setClientTimeout(new Duration(10.0, TimeUnit.SECONDS)).setSinkMaxBufferSize(DataSize.of((long)42L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxPagePartitioningBufferSize(DataSize.of((long)40L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setWriterCount(4).setTaskConcurrency(8).setHttpResponseThreads(4).setHttpTimeoutThreads(10).setTaskNotificationThreads(13).setTaskYieldThreads(8).setLevelTimeMultiplier(new BigDecimal("2.1")).setStatisticsCpuTimerEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

