/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.buffer;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spiller.SpillCipher;
import java.util.Optional;

public class TestingPagesSerdeFactory
extends PagesSerdeFactory {
    public TestingPagesSerdeFactory() {
        super(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), true);
    }

    public static PagesSerde testingPagesSerde() {
        return new SynchronizedPagesSerde(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), Optional.of(new Lz4Compressor()), Optional.of(new Lz4Decompressor()), Optional.empty());
    }

    private static class SynchronizedPagesSerde
    extends PagesSerde {
        public SynchronizedPagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
            super(blockEncodingSerde, compressor, decompressor, spillCipher);
        }

        public synchronized SerializedPage serialize(Page page) {
            return super.serialize(page);
        }

        public synchronized Page deserialize(SerializedPage serializedPage) {
            return super.deserialize(serializedPage);
        }
    }
}

