/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.resourcegroups;

import io.prestosql.execution.resourcegroups.WeightedFairQueue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestWeightedFairQueue {
    @Test
    public void testBasic() {
        WeightedFairQueue queue = new WeightedFairQueue();
        String item1 = "1";
        String item2 = "2";
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(1, 1));
        queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(2, 1));
        Assert.assertEquals((int)queue.size(), (int)2);
        Assert.assertEquals((String)((String)queue.poll()), (String)item2);
        Assert.assertTrue((boolean)queue.contains((Object)item1));
        Assert.assertEquals((String)((String)queue.poll()), (String)item1);
        Assert.assertEquals((int)queue.size(), (int)0);
        Assert.assertEquals((String)((String)queue.poll()), null);
        Assert.assertEquals((String)((String)queue.poll()), null);
        Assert.assertEquals((int)queue.size(), (int)0);
    }

    @Test
    public void testUpdate() {
        WeightedFairQueue queue = new WeightedFairQueue();
        String item1 = "1";
        String item2 = "2";
        String item3 = "3";
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(1, 1));
        queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(2, 1));
        queue.addOrUpdate((Object)item3, new WeightedFairQueue.Usage(3, 1));
        Assert.assertEquals((String)((String)queue.poll()), (String)item3);
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(4, 1));
        Assert.assertEquals((String)((String)queue.poll()), (String)item1);
        Assert.assertEquals((String)((String)queue.poll()), (String)item2);
        Assert.assertEquals((int)queue.size(), (int)0);
    }

    @Test
    public void testMultipleWinners() {
        WeightedFairQueue queue = new WeightedFairQueue();
        String item1 = "1";
        String item2 = "2";
        queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(2, 0));
        queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(1, 0));
        int count1 = 0;
        int count2 = 0;
        for (int i = 0; i < 1000; ++i) {
            if (((String)queue.poll()).equals(item1)) {
                queue.addOrUpdate((Object)item1, new WeightedFairQueue.Usage(2, 0));
                ++count1;
                continue;
            }
            queue.addOrUpdate((Object)item2, new WeightedFairQueue.Usage(1, 0));
            ++count2;
        }
        Assert.assertEquals((int)count1, (int)500);
        Assert.assertEquals((int)count2, (int)500);
    }
}

