/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Ticker;
import com.google.common.io.Files;
import io.airlift.testing.TempFile;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.prestosql.execution.scheduler.FileBasedNetworkTopology;
import io.prestosql.execution.scheduler.NetworkLocation;
import io.prestosql.spi.HostAddress;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFileBasedNetworkTopology {
    private File topologyFile;
    private File topologyNewFile;

    @BeforeClass
    public void setup() {
        this.topologyFile = new File(this.getClass().getResource("topology.txt").getFile());
        this.topologyNewFile = new File(this.getClass().getResource("topology-new.txt").getFile());
    }

    @Test
    public void testLocate() {
        FileBasedNetworkTopology topology = new FileBasedNetworkTopology(this.topologyFile, Duration.valueOf((String)"1d"), (Ticker)new TestingTicker());
        Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"0.0.0.0")), (Object)new NetworkLocation(new String[0]));
        Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"not-exist.example.com")), (Object)new NetworkLocation(new String[0]));
        Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine1"}));
        Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.2")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine2"}));
        Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"hdfs01.example.com")), (Object)new NetworkLocation(new String[]{"region2", "rack2", "machine3"}));
        Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1:8080")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine1"}));
    }

    @Test
    public void testRefresh() throws Exception {
        try (TempFile tempFile = new TempFile();){
            Files.copy((File)this.topologyFile, (File)tempFile.file());
            TestingTicker ticker = new TestingTicker();
            FileBasedNetworkTopology topology = new FileBasedNetworkTopology(tempFile.file(), Duration.valueOf((String)"1d"), (Ticker)ticker);
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"not-exist.example.com")), (Object)new NetworkLocation(new String[0]));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine1"}));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.2")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine2"}));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.3")), (Object)new NetworkLocation(new String[0]));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"new")), (Object)new NetworkLocation(new String[0]));
            Files.copy((File)this.topologyNewFile, (File)tempFile.file());
            ticker.increment(1L, TimeUnit.DAYS);
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"new")), (Object)new NetworkLocation(new String[]{"new", "rack", "machine"}));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"not-exist.example.com")), (Object)new NetworkLocation(new String[0]));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.1")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine5"}));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.2")), (Object)new NetworkLocation(new String[0]));
            Assert.assertEquals((Object)topology.locate(HostAddress.fromString((String)"192.168.0.3")), (Object)new NetworkLocation(new String[]{"region1", "rack1", "machine6"}));
        }
    }
}

