/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.collect.ImmutableList;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.scheduler.PartitionedOutputBufferManager;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartitionedOutputBufferManager {
    @Test
    public void test() {
        AtomicReference outputBufferTarget = new AtomicReference();
        PartitionedOutputBufferManager hashOutputBufferManager = new PartitionedOutputBufferManager(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 4, outputBufferTarget::set);
        TestPartitionedOutputBufferManager.assertOutputBuffers((OutputBuffers)outputBufferTarget.get());
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(0)), false);
        TestPartitionedOutputBufferManager.assertOutputBuffers((OutputBuffers)outputBufferTarget.get());
        hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(3)), true);
        TestPartitionedOutputBufferManager.assertOutputBuffers((OutputBuffers)outputBufferTarget.get());
        try {
            hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(5)), false);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestPartitionedOutputBufferManager.assertOutputBuffers((OutputBuffers)outputBufferTarget.get());
        try {
            hashOutputBufferManager.addOutputBuffers((List)ImmutableList.of((Object)new OutputBuffers.OutputBufferId(6)), true);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TestPartitionedOutputBufferManager.assertOutputBuffers((OutputBuffers)outputBufferTarget.get());
    }

    private static void assertOutputBuffers(OutputBuffers outputBuffers) {
        Assert.assertNotNull((Object)outputBuffers);
        Assert.assertTrue((outputBuffers.getVersion() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)outputBuffers.isNoMoreBufferIds());
        Map buffers = outputBuffers.getBuffers();
        Assert.assertEquals((int)buffers.size(), (int)4);
        for (int partition = 0; partition < 4; ++partition) {
            Assert.assertEquals(buffers.get(new OutputBuffers.OutputBufferId(partition)), (Object)partition);
        }
    }
}

