/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.failuredetector;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceSelector;
import io.airlift.discovery.client.ServiceTypes;
import io.airlift.discovery.client.testing.TestingDiscoveryModule;
import io.airlift.http.server.testing.TestingHttpServerModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsModule;
import io.airlift.jmx.testing.TestingJmxModule;
import io.airlift.json.JsonModule;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.node.testing.TestingNodeModule;
import io.airlift.tracetoken.TraceTokenModule;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.failuredetector.FailureDetectorModule;
import io.prestosql.failuredetector.HeartbeatFailureDetector;
import io.prestosql.server.InternalCommunicationConfig;
import java.lang.annotation.Annotation;
import java.net.SocketTimeoutException;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHeartbeatFailureDetector {
    @Test
    public void testExcludesCurrentNode() {
        Bootstrap app = new Bootstrap(new Module[]{new TestingNodeModule(), new TestingJmxModule(), new TestingDiscoveryModule(), new TestingHttpServerModule(), new TraceTokenModule(), new JsonModule(), new JaxrsModule(), new FailureDetectorModule(), binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(InternalCommunicationConfig.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(QueryManagerConfig.class);
            DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
            DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto");
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(FooResource.class);
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().quiet().initialize();
        ServiceSelector selector = (ServiceSelector)injector.getInstance(Key.get(ServiceSelector.class, (Annotation)ServiceTypes.serviceType((String)"presto")));
        Assert.assertEquals((int)selector.selectAllServices().size(), (int)1);
        HeartbeatFailureDetector detector = (HeartbeatFailureDetector)injector.getInstance(HeartbeatFailureDetector.class);
        detector.updateMonitoredServices();
        Assert.assertEquals((int)detector.getTotalCount(), (int)0);
        Assert.assertEquals((int)detector.getActiveCount(), (int)0);
        Assert.assertEquals((int)detector.getFailedCount(), (int)0);
        Assert.assertTrue((boolean)detector.getFailed().isEmpty());
    }

    @Test
    public void testHeartbeatStatsSerialization() throws Exception {
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        HeartbeatFailureDetector.Stats stats = new HeartbeatFailureDetector.Stats(new URI("http://example.com"));
        String serialized = objectMapper.writeValueAsString((Object)stats);
        JsonNode deserialized = objectMapper.readTree(serialized);
        Assert.assertFalse((boolean)deserialized.has("lastFailureInfo"));
        stats.recordFailure((Exception)new SocketTimeoutException("timeout"));
        serialized = objectMapper.writeValueAsString((Object)stats);
        deserialized = objectMapper.readTree(serialized);
        Assert.assertFalse((boolean)deserialized.get("lastFailureInfo").isNull());
        Assert.assertEquals((String)deserialized.get("lastFailureInfo").get("type").asText(), (String)SocketTimeoutException.class.getName());
    }

    @Path(value="/foo")
    public static final class FooResource {
        @GET
        public static String hello() {
            return "hello";
        }
    }
}

