/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPolymorphicScalarFunction {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final Signature SIGNATURE = Signature.builder().name("foo").kind(FunctionKind.SCALAR).returnType(BigintType.BIGINT.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
    private static final int INPUT_VARCHAR_LENGTH = 10;
    private static final TypeSignature INPUT_VARCHAR_TYPE = VarcharType.createVarcharType((int)10).getTypeSignature();
    private static final Slice INPUT_SLICE = Slices.allocate((int)10);
    private static final BoundVariables BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of((Object)"V", (Object)METADATA.getType(INPUT_VARCHAR_TYPE)), (Map)ImmutableMap.of((Object)"x", (Object)10L));
    private static final TypeSignature DECIMAL_SIGNATURE = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
    private static final BoundVariables LONG_DECIMAL_BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"a_precision", (Object)19L, (Object)"a_scale", (Object)2L));
    private static final BoundVariables SHORT_DECIMAL_BOUND_VARIABLES = new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"a_precision", (Object)18L, (Object)"a_scale", (Object)2L));

    @Test
    public void testSelectsMultipleChoiceWithBlockPosition() throws Throwable {
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.IS_DISTINCT_FROM).argumentTypes(new TypeSignature[]{DECIMAL_SIGNATURE, DECIMAL_SIGNATURE}).returnType(BooleanType.BOOLEAN.getTypeSignature()).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).argumentDefinitions(new FunctionArgumentDefinition[]{new FunctionArgumentDefinition(true), new FunctionArgumentDefinition(true)}).deterministic(true).choice(choice -> choice.argumentProperties(new ScalarFunctionImplementation.ArgumentProperty[]{ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG), ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)}).implementation(methodsGroup -> methodsGroup.methods(new String[]{"shortShort", "longLong"}))).choice(choice -> choice.argumentProperties(new ScalarFunctionImplementation.ArgumentProperty[]{ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION), ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION)}).implementation(methodsGroup -> methodsGroup.methodWithExplicitJavaTypes("blockPositionLongLong", Arrays.asList(Optional.of(Slice.class), Optional.of(Slice.class))).methodWithExplicitJavaTypes("blockPositionShortShort", Arrays.asList(Optional.of(Long.TYPE), Optional.of(Long.TYPE))))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(SHORT_DECIMAL_BOUND_VARIABLES, 2, METADATA);
        Assert.assertEquals((int)functionImplementation.getAllChoices().size(), (int)2);
        Assert.assertEquals((Collection)((ScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getAllChoices().get(0)).getArgumentProperties(), Collections.nCopies(2, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)));
        Assert.assertEquals((Collection)((ScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getAllChoices().get(1)).getArgumentProperties(), Collections.nCopies(2, ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.BLOCK_AND_POSITION)));
        LongArrayBlock block1 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        LongArrayBlock block2 = new LongArrayBlock(0, Optional.empty(), new long[0]);
        Assert.assertFalse((boolean)((ScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getAllChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
        functionImplementation = function.specialize(LONG_DECIMAL_BOUND_VARIABLES, 2, METADATA);
        Assert.assertTrue((boolean)((ScalarFunctionImplementation.ScalarImplementationChoice)functionImplementation.getAllChoices().get(1)).getMethodHandle().invoke((Block)block1, 0, (Block)block2, 0));
    }

    @Test
    public void testSelectsMethodBasedOnArgumentTypes() throws Throwable {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)context.getLiteral("x"))))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, METADATA);
        Assert.assertEquals((Object)functionImplementation.getMethodHandle().invoke(INPUT_SLICE), (Object)10L);
    }

    @Test
    public void testSelectsMethodBasedOnReturnType() throws Throwable {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarcharCreateSliceWithExtraParameterLength"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}).withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, METADATA);
        Assert.assertEquals((Object)functionImplementation.getMethodHandle().invoke(INPUT_SLICE), (Object)42L);
    }

    @Test
    public void testSameLiteralInArgumentsAndReturnValue() throws Throwable {
        Signature signature = Signature.builder().name("foo").kind(FunctionKind.SCALAR).returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, METADATA);
        Slice slice = functionImplementation.getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testTypeParameters() throws Throwable {
        Signature signature = Signature.builder().name("foo").kind(FunctionKind.SCALAR).typeVariableConstraints(new TypeVariableConstraint[]{Signature.comparableWithVariadicBound((String)"V", (String)"ROW")}).returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, METADATA);
        Slice slice = functionImplementation.getMethodHandle().invoke(INPUT_SLICE);
        Assert.assertEquals((Object)slice, (Object)TestMethods.VARCHAR_TO_VARCHAR_RETURN_VALUE);
    }

    @Test
    public void testSetsHiddenToTrueForOperators() {
        Signature signature = Signature.builder().operatorType(OperatorType.ADD).kind(FunctionKind.SCALAR).returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToVarchar"}))).build();
        ScalarFunctionImplementation functionImplementation = function.specialize(BOUND_VARIABLES, 1, METADATA);
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="method foo was not found in class io.prestosql.metadata.TestPolymorphicScalarFunction\\$TestMethods")
    public void testFailIfNotAllMethodsPresent() {
        SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"bigintToBigintReturnExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"foo"}))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="methods must be selected first")
    public void testFailNoMethodsAreSelectedWhenExtraParametersFunctionIsSet() {
        SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.withExtraParameters(context -> ImmutableList.of((Object)42)))).build();
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="two matching methods \\(varcharToBigintReturnFirstExtraParameter and varcharToBigintReturnExtraParameter\\) for parameter types \\[varchar\\(10\\)\\]")
    public void testFailIfTwoMethodsWithSameArguments() {
        SqlScalarFunction function = SqlScalarFunction.builder(TestMethods.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnFirstExtraParameter"})).implementation(methodsGroup -> methodsGroup.methods(new String[]{"varcharToBigintReturnExtraParameter"}))).build();
        function.specialize(BOUND_VARIABLES, 1, METADATA);
    }

    public static final class TestMethods {
        static final Slice VARCHAR_TO_VARCHAR_RETURN_VALUE = Slices.utf8Slice((String)"hello world");
        static final long VARCHAR_TO_BIGINT_RETURN_VALUE = 42L;

        public static Slice varcharToVarchar(Slice varchar) {
            return VARCHAR_TO_VARCHAR_RETURN_VALUE;
        }

        public static long varcharToBigint(Slice varchar) {
            return 42L;
        }

        public static long varcharToBigintReturnExtraParameter(Slice varchar, long extraParameter) {
            return extraParameter;
        }

        public static long bigintToBigintReturnExtraParameter(long bigint, int extraParameter) {
            return bigint;
        }

        public static long varcharToBigintReturnFirstExtraParameter(Slice varchar, long extraParameter1, int extraParameter2) {
            return extraParameter1;
        }

        public static Slice varcharToVarcharCreateSliceWithExtraParameterLength(Slice string, int extraParameter) {
            return Slices.allocate((int)extraParameter);
        }

        public static boolean blockPositionLongLong(Block left, int leftPosition, Block right, int rightPosition) {
            return true;
        }

        public static boolean blockPositionShortShort(Block left, int leftPosition, Block right, int rightPosition) {
            return false;
        }

        public static boolean shortShort(long left, boolean leftNull, long right, boolean rightNull) {
            return false;
        }

        public static boolean longLong(Slice left, boolean leftNull, Slice right, boolean rightNull) {
            return false;
        }
    }
}

