/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.ScalarFunctionAdapter;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.assertions.Assert;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.Fail;
import org.testng.annotations.Test;

public class TestScalarFunctionAdapter {
    private static final ArrayType ARRAY_TYPE = new ArrayType((Type)BigintType.BIGINT);
    private static final List<Type> ARGUMENT_TYPES = ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)ARRAY_TYPE);

    @Test
    public void testAdaptFromNeverNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "neverNull";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, ScalarFunctionAdapter.NullAdaptationPolicy.RETURN_NULL_ON_NULL);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, ScalarFunctionAdapter.NullAdaptationPolicy.UNDEFINED_VALUE_FOR_NULL);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, ScalarFunctionAdapter.NullAdaptationPolicy.THROW_ON_NULL);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED);
    }

    @Test
    public void testAdaptFromBoxedNull() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "boxedNull";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED);
    }

    @Test
    public void testAdaptFromNullFlag() throws Throwable {
        InvocationConvention actualConvention = new InvocationConvention(Collections.nCopies(ARGUMENT_TYPES.size(), InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false, true);
        String methodName = "nullFlag";
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodName, ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED);
    }

    private static void verifyAllAdaptations(InvocationConvention actualConvention, String methodName, ScalarFunctionAdapter.NullAdaptationPolicy nullAdaptationPolicy) throws Throwable {
        MethodType type = MethodType.methodType(actualConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL ? Boolean.TYPE : Boolean.class, TestScalarFunctionAdapter.toCallArgumentTypes(actualConvention));
        MethodHandle methodHandle = MethodHandles.lookup().findVirtual(Target.class, methodName, type);
        TestScalarFunctionAdapter.verifyAllAdaptations(actualConvention, methodHandle, nullAdaptationPolicy);
    }

    private static void verifyAllAdaptations(InvocationConvention actualConvention, MethodHandle methodHandle, ScalarFunctionAdapter.NullAdaptationPolicy nullAdaptationPolicy) throws Throwable {
        List allArgumentConventions = TestScalarFunctionAdapter.allCombinations(ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION), ARGUMENT_TYPES.size());
        for (List argumentConventions : allArgumentConventions) {
            for (InvocationConvention.InvocationReturnConvention returnConvention : InvocationConvention.InvocationReturnConvention.values()) {
                InvocationConvention expectedConvention = new InvocationConvention(argumentConventions, returnConvention, false, true);
                TestScalarFunctionAdapter.adaptAndVerify(methodHandle, actualConvention, expectedConvention, nullAdaptationPolicy);
            }
        }
    }

    private static void adaptAndVerify(MethodHandle methodHandle, InvocationConvention actualConvention, InvocationConvention expectedConvention, ScalarFunctionAdapter.NullAdaptationPolicy nullAdaptationPolicy) throws Throwable {
        ScalarFunctionAdapter scalarFunctionAdapter = new ScalarFunctionAdapter(nullAdaptationPolicy);
        MethodHandle adaptedMethodHandle = null;
        try {
            adaptedMethodHandle = scalarFunctionAdapter.adapt(methodHandle, ARGUMENT_TYPES, actualConvention, expectedConvention);
            org.testng.Assert.assertTrue((boolean)scalarFunctionAdapter.canAdapt(actualConvention, expectedConvention));
        }
        catch (IllegalArgumentException e) {
            org.testng.Assert.assertFalse((boolean)scalarFunctionAdapter.canAdapt(actualConvention, expectedConvention));
            org.testng.Assert.assertTrue((nullAdaptationPolicy == ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED || nullAdaptationPolicy == ScalarFunctionAdapter.NullAdaptationPolicy.RETURN_NULL_ON_NULL && expectedConvention.getReturnConvention() == InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL ? 1 : 0) != 0);
            if (TestScalarFunctionAdapter.hasNullableToNoNullableAdaptation(actualConvention, expectedConvention)) {
                return;
            }
            Fail.fail((String)"Adaptation failed but no illegal conversions found", (Throwable)e);
        }
        InvocationConvention newCallingConvention = new InvocationConvention(expectedConvention.getArgumentConventions(), expectedConvention.getReturnConvention(), actualConvention.supportsSession(), actualConvention.supportsInstanceFactor());
        MethodHandle exactInvoker = MethodHandles.exactInvoker(adaptedMethodHandle.type()).bindTo(adaptedMethodHandle);
        exactInvoker = MethodHandles.explicitCastArguments(exactInvoker, exactInvoker.type().changeReturnType(Boolean.class));
        for (int notNullMask = 0; notNullMask < 1 << actualConvention.getArgumentConventions().size(); ++notNullMask) {
            BitSet nullArguments = BitSet.valueOf(new long[]{notNullMask});
            if (!TestScalarFunctionAdapter.canCallConventionWithNullArguments(expectedConvention, nullArguments)) continue;
            Target target = new Target();
            List<Object> argumentValues = TestScalarFunctionAdapter.toCallArgumentValues(newCallingConvention, nullArguments, target);
            try {
                Boolean result = (Boolean)exactInvoker.invokeWithArguments(argumentValues);
                if (result == null) {
                    Assert.assertEquals((Object)nullAdaptationPolicy, (Object)ScalarFunctionAdapter.NullAdaptationPolicy.RETURN_NULL_ON_NULL);
                } else {
                    org.testng.Assert.assertTrue((boolean)result);
                }
            }
            catch (PrestoException prestoException) {
                if (nullAdaptationPolicy == ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED) {
                    org.testng.Assert.assertTrue((boolean)TestScalarFunctionAdapter.hasNullBlockAndPositionToNeverNullArgument(actualConvention, expectedConvention, nullArguments));
                } else {
                    org.testng.Assert.assertTrue((nullAdaptationPolicy == ScalarFunctionAdapter.NullAdaptationPolicy.THROW_ON_NULL || nullAdaptationPolicy == ScalarFunctionAdapter.NullAdaptationPolicy.RETURN_NULL_ON_NULL ? 1 : 0) != 0);
                }
                Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            }
            target.verify(actualConvention, nullArguments, nullAdaptationPolicy);
        }
    }

    private static boolean hasNullableToNoNullableAdaptation(InvocationConvention actualConvention, InvocationConvention expectedConvention) {
        for (int i = 0; i < actualConvention.getArgumentConventions().size(); ++i) {
            InvocationConvention.InvocationArgumentConvention actualArgumentConvention = actualConvention.getArgumentConvention(i);
            InvocationConvention.InvocationArgumentConvention expectedArgumentConvention = expectedConvention.getArgumentConvention(i);
            if (actualArgumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL || expectedArgumentConvention != InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE && expectedArgumentConvention != InvocationConvention.InvocationArgumentConvention.NULL_FLAG) continue;
            return true;
        }
        return false;
    }

    private static boolean canCallConventionWithNullArguments(InvocationConvention convention, BitSet nullArguments) {
        for (int i = 0; i < convention.getArgumentConventions().size(); ++i) {
            if (!nullArguments.get(i) || convention.getArgumentConvention(i) != InvocationConvention.InvocationArgumentConvention.NEVER_NULL) continue;
            return false;
        }
        return true;
    }

    private static boolean hasNullBlockAndPositionToNeverNullArgument(InvocationConvention actualConvention, InvocationConvention expectedConvention, BitSet nullArguments) {
        for (int i = 0; i < actualConvention.getArgumentConventions().size(); ++i) {
            if (!nullArguments.get(i) || actualConvention.getArgumentConvention(i) != InvocationConvention.InvocationArgumentConvention.NEVER_NULL || expectedConvention.getArgumentConvention(i) != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
            return true;
        }
        return false;
    }

    private static List<Class<?>> toCallArgumentTypes(InvocationConvention callingConvention) {
        ArrayList expectedArguments = new ArrayList();
        block6: for (int i = 0; i < callingConvention.getArgumentConventions().size(); ++i) {
            Type argumentType = ARGUMENT_TYPES.get(i);
            InvocationConvention.InvocationArgumentConvention argumentConvention = callingConvention.getArgumentConvention(i);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    expectedArguments.add(argumentType.getJavaType());
                    continue block6;
                }
                case BOXED_NULLABLE: {
                    expectedArguments.add(Primitives.wrap((Class)argumentType.getJavaType()));
                    continue block6;
                }
                case NULL_FLAG: {
                    expectedArguments.add(argumentType.getJavaType());
                    expectedArguments.add(Boolean.TYPE);
                    continue block6;
                }
                case BLOCK_POSITION: {
                    expectedArguments.add(Block.class);
                    expectedArguments.add(Integer.TYPE);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported argument convention: " + argumentConvention);
                }
            }
        }
        return expectedArguments;
    }

    private static List<Object> toCallArgumentValues(InvocationConvention callingConvention, BitSet nullArguments, Target target) {
        ArrayList<Object> callArguments = new ArrayList<Object>();
        callArguments.add(target);
        block6: for (int i = 0; i < callingConvention.getArgumentConventions().size(); ++i) {
            Type argumentType = ARGUMENT_TYPES.get(i);
            boolean nullArgument = nullArguments.get(i);
            Object testValue = nullArgument ? null : TestScalarFunctionAdapter.getTestValue(argumentType);
            InvocationConvention.InvocationArgumentConvention argumentConvention = callingConvention.getArgumentConvention(i);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    Verify.verify((testValue != null ? 1 : 0) != 0, (String)"null can not be passed to a never null argument", (Object[])new Object[0]);
                    callArguments.add(testValue);
                    continue block6;
                }
                case BOXED_NULLABLE: {
                    callArguments.add(testValue);
                    continue block6;
                }
                case NULL_FLAG: {
                    callArguments.add(testValue == null ? Defaults.defaultValue((Class)argumentType.getJavaType()) : testValue);
                    callArguments.add(testValue == null);
                    continue block6;
                }
                case BLOCK_POSITION: {
                    BlockBuilder blockBuilder = argumentType.createBlockBuilder(null, 3);
                    blockBuilder.appendNull();
                    TypeUtils.writeNativeValue((Type)argumentType, (BlockBuilder)blockBuilder, (Object)testValue);
                    blockBuilder.appendNull();
                    callArguments.add(blockBuilder.build());
                    callArguments.add(1);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported argument convention: " + argumentConvention);
                }
            }
        }
        return callArguments;
    }

    private static Object getTestValue(Type argumentType) {
        if (argumentType.getJavaType() == Boolean.TYPE) {
            return true;
        }
        if (argumentType.getJavaType() == Double.TYPE) {
            return 33.33;
        }
        if (argumentType.getJavaType() == Long.TYPE) {
            return 42L;
        }
        if (argumentType.getJavaType() == Slice.class) {
            return Slices.utf8Slice((String)"test");
        }
        if (argumentType.getJavaType() == Block.class) {
            BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 4);
            blockBuilder.appendNull();
            blockBuilder.writeLong(99L);
            blockBuilder.appendNull();
            blockBuilder.writeLong(100L);
            return blockBuilder.build();
        }
        throw new IllegalArgumentException("Unsupported argument type: " + argumentType);
    }

    private static <T> List<List<T>> allCombinations(List<T> values, int n) {
        ImmutableList.Builder combinations = ImmutableList.builder();
        int[] indexes = new int[n];
        block0: do {
            combinations.add((Object)((List)IntStream.of(indexes).mapToObj(values::get).collect(ImmutableList.toImmutableList())));
            for (int i2 = 0; i2 < indexes.length; ++i2) {
                int n2 = i2;
                indexes[n2] = indexes[n2] + 1;
                if (indexes[i2] < values.size()) continue block0;
                indexes[i2] = 0;
            }
        } while (!IntStream.of(indexes).allMatch(i -> i == 0));
        return combinations.build();
    }

    private static class Target {
        private boolean invoked;
        private Boolean booleanValue;
        private Long longValue;
        private Double doubleValue;
        private Slice sliceValue;
        private Block blockValue;

        private Target() {
        }

        @UsedByGeneratedCode
        public boolean neverNull(boolean booleanValue, long longValue, double doubleValue, Slice sliceValue, Block blockValue) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.booleanValue = booleanValue;
            this.longValue = longValue;
            this.doubleValue = doubleValue;
            this.sliceValue = sliceValue;
            this.blockValue = blockValue;
            return true;
        }

        @UsedByGeneratedCode
        public boolean boxedNull(Boolean booleanValue, Long longValue, Double doubleValue, Slice sliceValue, Block blockValue) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            this.booleanValue = booleanValue;
            this.longValue = longValue;
            this.doubleValue = doubleValue;
            this.sliceValue = sliceValue;
            this.blockValue = blockValue;
            return true;
        }

        @UsedByGeneratedCode
        public boolean nullFlag(boolean booleanValue, boolean booleanNull, long longValue, boolean longNull, double doubleValue, boolean doubleNull, Slice sliceValue, boolean sliceNull, Block blockValue, boolean blockNull) {
            Preconditions.checkState((!this.invoked ? 1 : 0) != 0, (Object)"Already invoked");
            this.invoked = true;
            if (booleanNull) {
                org.testng.Assert.assertFalse((boolean)booleanValue);
                this.booleanValue = null;
            } else {
                this.booleanValue = booleanValue;
            }
            if (longNull) {
                Assert.assertEquals((long)longValue, (long)0L);
                this.longValue = null;
            } else {
                this.longValue = longValue;
            }
            if (doubleNull) {
                Assert.assertEquals((Object)doubleValue, (Object)0.0);
                this.doubleValue = null;
            } else {
                this.doubleValue = doubleValue;
            }
            if (sliceNull) {
                org.testng.Assert.assertNull((Object)sliceValue);
                this.sliceValue = null;
            } else {
                this.sliceValue = sliceValue;
            }
            if (blockNull) {
                org.testng.Assert.assertNull((Object)blockValue);
                this.blockValue = null;
            } else {
                this.blockValue = blockValue;
            }
            return true;
        }

        public void verify(InvocationConvention actualConvention, BitSet nullArguments, ScalarFunctionAdapter.NullAdaptationPolicy nullAdaptationPolicy) {
            if (Target.shouldFunctionBeInvoked(actualConvention, nullArguments, nullAdaptationPolicy)) {
                org.testng.Assert.assertTrue((boolean)this.invoked, (String)"function not invoked");
                Target.assertArgumentValue((Object)this.booleanValue, 0, actualConvention, nullArguments);
                Target.assertArgumentValue((Object)this.longValue, 1, actualConvention, nullArguments);
                Target.assertArgumentValue((Object)this.doubleValue, 2, actualConvention, nullArguments);
                Target.assertArgumentValue((Object)this.sliceValue, 3, actualConvention, nullArguments);
                Target.assertArgumentValue((Object)this.blockValue, 4, actualConvention, nullArguments);
            } else {
                org.testng.Assert.assertFalse((boolean)this.invoked, (String)("Function should not be invoked when null is passed to a NEVER_NULL argument and adaptation is " + nullAdaptationPolicy));
                org.testng.Assert.assertNull((Object)this.booleanValue);
                org.testng.Assert.assertNull((Object)this.longValue);
                org.testng.Assert.assertNull((Object)this.doubleValue);
                org.testng.Assert.assertNull((Object)this.sliceValue);
                org.testng.Assert.assertNull((Object)this.blockValue);
            }
            this.invoked = false;
            this.booleanValue = null;
            this.longValue = null;
            this.doubleValue = null;
            this.sliceValue = null;
            this.blockValue = null;
        }

        private static boolean shouldFunctionBeInvoked(InvocationConvention actualConvention, BitSet nullArguments, ScalarFunctionAdapter.NullAdaptationPolicy nullAdaptationPolicy) {
            if (nullAdaptationPolicy == ScalarFunctionAdapter.NullAdaptationPolicy.UNDEFINED_VALUE_FOR_NULL) {
                return true;
            }
            for (int i = 0; i < actualConvention.getArgumentConventions().size(); ++i) {
                if (actualConvention.getArgumentConvention(i) != InvocationConvention.InvocationArgumentConvention.NEVER_NULL || !nullArguments.get(i)) continue;
                return false;
            }
            return true;
        }

        private static void assertArgumentValue(Object actualValue, int index, InvocationConvention actualConvention, BitSet nullArguments) {
            Target.assertArgumentValue(actualValue, actualConvention.getArgumentConvention(index), ARGUMENT_TYPES.get(index), nullArguments.get(index));
        }

        private static void assertArgumentValue(Object actualValue, InvocationConvention.InvocationArgumentConvention argumentConvention, Type argumentType, boolean isNull) {
            if (!isNull) {
                Target.assertArgumentValue(actualValue, TestScalarFunctionAdapter.getTestValue(argumentType));
                return;
            }
            if (argumentConvention != InvocationConvention.InvocationArgumentConvention.NEVER_NULL) {
                org.testng.Assert.assertNull((Object)actualValue);
                return;
            }
            if (argumentType.getJavaType().isPrimitive()) {
                Target.assertArgumentValue(actualValue, Defaults.defaultValue((Class)argumentType.getJavaType()));
            }
        }

        private static void assertArgumentValue(Object actual, Object expected) {
            if (actual instanceof Block && expected instanceof Block) {
                BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, (Block)actual, (Block)expected);
            } else {
                Assert.assertEquals((Object)actual, (Object)expected);
            }
        }
    }
}

