/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.metadata.SignatureBuilder;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.type.FunctionType;
import io.prestosql.type.JsonType;
import io.prestosql.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSignatureBinder {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testBindLiteralForDecimal() {
        TypeSignature leftType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p1"), TypeSignatureParameter.typeVariable((String)"s1")});
        TypeSignature rightType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p2"), TypeSignatureParameter.typeVariable((String)"s2")});
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1), DecimalType.createDecimalType((int)1, (int)0)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p1", (Object)2L, (Object)"s1", (Object)1L, (Object)"p2", (Object)1L, (Object)"s2", (Object)0L)));
    }

    @Test
    public void testBindPartialDecimal() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.numericParameter((long)4L), TypeSignatureParameter.typeVariable((String)"s")})}).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"s", (Object)1L)));
        function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.numericParameter((long)1L)})}).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)0)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)3L)));
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)2L)));
        this.assertThat(function).boundTo(BigintType.BIGINT).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)20L)));
    }

    @Test
    public void testBindLiteralForVarchar() {
        TypeSignature leftType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature rightType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"y")});
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)42), VarcharType.createVarcharType((int)44)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)42L, (Object)"y", (Object)44L)));
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, VarcharType.createVarcharType((int)44)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)0L, (Object)"y", (Object)44L)));
    }

    @Test
    public void testBindLiteralForRepeatedVarcharWithReturn() {
        TypeSignature leftType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature rightType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)44), VarcharType.createVarcharType((int)44)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)44), VarcharType.createVarcharType((int)42)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)42), VarcharType.createVarcharType((int)44)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, VarcharType.createVarcharType((int)44)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)44L)));
    }

    @Test
    public void testBindLiteralForRepeatedDecimal() {
        TypeSignature leftType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")});
        TypeSignature rightType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")});
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)10, (int)5), DecimalType.createDecimalType((int)10, (int)5)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)10L, (Object)"s", (Object)5L)));
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)10, (int)8), DecimalType.createDecimalType((int)9, (int)8)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)10L, (Object)"s", (Object)8L)));
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)10, (int)2), DecimalType.createDecimalType((int)10, (int)8)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)16L, (Object)"s", (Object)8L)));
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, DecimalType.createDecimalType((int)10, (int)5)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)10L, (Object)"s", (Object)5L)));
    }

    @Test
    public void testBindLiteralForRepeatedVarchar() {
        TypeSignature leftType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature rightType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        TypeSignature returnType = new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")});
        Signature function = TestSignatureBinder.functionSignature().returnType(returnType).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).withCoercion().boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)VarcharType.createVarcharType((int)5)), (Type)VarcharType.createVarcharType((int)5)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)5L)));
        this.assertThat(function).withCoercion().boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)VarcharType.createVarcharType((int)5)), (Type)VarcharType.createVarcharType((int)6)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)6L)));
    }

    @Test
    public void testBindUnknown() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).fails();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().succeeds();
    }

    @Test
    public void testBindMixedLiteralAndTypeVariables() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), TypeSignature.arrayType((TypeSignature)new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")}))}).build();
        this.assertThat(function).boundTo(new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1)), new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)1))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)DecimalType.createDecimalType((int)2, (int)1)), (Map)ImmutableMap.of((Object)"p", (Object)3L, (Object)"s", (Object)1L)));
    }

    @Test
    public void testBindDifferentLiteralParameters() {
        TypeSignature argType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")});
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{argType, argType}).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1), DecimalType.createDecimalType((int)3, (int)1)).fails();
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testNoVariableReuseAcrossTypes() {
        TypeSignature leftType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p1"), TypeSignatureParameter.typeVariable((String)"s")});
        TypeSignature rightType = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p2"), TypeSignatureParameter.typeVariable((String)"s")});
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{leftType, rightType}).build();
        this.assertThat(function).boundTo(DecimalType.createDecimalType((int)2, (int)1), DecimalType.createDecimalType((int)3, (int)1)).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindUnknownToDecimal() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"p"), TypeSignatureParameter.typeVariable((String)"s")})}).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"p", (Object)1L, (Object)"s", (Object)0L)));
    }

    @Test
    public void testBindUnknownToConcreteArray() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)BooleanType.BOOLEAN.getTypeSignature())}).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().succeeds();
    }

    @Test
    public void testBindTypeVariablesBasedOnTheSecondArgument() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN, DecimalType.createDecimalType((int)2, (int)1)).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)DecimalType.createDecimalType((int)2, (int)1)), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindParametricTypeParameterToUnknown() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).fails();
        this.assertThat(function).withCoercion().boundTo(UnknownType.UNKNOWN).succeeds();
    }

    @Test
    public void testBindUnknownToTypeParameter() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)UnknownType.UNKNOWN), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindDoubleToBigint() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}).build();
        this.assertThat(function).boundTo(DoubleType.DOUBLE, BigintType.BIGINT).withCoercion().succeeds();
    }

    @Test
    public void testBindVarcharTemplateStyle() {
        Signature function = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T2", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("T1", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)new TypeVariableConstraint("T1", true, false, null, (Set)ImmutableSet.of(), (Set)ImmutableSet.of()), (Object)new TypeVariableConstraint("T2", true, false, null, (Set)ImmutableSet.of(), (Set)ImmutableSet.of()))).build();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)42)), (Type)VarcharType.createVarcharType((int)1)).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T1", (Object)VarcharType.createVarcharType((int)42), (Object)"T2", (Object)VarcharType.createVarcharType((int)1)), (Map)ImmutableMap.of()));
    }

    @Test
    public void testBindVarchar() {
        Signature function = TestSignatureBinder.functionSignature().returnType(VarcharType.createVarcharType((int)42).getTypeSignature()).argumentTypes(new TypeSignature[]{VarcharType.createVarcharType((int)42).getTypeSignature()}).build();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)1)), (Type)VarcharType.createVarcharType((int)1)).fails();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)1)), (Type)VarcharType.createVarcharType((int)1)).withCoercion().fails();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)1)), (Type)VarcharType.createVarcharType((int)42)).withCoercion().succeeds();
        this.assertThat(function).boundTo((List<Type>)ImmutableList.of((Object)VarcharType.createVarcharType((int)44)), (Type)VarcharType.createVarcharType((int)44)).withCoercion().fails();
    }

    @Test
    public void testBindUnparametrizedVarchar() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})}).build();
        this.assertThat(function).boundTo(VarcharType.VARCHAR).produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)"x", (Object)Integer.MAX_VALUE)));
    }

    @Test
    public void testBindToUnparametrizedVarcharIsImpossible() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature()}).build();
        this.assertThat(function).boundTo(VarcharType.createVarcharType((int)3)).withCoercion().succeeds();
        this.assertThat(function).boundTo(UnknownType.UNKNOWN).withCoercion().succeeds();
    }

    @Test
    public void testBasic() {
        Signature function = TestSignatureBinder.functionSignature().typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])}).build();
        this.assertThat(function).boundTo(BigintType.BIGINT).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(VarcharType.VARCHAR).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)VarcharType.VARCHAR), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).fails();
        this.assertThat(function).boundTo(new ArrayType((Type)BigintType.BIGINT)).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)new ArrayType((Type)BigintType.BIGINT)), (Map)ImmutableMap.of()));
    }

    @Test
    public void testMismatchedArgumentCount() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature()}).build();
        this.assertThat(function).boundTo(BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT).fails();
        this.assertThat(function).boundTo(BigintType.BIGINT).fails();
    }

    @Test
    public void testNonParametric() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}).build();
        this.assertThat(function).boundTo(BigintType.BIGINT).succeeds();
        this.assertThat(function).boundTo(VarcharType.VARCHAR).withCoercion().fails();
        this.assertThat(function).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().fails();
        this.assertThat(function).boundTo(new ArrayType((Type)BigintType.BIGINT)).withCoercion().fails();
    }

    @Test
    public void testArray() {
        Signature getFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(getFunction).boundTo(new ArrayType((Type)BigintType.BIGINT)).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(getFunction).boundTo(BigintType.BIGINT).withCoercion().fails();
        this.assertThat(getFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().fails();
        Signature containsFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"T"))).build();
        this.assertThat(containsFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(containsFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR).withCoercion().fails();
        this.assertThat(containsFunction).boundTo(new ArrayType((Type)HyperLogLogType.HYPER_LOG_LOG), HyperLogLogType.HYPER_LOG_LOG).withCoercion().fails();
        Signature castFunction = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T2", new TypeSignatureParameter[0]))).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T1", new TypeSignatureParameter[0])), TypeSignature.arrayType((TypeSignature)new TypeSignature("T2", new TypeSignatureParameter[0]))}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.typeVariable((String)"T2"))).build();
        this.assertThat(castFunction).boundTo(new ArrayType((Type)UnknownType.UNKNOWN), new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T1", (Object)UnknownType.UNKNOWN, (Object)"T2", (Object)DecimalType.createDecimalType((int)2, (int)1)), (Map)ImmutableMap.of()));
        Signature fooFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(fooFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(fooFunction).boundTo(new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)VarcharType.VARCHAR)).withCoercion().fails();
    }

    @Test
    public void testMap() {
        Signature getValueFunction = TestSignatureBinder.functionSignature().returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0])), new TypeSignature("K", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"K"), (Object)Signature.typeVariable((String)"V"))).build();
        this.assertThat(getValueFunction).boundTo(this.type(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), BigintType.BIGINT).produces(new BoundVariables((Map)ImmutableMap.of((Object)"K", (Object)BigintType.BIGINT, (Object)"V", (Object)VarcharType.VARCHAR), (Map)ImmutableMap.of()));
        this.assertThat(getValueFunction).boundTo(this.type(TypeSignature.mapType((TypeSignature)BigintType.BIGINT.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), VarcharType.VARCHAR).withCoercion().fails();
    }

    @Test
    public void testRow() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)IntegerType.INTEGER.getTypeSignature())})}).build();
        this.assertThat(function).boundTo(RowType.anonymous((List)ImmutableList.of((Object)TinyintType.TINYINT))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of(), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().fails();
        Signature biFunction = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))}), TypeSignature.rowType((TypeSignatureParameter[])new TypeSignatureParameter[]{TypeSignatureParameter.anonymousField((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))})}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(biFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(biFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
    }

    @Test
    public void testVariadic() {
        Signature rowVariadicBoundFunction = TestSignatureBinder.functionSignature().returnType(BigintType.BIGINT.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"row"))).build();
        this.assertThat(rowVariadicBoundFunction).boundTo(RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT))), (Map)ImmutableMap.of()));
        this.assertThat(rowVariadicBoundFunction).boundTo(new ArrayType((Type)BigintType.BIGINT)).fails();
        this.assertThat(rowVariadicBoundFunction).boundTo(new ArrayType((Type)BigintType.BIGINT)).withCoercion().fails();
        Assert.assertThrows(IllegalArgumentException.class, () -> Signature.withVariadicBound((String)"T", (String)"array"));
        Assert.assertThrows(IllegalArgumentException.class, () -> Signature.withVariadicBound((String)"T", (String)"map"));
        Assert.assertThrows(IllegalArgumentException.class, () -> Signature.withVariadicBound((String)"T", (String)"decimal"));
    }

    @Test
    public void testBindUnknownToVariadic() {
        Signature rowFunction = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.withVariadicBound((String)"T", (String)"row"))).build();
        this.assertThat(rowFunction).boundTo(UnknownType.UNKNOWN, RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT)))).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT)))), (Map)ImmutableMap.of()));
    }

    @Test
    public void testInvalidVariadicBound() {
        Assert.assertThrows(IllegalArgumentException.class, () -> Signature.withVariadicBound((String)"T", (String)"array"));
        Assert.assertThrows(IllegalArgumentException.class, () -> Signature.withVariadicBound((String)"T", (String)"map"));
        Assert.assertThrows(IllegalArgumentException.class, () -> Signature.withVariadicBound((String)"T", (String)"decimal"));
    }

    @Test
    public void testVarArgs() {
        Signature variableArityFunction = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).setVariableArity(true).build();
        this.assertThat(variableArityFunction).boundTo(BigintType.BIGINT).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(variableArityFunction).boundTo(VarcharType.VARCHAR).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)VarcharType.VARCHAR), (Map)ImmutableMap.of()));
        this.assertThat(variableArityFunction).boundTo(BigintType.BIGINT, BigintType.BIGINT).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(variableArityFunction).boundTo(BigintType.BIGINT, VarcharType.VARCHAR).withCoercion().fails();
    }

    @Test
    public void testCoercion() {
        Signature function = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), DoubleType.DOUBLE.getTypeSignature()}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(function).boundTo(DoubleType.DOUBLE, DoubleType.DOUBLE).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)DoubleType.DOUBLE), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(BigintType.BIGINT, BigintType.BIGINT).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)VarcharType.VARCHAR), (Map)ImmutableMap.of()));
        this.assertThat(function).boundTo(BigintType.BIGINT, VarcharType.VARCHAR).withCoercion().fails();
    }

    @Test
    public void testUnknownCoercion() {
        Signature foo = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.typeVariable((String)"T"))).build();
        this.assertThat(foo).boundTo(UnknownType.UNKNOWN, UnknownType.UNKNOWN).produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)UnknownType.UNKNOWN), (Map)ImmutableMap.of()));
        this.assertThat(foo).boundTo(UnknownType.UNKNOWN, BigintType.BIGINT).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(foo).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().fails();
        Signature bar = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("T", new TypeSignatureParameter[0])}).typeVariableConstraints((List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"T"))).build();
        this.assertThat(bar).boundTo(UnknownType.UNKNOWN, BigintType.BIGINT).withCoercion().produces(new BoundVariables((Map)ImmutableMap.of((Object)"T", (Object)BigintType.BIGINT), (Map)ImmutableMap.of()));
        this.assertThat(bar).boundTo(VarcharType.VARCHAR, BigintType.BIGINT).withCoercion().fails();
        this.assertThat(bar).boundTo(HyperLogLogType.HYPER_LOG_LOG, HyperLogLogType.HYPER_LOG_LOG).withCoercion().fails();
    }

    @Test
    public void testFunction() {
        Signature simple = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.functionType((TypeSignature)IntegerType.INTEGER.getTypeSignature(), (TypeSignature[])new TypeSignature[]{IntegerType.INTEGER.getTypeSignature()})}).build();
        this.assertThat(simple).boundTo(IntegerType.INTEGER).fails();
        this.assertThat(simple).boundTo(new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER)).succeeds();
        this.assertThat(simple).boundTo(new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)SmallintType.SMALLINT)).withCoercion().fails();
        this.assertThat(simple).boundTo(new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)BigintType.BIGINT)).withCoercion().fails();
        Signature applyTwice = TestSignatureBinder.functionSignature().returnType(new TypeSignature("V", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("U", new TypeSignatureParameter[0])}), TypeSignature.functionType((TypeSignature)new TypeSignature("U", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("V", new TypeSignatureParameter[0])})}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T"), Signature.typeVariable((String)"U"), Signature.typeVariable((String)"V")}).build();
        this.assertThat(applyTwice).boundTo(IntegerType.INTEGER, IntegerType.INTEGER, IntegerType.INTEGER).fails();
        this.assertThat(applyTwice).boundTo(IntegerType.INTEGER, new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR), new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE)).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("U", (Type)VarcharType.VARCHAR).setTypeVariable("V", (Type)DoubleType.DOUBLE).build());
        this.assertThat(applyTwice).boundTo(IntegerType.INTEGER, new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE).getTypeSignature())).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("U", (Type)VarcharType.VARCHAR).setTypeVariable("V", (Type)DoubleType.DOUBLE).build());
        this.assertThat(applyTwice).boundTo(new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE).getTypeSignature())).fails();
        this.assertThat(applyTwice).boundTo(new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)VarcharType.VARCHAR).getTypeSignature()), IntegerType.INTEGER, new TypeSignatureProvider(functionArgumentTypes -> new FunctionType((List)ImmutableList.of((Object)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE).getTypeSignature())).fails();
        Signature flatMap = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))})}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T")}).build();
        this.assertThat(flatMap).boundTo(new ArrayType((Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER))).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).build());
        Signature varargApply = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T")}).setVariableArity(true).build();
        this.assertThat(varargApply).boundTo(IntegerType.INTEGER, new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER)).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).build());
        this.assertThat(varargApply).boundTo(IntegerType.INTEGER, new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)IntegerType.INTEGER), new FunctionType((List)ImmutableList.of((Object)IntegerType.INTEGER), (Type)DoubleType.DOUBLE), new FunctionType((List)ImmutableList.of((Object)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE)).fails();
        Signature loop = TestSignatureBinder.functionSignature().returnType(new TypeSignature("T", new TypeSignatureParameter[0])).argumentTypes(new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T")}).build();
        this.assertThat(loop).boundTo(IntegerType.INTEGER, new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)BigintType.BIGINT).getTypeSignature())).fails();
        this.assertThat(loop).boundTo(IntegerType.INTEGER, new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)BigintType.BIGINT).getTypeSignature())).withCoercion().produces(BoundVariables.builder().setTypeVariable("T", (Type)BigintType.BIGINT).build());
        this.assertThat(loop).withCoercion().boundTo(IntegerType.INTEGER, new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)SmallintType.SMALLINT).getTypeSignature())).fails();
        Signature varcharApply = TestSignatureBinder.functionSignature().returnType(VarcharType.VARCHAR.getTypeSignature()).argumentTypes(new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature(), TypeSignature.functionType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature[])new TypeSignature[]{new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})})}).build();
        this.assertThat(varcharApply).withCoercion().boundTo(VarcharType.createVarcharType((int)10), new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)VarcharType.createVarcharType((int)1)).getTypeSignature())).succeeds();
        Signature sortByKey = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("E", new TypeSignatureParameter[0])})}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T"), Signature.orderableTypeParameter((String)"E")}).build();
        this.assertThat(sortByKey).boundTo(new ArrayType((Type)IntegerType.INTEGER), new TypeSignatureProvider(paramTypes -> new FunctionType(paramTypes, (Type)VarcharType.VARCHAR).getTypeSignature())).produces(BoundVariables.builder().setTypeVariable("T", (Type)IntegerType.INTEGER).setTypeVariable("E", (Type)VarcharType.VARCHAR).build());
    }

    @Test
    public void testCanCoerceTo() {
        Signature arrayJoin = TestSignatureBinder.functionSignature().returnType(VarcharType.VARCHAR.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.castableToTypeParameter((String)"E", (TypeSignature[])new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature()})}).build();
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)IntegerType.INTEGER)).produces(BoundVariables.builder().setTypeVariable("E", (Type)IntegerType.INTEGER).build());
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)VarbinaryType.VARBINARY)).fails();
        Signature castArray = TestSignatureBinder.functionSignature().returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("F", new TypeSignatureParameter[0]))}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.typeVariable((String)"T"), Signature.castableToTypeParameter((String)"F", (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0])})}).build();
        this.assertThat(castArray).boundTo((List<Type>)ImmutableList.of((Object)new ArrayType((Type)IntegerType.INTEGER)), (Type)new ArrayType((Type)VarcharType.VARCHAR)).produces(BoundVariables.builder().setTypeVariable("F", (Type)IntegerType.INTEGER).setTypeVariable("T", (Type)VarcharType.VARCHAR).build());
        this.assertThat(castArray).boundTo(new ArrayType((Type)IntegerType.INTEGER), new ArrayType((Type)TimestampType.TIMESTAMP)).fails();
        Signature multiCast = TestSignatureBinder.functionSignature().returnType(VarcharType.VARCHAR.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0]))}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.castableToTypeParameter((String)"E", (TypeSignature[])new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature(), IntegerType.INTEGER.getTypeSignature()})}).build();
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TinyintType.TINYINT)).produces(BoundVariables.builder().setTypeVariable("E", (Type)TinyintType.TINYINT).build());
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TimestampType.TIMESTAMP)).fails();
    }

    @Test
    public void testCanCoerceFrom() {
        Signature arrayJoin = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), JsonType.JSON.getTypeSignature()}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.castableFromTypeParameter((String)"E", (TypeSignature[])new TypeSignature[]{JsonType.JSON.getTypeSignature()})}).build();
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)IntegerType.INTEGER), JsonType.JSON).produces(BoundVariables.builder().setTypeVariable("E", (Type)IntegerType.INTEGER).build());
        this.assertThat(arrayJoin).boundTo(new ArrayType((Type)VarbinaryType.VARBINARY)).fails();
        Signature multiCast = TestSignatureBinder.functionSignature().returnType(BooleanType.BOOLEAN.getTypeSignature()).argumentTypes(new TypeSignature[]{TypeSignature.arrayType((TypeSignature)new TypeSignature("E", new TypeSignatureParameter[0])), JsonType.JSON.getTypeSignature()}).typeVariableConstraints(new TypeVariableConstraint[]{Signature.castableFromTypeParameter((String)"E", (TypeSignature[])new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature(), JsonType.JSON.getTypeSignature()})}).build();
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TinyintType.TINYINT), JsonType.JSON).produces(BoundVariables.builder().setTypeVariable("E", (Type)TinyintType.TINYINT).build());
        this.assertThat(multiCast).boundTo(new ArrayType((Type)TimestampType.TIMESTAMP), JsonType.JSON).fails();
    }

    @Test
    public void testBindParameters() {
        BoundVariables boundVariables = BoundVariables.builder().setTypeVariable("T1", (Type)DoubleType.DOUBLE).setTypeVariable("T2", (Type)BigintType.BIGINT).setTypeVariable("T3", (Type)DecimalType.createDecimalType((int)5, (int)3)).setLongVariable("p", Long.valueOf(1L)).setLongVariable("s", Long.valueOf(2L)).build();
        TestSignatureBinder.assertThat("bigint", boundVariables, "bigint");
        TestSignatureBinder.assertThat("T1", boundVariables, "double");
        TestSignatureBinder.assertThat("T2", boundVariables, "bigint");
        TestSignatureBinder.assertThat("array(T1)", boundVariables, "array(double)");
        TestSignatureBinder.assertThat("array(T3)", boundVariables, "array(decimal(5,3))");
        TestSignatureBinder.assertThat("map(T1,T2)", boundVariables, "map(double,bigint)");
        TestSignatureBinder.assertThat("bla(T1,42,T2)", boundVariables, "bla(double,42,bigint)");
        TestSignatureBinder.assertThat("varchar(p)", boundVariables, "varchar(1)");
        TestSignatureBinder.assertThat("char(p)", boundVariables, "char(1)");
        TestSignatureBinder.assertThat("decimal(p,s)", boundVariables, "decimal(1,2)");
        TestSignatureBinder.assertThat("array(decimal(p,s))", boundVariables, "array(decimal(1,2))");
        TestSignatureBinder.assertBindVariablesFails("T1(bigint)", boundVariables, "Unbounded parameters cannot have parameters");
    }

    private static void assertBindVariablesFails(String typeSignature, BoundVariables boundVariables, String reason) {
        try {
            SignatureBinder.applyBoundVariables((TypeSignature)TypeSignatureTranslator.parseTypeSignature((String)typeSignature, (Set)ImmutableSet.of((Object)"p", (Object)"s")), (BoundVariables)boundVariables);
            Assert.fail((String)reason);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static void assertThat(String typeSignature, BoundVariables boundVariables, String expectedTypeSignature) {
        Assert.assertEquals((String)SignatureBinder.applyBoundVariables((TypeSignature)TypeSignatureTranslator.parseTypeSignature((String)typeSignature, (Set)ImmutableSet.of((Object)"p", (Object)"s")), (BoundVariables)boundVariables).toString(), (String)expectedTypeSignature);
    }

    private static SignatureBuilder functionSignature() {
        return new SignatureBuilder().name("function").kind(FunctionKind.SCALAR);
    }

    private Type type(TypeSignature signature) {
        return Objects.requireNonNull(this.metadata.getType(signature));
    }

    private BindSignatureAssertion assertThat(Signature function) {
        return new BindSignatureAssertion(function);
    }

    private class BindSignatureAssertion {
        private final Signature function;
        private List<TypeSignatureProvider> argumentTypes;
        private Type returnType;
        private boolean allowCoercion;

        private BindSignatureAssertion(Signature function) {
            this.function = function;
        }

        public BindSignatureAssertion withCoercion() {
            this.allowCoercion = true;
            return this;
        }

        public BindSignatureAssertion boundTo(Object ... arguments) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object argument : arguments) {
                if (argument instanceof Type) {
                    builder.add((Object)new TypeSignatureProvider(((Type)argument).getTypeSignature()));
                    continue;
                }
                if (argument instanceof TypeSignatureProvider) {
                    builder.add((Object)((TypeSignatureProvider)argument));
                    continue;
                }
                throw new IllegalArgumentException(String.format("argument is of type %s. It should be Type or TypeSignatureProvider", argument.getClass()));
            }
            this.argumentTypes = builder.build();
            return this;
        }

        public BindSignatureAssertion boundTo(List<Type> arguments, Type returnType) {
            this.argumentTypes = TypeSignatureProvider.fromTypes(arguments);
            this.returnType = returnType;
            return this;
        }

        public BindSignatureAssertion succeeds() {
            Assert.assertTrue((boolean)this.bindVariables().isPresent());
            return this;
        }

        public BindSignatureAssertion fails() {
            Assert.assertFalse((boolean)this.bindVariables().isPresent());
            return this;
        }

        public BindSignatureAssertion produces(BoundVariables expected) {
            Optional<BoundVariables> actual = this.bindVariables();
            Assert.assertTrue((boolean)actual.isPresent());
            Assert.assertEquals((Object)actual.get(), (Object)expected);
            return this;
        }

        private Optional<BoundVariables> bindVariables() {
            Assert.assertNotNull(this.argumentTypes);
            SignatureBinder signatureBinder = new SignatureBinder(TestSignatureBinder.this.metadata, this.function, this.allowCoercion);
            if (this.returnType == null) {
                return signatureBinder.bindVariables(this.argumentTypes);
            }
            return signatureBinder.bindVariables(this.argumentTypes, this.returnType.getTypeSignature());
        }
    }
}

