/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.SystemSessionProperties;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DynamicFilterSourceOperator;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.tpch.LineItem;
import io.prestosql.tpch.LineItemGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkDynamicFilterSourceOperator {
    private static final int TOTAL_POSITIONS = 1000000;

    @Benchmark
    public List<Page> dynamicFilterCollect(BenchmarkContext context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void testBenchmark() {
        BenchmarkContext context = new BenchmarkContext();
        context.setup();
        List<Page> outputPages = this.dynamicFilterCollect(context);
        Assert.assertEquals((int)1000000, (int)outputPages.stream().mapToInt(Page::getPositionCount).sum());
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkDynamicFilterSourceOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkContext {
        @Param(value={"32", "256", "1024"})
        private String positionsPerPage = "32";
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            this.pages = BenchmarkContext.createInputPages(Integer.valueOf(this.positionsPerPage));
            this.operatorFactory = new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(1, new PlanNodeId("joinNodeId"), tupleDomain -> {}, (List)ImmutableList.of((Object)new DynamicFilterSourceOperator.Channel(new DynamicFilterId("0"), (Type)BigintType.BIGINT, 0)), SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)SessionTestUtils.TEST_SESSION), SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)SessionTestUtils.TEST_SESSION));
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        private static List<Page> createInputPages(int positionsPerPage) {
            ImmutableList.Builder pages = ImmutableList.builder();
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT));
            LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
            Iterator iterator = lineItemGenerator.iterator();
            for (int i = 0; i < 1000000; ++i) {
                pageBuilder.declarePosition();
                LineItem lineItem = (LineItem)iterator.next();
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), lineItem.getOrderKey());
                if (pageBuilder.getPositionCount() != positionsPerPage) continue;
                pages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
            if (pageBuilder.getPositionCount() > 0) {
                pages.add((Object)pageBuilder.build());
            }
            return pages.build();
        }
    }
}

