/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.array.LongBigArray;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.BigintGroupByHash;
import io.prestosql.operator.GroupByHash;
import io.prestosql.operator.MultiChannelGroupByHash;
import io.prestosql.operator.UpdateMemory;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.type.BigintOperators;
import io.prestosql.type.VarcharOperators;
import it.unimi.dsi.fastutil.HashCommon;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkGroupByHash {
    private static final int POSITIONS = 10000000;
    private static final String GROUP_COUNT_STRING = "3000000";
    private static final int GROUP_COUNT = Integer.parseInt("3000000");
    private static final int EXPECTED_SIZE = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object groupByHashPreCompute(BenchmarkData data) {
        MultiChannelGroupByHash groupByHash = new MultiChannelGroupByHash(data.getTypes(), data.getChannels(), data.getHashChannel(), 10000, false, BenchmarkGroupByHash.getJoinCompiler(), UpdateMemory.NOOP);
        data.getPages().forEach(arg_0 -> BenchmarkGroupByHash.lambda$groupByHashPreCompute$0((GroupByHash)groupByHash, arg_0));
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder, 0);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pageBuilder.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object addPagePreCompute(BenchmarkData data) {
        MultiChannelGroupByHash groupByHash = new MultiChannelGroupByHash(data.getTypes(), data.getChannels(), data.getHashChannel(), 10000, false, BenchmarkGroupByHash.getJoinCompiler(), UpdateMemory.NOOP);
        data.getPages().forEach(arg_0 -> BenchmarkGroupByHash.lambda$addPagePreCompute$1((GroupByHash)groupByHash, arg_0));
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder, 0);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pageBuilder.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object bigintGroupByHash(SingleChannelBenchmarkData data) {
        BigintGroupByHash groupByHash = new BigintGroupByHash(0, data.getHashEnabled(), 10000, UpdateMemory.NOOP);
        data.getPages().forEach(arg_0 -> BenchmarkGroupByHash.lambda$bigintGroupByHash$2((GroupByHash)groupByHash, arg_0));
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder, 0);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pageBuilder.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public long baseline(BaselinePagesData data) {
        int hashSize = HashCommon.arraySize((int)GROUP_COUNT, (float)0.9f);
        int mask = hashSize - 1;
        long[] table = new long[hashSize];
        Arrays.fill(table, -1L);
        long groupIds = 0L;
        for (Page page : data.getPages()) {
            Block block = page.getBlock(0);
            int positionCount = block.getPositionCount();
            for (int position = 0; position < positionCount; ++position) {
                long value = block.getLong(position, 0);
                int tablePosition = (int)(value & (long)mask);
                while (table[tablePosition] != -1L && table[tablePosition] != value) {
                    ++tablePosition;
                }
                if (table[tablePosition] != -1L) continue;
                table[tablePosition] = value;
                ++groupIds;
            }
        }
        return groupIds;
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public long baselineBigArray(BaselinePagesData data) {
        int hashSize = HashCommon.arraySize((int)GROUP_COUNT, (float)0.9f);
        int mask = hashSize - 1;
        LongBigArray table = new LongBigArray(-1L);
        table.ensureCapacity((long)hashSize);
        long groupIds = 0L;
        for (Page page : data.getPages()) {
            Block block = page.getBlock(0);
            int positionCount = block.getPositionCount();
            for (int position = 0; position < positionCount; ++position) {
                long value = BigintType.BIGINT.getLong(block, position);
                int tablePosition = (int)XxHash64.hash((long)value) & mask;
                while (table.get((long)tablePosition) != -1L && table.get((long)tablePosition) != value) {
                    ++tablePosition;
                }
                if (table.get((long)tablePosition) != -1L) continue;
                table.set((long)tablePosition, value);
                ++groupIds;
            }
        }
        return groupIds;
    }

    private static List<Page> createBigintPages(int positionCount, int groupCount, int channelCount, boolean hashEnabled) {
        ImmutableList types = Collections.nCopies(channelCount, BigintType.BIGINT);
        ImmutableList.Builder pages = ImmutableList.builder();
        if (hashEnabled) {
            types = ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT)));
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int position = 0; position < positionCount; ++position) {
            int rand = ThreadLocalRandom.current().nextInt(groupCount);
            pageBuilder.declarePosition();
            for (int numChannel = 0; numChannel < channelCount; ++numChannel) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(numChannel), (long)rand);
            }
            if (hashEnabled) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(channelCount), BigintOperators.hashCode((long)rand));
            }
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pages.build();
    }

    private static List<Page> createVarcharPages(int positionCount, int groupCount, int channelCount, boolean hashEnabled) {
        ImmutableList types = Collections.nCopies(channelCount, VarcharType.VARCHAR);
        ImmutableList.Builder pages = ImmutableList.builder();
        if (hashEnabled) {
            types = ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT)));
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int position = 0; position < positionCount; ++position) {
            int rand = ThreadLocalRandom.current().nextInt(groupCount);
            Slice value = Slices.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(4).putInt(rand));
            pageBuilder.declarePosition();
            for (int channel = 0; channel < channelCount; ++channel) {
                VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(channel), value);
            }
            if (hashEnabled) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(channelCount), VarcharOperators.hashCode((Slice)value));
            }
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pages.build();
    }

    private static JoinCompiler getJoinCompiler() {
        return new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkGroupByHash().groupByHashPreCompute(data);
        new BenchmarkGroupByHash().addPagePreCompute(data);
        SingleChannelBenchmarkData singleChannelBenchmarkData = new SingleChannelBenchmarkData();
        singleChannelBenchmarkData.setup();
        new BenchmarkGroupByHash().bigintGroupByHash(singleChannelBenchmarkData);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkGroupByHash.class.getSimpleName() + ".*").addProfiler(GCProfiler.class).jvmArgs(new String[]{"-Xmx10g"}).build();
        new Runner(options).run();
    }

    private static /* synthetic */ void lambda$bigintGroupByHash$2(GroupByHash groupByHash, Page p) {
        groupByHash.addPage(p).process();
    }

    private static /* synthetic */ void lambda$addPagePreCompute$1(GroupByHash groupByHash, Page p) {
        groupByHash.addPage(p).process();
    }

    private static /* synthetic */ void lambda$groupByHashPreCompute$0(GroupByHash groupByHash, Page p) {
        groupByHash.getGroupIds(p).process();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "5", "10", "15", "20"})
        private int channelCount = 1;
        @Param(value={"3000000"})
        private int groupCount = GROUP_COUNT;
        @Param(value={"true", "false"})
        private boolean hashEnabled;
        @Param(value={"VARCHAR", "BIGINT"})
        private String dataType = "VARCHAR";
        private List<Page> pages;
        private Optional<Integer> hashChannel;
        private List<Type> types;
        private int[] channels;

        @Setup
        public void setup() {
            switch (this.dataType) {
                case "VARCHAR": {
                    this.types = Collections.nCopies(this.channelCount, VarcharType.VARCHAR);
                    this.pages = BenchmarkGroupByHash.createVarcharPages(10000000, this.groupCount, this.channelCount, this.hashEnabled);
                    break;
                }
                case "BIGINT": {
                    this.types = Collections.nCopies(this.channelCount, BigintType.BIGINT);
                    this.pages = BenchmarkGroupByHash.createBigintPages(10000000, this.groupCount, this.channelCount, this.hashEnabled);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported dataType");
                }
            }
            this.hashChannel = this.hashEnabled ? Optional.of(this.channelCount) : Optional.empty();
            this.channels = new int[this.channelCount];
            for (int i = 0; i < this.channelCount; ++i) {
                this.channels[i] = i;
            }
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public Optional<Integer> getHashChannel() {
            return this.hashChannel;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public int[] getChannels() {
            return this.channels;
        }
    }

    @State(value=Scope.Thread)
    public static class SingleChannelBenchmarkData {
        @Param(value={"1"})
        private int channelCount = 1;
        @Param(value={"true", "false"})
        private boolean hashEnabled = true;
        @Param(value={"3000000"})
        private int groupCount = GROUP_COUNT;
        private List<Page> pages;
        private List<Type> types;
        private int[] channels;

        @Setup
        public void setup() {
            this.pages = BenchmarkGroupByHash.createBigintPages(10000000, GROUP_COUNT, this.channelCount, this.hashEnabled);
            this.types = Collections.nCopies(1, BigintType.BIGINT);
            this.channels = new int[1];
            for (int i = 0; i < 1; ++i) {
                this.channels[i] = i;
            }
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public boolean getHashEnabled() {
            return this.hashEnabled;
        }
    }

    @State(value=Scope.Thread)
    public static class BaselinePagesData {
        @Param(value={"1"})
        private int channelCount = 1;
        @Param(value={"false"})
        private boolean hashEnabled;
        @Param(value={"3000000"})
        private int groupCount;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.pages = BenchmarkGroupByHash.createBigintPages(10000000, this.groupCount, this.channelCount, this.hashEnabled);
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

