/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.SequencePageBuilder;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Split;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.ScanFilterAndProjectOperator;
import io.prestosql.operator.SourceOperator;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.project.CursorProcessor;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.ExpressionTestUtils;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SqlToRowExpressionTranslator;
import io.prestosql.sql.tree.Expression;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingMetadata;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.TestingSplit;
import io.prestosql.testing.TestingTaskContext;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=5)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkScanFilterAndProjectOperator {
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeAnalyzer TYPE_ANALYZER = new TypeAnalyzer(new SqlParser(), METADATA);
    private static final int TOTAL_POSITIONS = 1000000;
    private static final DataSize FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE = DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private static final int FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_ROW_COUNT = 256;

    @Benchmark
    public List<Page> benchmarkColumnOriented(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        SourceOperator operator = (SourceOperator)context.getOperatorFactory().createOperator(driverContext);
        ImmutableList.Builder outputPages = ImmutableList.builder();
        operator.addSplit(new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), Lifespan.taskWide()));
        operator.noMoreSplits();
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void testBenchmark() {
        Context context = new Context();
        context.setup();
        this.benchmarkColumnOriented(context);
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkScanFilterAndProjectOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
        private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        @Param(value={"32", "1024"})
        int positionsPerPage = 32;
        @Param(value={"2", "4", "8", "16", "32"})
        int columnCount = 2;
        @Param(value={"varchar", "bigint"})
        String type = "varchar";
        @Param(value={"false", "true"})
        boolean dictionaryBlocks;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            Type type = TYPE_MAP.get(this.type);
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                Symbol symbol = new Symbol(type.getDisplayName().toLowerCase(Locale.ENGLISH) + i2);
                this.symbolTypes.put(symbol, type);
                this.sourceLayout.put(symbol, i2);
            }
            List<RowExpression> projections = this.getProjections(type);
            List<Type> types = projections.stream().map(RowExpression::getType).collect(Collectors.toList());
            List columnHandles = (List)IntStream.range(0, this.columnCount).mapToObj(i -> new TestingMetadata.TestingColumnHandle(Integer.toString(i))).collect(ImmutableList.toImmutableList());
            PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler(METADATA, 0);
            PageProcessor pageProcessor = (PageProcessor)new ExpressionCompiler(METADATA, pageFunctionCompiler).compilePageProcessor(Optional.of(this.getFilter(type)), projections).get();
            CursorProcessor cursorProcessor = (CursorProcessor)new ExpressionCompiler(METADATA, pageFunctionCompiler).compileCursorProcessor(Optional.of(this.getFilter(type)), projections, (Object)"key").get();
            this.createTaskContext();
            this.createScanFilterAndProjectOperatorFactories(this.createInputPages(types), pageProcessor, cursorProcessor, columnHandles, types);
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        private void createScanFilterAndProjectOperatorFactories(List<Page> inputPages, PageProcessor pageProcessor, CursorProcessor cursorProcessor, List<ColumnHandle> columnHandles, List<Type> types) {
            this.operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("test_source"), (session, split, table, columns, dynamicFilter) -> new FixedPageSource((Iterable)inputPages), () -> cursorProcessor, () -> pageProcessor, TestingHandles.TEST_TABLE_HANDLE, columnHandles, TupleDomain::all, types, FILTER_AND_PROJECT_MIN_OUTPUT_PAGE_SIZE, 256);
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        private List<Page> createInputPages(List<Type> types) {
            ImmutableList.Builder inputPagesBuilder = ImmutableList.builder();
            for (int i = 0; i < 1000000 / this.positionsPerPage; ++i) {
                inputPagesBuilder.add((Object)Context.createPage(types, this.positionsPerPage, this.dictionaryBlocks));
            }
            return inputPagesBuilder.build();
        }

        private RowExpression getFilter(Type type) {
            if (type == VarcharType.VARCHAR) {
                return this.rowExpression("cast(varchar0 as bigint) % 2 = 0");
            }
            if (type == BigintType.BIGINT) {
                return this.rowExpression("bigint0 % 2 = 0");
            }
            throw new IllegalArgumentException("filter not supported for type : " + type);
        }

        private List<RowExpression> getProjections(Type type) {
            ImmutableList.Builder builder;
            block3: {
                block2: {
                    builder = ImmutableList.builder();
                    if (type != BigintType.BIGINT) break block2;
                    for (int i = 0; i < this.columnCount; ++i) {
                        builder.add((Object)this.rowExpression("bigint" + i + " + 5"));
                    }
                    break block3;
                }
                if (type != VarcharType.VARCHAR) break block3;
                for (int i = 0; i < this.columnCount; ++i) {
                    builder.add((Object)this.rowExpression("concat(varchar" + i + ", 'foo')"));
                }
            }
            return builder.build();
        }

        private RowExpression rowExpression(String value) {
            Expression expression = ExpressionTestUtils.createExpression(value, METADATA, TypeProvider.copyOf(this.symbolTypes));
            return SqlToRowExpressionTranslator.translate((Expression)expression, ExpressionTestUtils.getTypes(TEST_SESSION, METADATA, TypeProvider.copyOf(this.symbolTypes), expression), this.sourceLayout, (Metadata)METADATA, (Session)TEST_SESSION, (boolean)true);
        }

        private static Page createPage(List<? extends Type> types, int positions, boolean dictionary) {
            if (dictionary) {
                return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, positions);
            }
            return SequencePageBuilder.createSequencePage(types, positions);
        }
    }
}

