/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.DummySpillerFactory;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.TaskContext;
import io.prestosql.operator.TestWindowOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.TestingTaskContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=5)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkWindowOperator {
    @Benchmark
    public List<Page> benchmark(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void verifyUnGroupedWithMultiplePartitions() {
        this.verify(10, 0, false);
    }

    @Test
    public void verifyUnGroupedWithSinglePartition() {
        this.verify(10, 0, true);
    }

    @Test
    public void verifyPartiallyGroupedWithMultiplePartitions() {
        this.verify(10, 1, false);
    }

    @Test
    public void verifyPartiallyGroupedWithSinglePartition() {
        this.verify(10, 1, true);
    }

    @Test
    public void verifyFullyGroupedWithMultiplePartitions() {
        this.verify(10, 2, false);
    }

    @Test
    public void verifyFullyGroupedWithSinglePartition() {
        this.verify(10, 2, true);
    }

    @Test
    public void verifyFullyGroupedAndFullySortedWithMultiplePartitions() {
        this.verify(10, 3, false);
    }

    @Test
    public void verifyFullyGroupedAndFullySortedWithSinglePartition() {
        this.verify(10, 3, true);
    }

    private void verify(int numberOfRowsPerPartition, int numberOfPreGroupedColumns, boolean useSinglePartition) {
        Context context = new Context();
        context.rowsPerPartition = numberOfRowsPerPartition;
        context.numberOfPregroupedColumns = numberOfPreGroupedColumns;
        if (useSinglePartition) {
            context.partitionsPerGroup = 1;
            context.rowsPerPartition = 10000;
        }
        context.setup();
        Assert.assertEquals((int)140, (int)context.getPages().size());
        for (int i = 0; i < 140; ++i) {
            Assert.assertEquals((int)10000, (int)context.getPages().get(i).getPositionCount());
        }
        this.benchmark(context);
        context.cleanup();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkWindowOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        public static final int NUMBER_OF_GROUP_COLUMNS = 2;
        public static final int TOTAL_PAGES = 140;
        public static final int ROWS_PER_PAGE = 10000;
        private static final List<Integer> PARTITION_CHANNELS = Ints.asList((int[])new int[]{0, 1});
        @Param(value={"10", "20", "100"})
        public int rowsPerPartition;
        @Param(value={"0", "1", "2", "3"})
        public int numberOfPregroupedColumns;
        @Param(value={"10", "50", "100"})
        public int partitionsPerGroup;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            this.createOperatorFactoryAndGenerateTestData(this.numberOfPregroupedColumns);
        }

        @TearDown
        public void cleanup() {
            this.executor.shutdownNow();
            this.scheduledExecutor.shutdownNow();
        }

        private void createOperatorFactoryAndGenerateTestData(int numberOfPreGroupedColumns) {
            this.pages = this.generateTestData();
            this.operatorFactory = numberOfPreGroupedColumns == 0 ? TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0, 1, 2, 3}), TestWindowOperator.ROW_NUMBER, PARTITION_CHANNELS, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0, new DummySpillerFactory(), false) : (numberOfPreGroupedColumns < 2 ? TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0, 1, 2, 3}), TestWindowOperator.ROW_NUMBER, PARTITION_CHANNELS, Ints.asList((int[])new int[]{1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0, new DummySpillerFactory(), false) : TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0, 1, 2, 3}), TestWindowOperator.ROW_NUMBER, PARTITION_CHANNELS, Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), numberOfPreGroupedColumns - 2, new DummySpillerFactory(), false));
        }

        private List<Page> generateTestData() {
            ArrayList<Type> typesArray = new ArrayList<Type>();
            int currentPartitionIdentifier = 1;
            typesArray.add((Type)BigintType.BIGINT);
            typesArray.add((Type)BigintType.BIGINT);
            typesArray.add((Type)BigintType.BIGINT);
            typesArray.add((Type)BigintType.BIGINT);
            RowPagesBuilder pagesBuilder = this.buildPages(currentPartitionIdentifier, typesArray);
            return pagesBuilder.build();
        }

        private RowPagesBuilder buildPages(int currentPartitionIdentifier, List<Type> typesArray) {
            int groupIdentifier = 100;
            RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)ImmutableList.of((Object)0), typesArray);
            for (int i = 0; i < 140; ++i) {
                BlockBuilder firstColumnBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 10000);
                BlockBuilder secondColumnBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 10000);
                int currentNumberOfRowsInPartition = 0;
                int numberOfPartitionsInCurrentGroup = 0;
                int currentGroupIdentifier = groupIdentifier++;
                for (int j = 0; j < 10000; ++j) {
                    if (currentNumberOfRowsInPartition == this.rowsPerPartition) {
                        ++currentPartitionIdentifier;
                        ++numberOfPartitionsInCurrentGroup;
                        currentNumberOfRowsInPartition = 0;
                    }
                    if (numberOfPartitionsInCurrentGroup == this.partitionsPerGroup) {
                        numberOfPartitionsInCurrentGroup = 0;
                        currentGroupIdentifier = groupIdentifier++;
                    }
                    firstColumnBlockBuilder.writeLong((long)currentGroupIdentifier);
                    secondColumnBlockBuilder.writeLong((long)currentPartitionIdentifier);
                    ++currentNumberOfRowsInPartition;
                }
                rowPagesBuilder.addBlocksPage(firstColumnBlockBuilder.build(), secondColumnBlockBuilder.build(), BlockAssertions.createLongSequenceBlock(0, 10000), BlockAssertions.createLongSequenceBlock(0, 10000));
            }
            return rowPagesBuilder;
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

