/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public final class GenericLongFunction
extends SqlScalarFunction {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(GenericLongFunction.class, (String)"apply", (Class[])new Class[]{LongUnaryOperator.class, Long.TYPE});
    private final LongUnaryOperator longUnaryOperator;

    GenericLongFunction(String suffix, LongUnaryOperator longUnaryOperator) {
        super(new FunctionMetadata(new Signature("generic_long_" + Objects.requireNonNull(suffix, "suffix is null"), FunctionKind.SCALAR, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}), false, (List)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), true, true, "generic long function for test", FunctionKind.SCALAR));
        this.longUnaryOperator = longUnaryOperator;
    }

    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(this.longUnaryOperator);
        return new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle);
    }

    public static long apply(LongUnaryOperator longUnaryOperator, long value) {
        return longUnaryOperator.applyAsLong(value);
    }
}

