/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.TestAnnotationEngine;
import io.prestosql.operator.annotations.LiteralImplementationDependency;
import io.prestosql.operator.annotations.TypeImplementationDependency;
import io.prestosql.operator.scalar.ParametricScalar;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.operator.scalar.annotations.ParametricScalarImplementation;
import io.prestosql.operator.scalar.annotations.ScalarFromAnnotationsParser;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForScalars
extends TestAnnotationEngine {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testSingleImplementationScalarParse() {
        Signature expectedSignature = new Signature("single_implementation_parametric_scalar", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SingleImplementationScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with single implementation based on class");
        this.assertImplementationCount(scalar, 1, 0, 0);
        ScalarFunctionImplementation specialized = scalar.specialize(BoundVariables.builder().build(), 1, METADATA);
        Assert.assertFalse((boolean)specialized.getInstanceFactory().isPresent());
        Assert.assertEquals((Object)specialized.getArgumentProperty(0).getNullConvention(), (Object)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL);
    }

    @Test
    public void testHiddenScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(HiddenScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertTrue((boolean)functionMetadata.isHidden());
    }

    @Test
    public void testNonDeterministicScalarParse() {
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(NonDeterministicScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertFalse((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
    }

    @Test
    public void testWithNullablePrimitiveArgScalarParse() {
        Signature expectedSignature = new Signature("scalar_with_nullable", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullablePrimitiveArgScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with nullable primitive");
        ScalarFunctionImplementation specialized = scalar.specialize(BoundVariables.builder().build(), 2, METADATA);
        Assert.assertFalse((boolean)specialized.getInstanceFactory().isPresent());
        Assert.assertEquals((Object)specialized.getArgumentProperty(0), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        Assert.assertEquals((Object)specialized.getArgumentProperty(1), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG));
    }

    @Test
    public void testWithNullableComplexArgScalarParse() {
        Signature expectedSignature = new Signature("scalar_with_nullable_complex", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature(), (Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(WithNullableComplexArgScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with nullable complex type");
        ScalarFunctionImplementation specialized = scalar.specialize(BoundVariables.builder().build(), 2, METADATA);
        Assert.assertFalse((boolean)specialized.getInstanceFactory().isPresent());
        Assert.assertEquals((Object)specialized.getArgumentProperty(0), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL));
        Assert.assertEquals((Object)specialized.getArgumentProperty(1), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE));
    }

    @Test
    public void testStaticMethodScalarParse() {
        Signature expectedSignature = new Signature("static_method_scalar", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(StaticMethodScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Simple scalar with single implementation based on method");
    }

    @Test
    public void testMultiScalarParse() {
        Signature expectedSignature1 = new Signature("static_method_scalar_1", DoubleType.DOUBLE.getTypeSignature(), (List)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));
        Signature expectedSignature2 = new Signature("static_method_scalar_2", BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()));
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinitions(MultiScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)2);
        ParametricScalar scalar1 = (ParametricScalar)((ImmutableList)functions.stream().filter(function -> function.getFunctionMetadata().getSignature().equals((Object)expectedSignature1)).collect(ImmutableList.toImmutableList())).get(0);
        ParametricScalar scalar2 = (ParametricScalar)((ImmutableList)functions.stream().filter(function -> function.getFunctionMetadata().getSignature().equals((Object)expectedSignature2)).collect(ImmutableList.toImmutableList())).get(0);
        this.assertImplementationCount(scalar1, 1, 0, 0);
        this.assertImplementationCount(scalar2, 1, 0, 0);
        FunctionMetadata functionMetadata1 = scalar1.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata1.getSignature(), (Object)expectedSignature1);
        Assert.assertTrue((boolean)functionMetadata1.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata1.isHidden());
        Assert.assertEquals((String)functionMetadata1.getDescription(), (String)"Simple scalar with single implementation based on method 1");
        FunctionMetadata functionMetadata2 = scalar2.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata2.getSignature(), (Object)expectedSignature2);
        Assert.assertFalse((boolean)functionMetadata2.isDeterministic());
        Assert.assertTrue((boolean)functionMetadata2.isHidden());
        Assert.assertEquals((String)functionMetadata2.getDescription(), (String)"Simple scalar with single implementation based on method 2");
    }

    @Test
    public void testParametricScalarParse() {
        Signature expectedSignature = new Signature("parametric_scalar", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ParametricScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 2, 0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar description");
    }

    @Test
    public void testComplexParametricScalarParse() {
        Signature expectedSignature = new Signature("with_exact_scalar", (List)ImmutableList.of(), (List)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}))), false);
        Signature exactSignature = new Signature("with_exact_scalar", (List)ImmutableList.of(), (List)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)VarcharType.createVarcharType((int)17).getTypeSignature())), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ComplexParametricScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar.getImplementations(), 1, 0, 1);
        Assert.assertEquals((Object)Iterables.getOnlyElement(scalar.getImplementations().getExactImplementations().keySet()), (Object)exactSignature);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar with exact and generic implementations");
    }

    @Test
    public void testSimpleInjectionScalarParse() {
        Signature expectedSignature = new Signature("parametric_scalar_inject", (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(SimpleInjectionScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)1);
        Assert.assertTrue((boolean)(dependencies.get(0) instanceof LiteralImplementationDependency));
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar with literal injected");
    }

    @Test
    public void testConstructorInjectionScalarParse() {
        Signature expectedSignature = new Signature("parametric_scalar_inject_constructor", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(ConstructorInjectionScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 2, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)0);
        List constructorDependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getConstructorDependencies();
        Assert.assertEquals((int)constructorDependencies.size(), (int)1);
        Assert.assertTrue((boolean)(constructorDependencies.get(0) instanceof TypeImplementationDependency));
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar with type injected though constructor");
    }

    @Test
    public void testFixedTypeParameterParse() {
        Signature expectedSignature = new Signature("fixed_type_parameter_scalar_function", (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(FixedTypeParameterScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 1, 0, 0);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar that uses TypeParameter with fixed type");
    }

    @Test
    public void testPartiallyFixedTypeParameterParse() {
        Signature expectedSignature = new Signature("partially_fixed_type_parameter_scalar_function", (List)ImmutableList.of((Object)Signature.typeVariable((String)"T1"), (Object)Signature.typeVariable((String)"T2")), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()), false);
        List functions = ScalarFromAnnotationsParser.parseFunctionDefinition(PartiallyFixedTypeParameterScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        ParametricScalar scalar = (ParametricScalar)functions.get(0);
        this.assertImplementationCount(scalar, 0, 0, 1);
        List parametricScalarImplementationChoices = ((ParametricScalarImplementation)scalar.getImplementations().getGenericImplementations().get(0)).getChoices();
        Assert.assertEquals((int)parametricScalarImplementationChoices.size(), (int)1);
        List dependencies = ((ParametricScalarImplementation.ParametricScalarImplementationChoice)parametricScalarImplementationChoices.get(0)).getDependencies();
        Assert.assertEquals((int)dependencies.size(), (int)1);
        FunctionMetadata functionMetadata = scalar.getFunctionMetadata();
        Assert.assertEquals((Object)functionMetadata.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)functionMetadata.isDeterministic());
        Assert.assertFalse((boolean)functionMetadata.isHidden());
        Assert.assertEquals((String)functionMetadata.getDescription(), (String)"Parametric scalar that uses TypeParameter with partially fixed type");
    }

    @ScalarFunction(value="partially_fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with partially fixed type")
    public static final class PartiallyFixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        @TypeParameters(value={@TypeParameter(value="T1"), @TypeParameter(value="T2")})
        public static long fun(@TypeParameter(value="ROW(ARRAY(T1),ROW(ROW(T2)),CHAR)") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="fixed_type_parameter_scalar_function")
    @Description(value="Parametric scalar that uses TypeParameter with fixed type")
    public static final class FixedTypeParameterScalarFunction {
        @SqlType(value="bigint")
        public static long fun(@TypeParameter(value="ROW(ARRAY(BIGINT),ROW(ROW(CHAR)),BIGINT,MAP(BIGINT,CHAR))") Type type, @SqlType(value="bigint") long value) {
            return value;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject_constructor")
    @Description(value="Parametric scalar with type injected though constructor")
    public static class ConstructorInjectionScalarFunction {
        private final Type type;

        @TypeParameter(value="T")
        public ConstructorInjectionScalarFunction(@TypeParameter(value="T") Type type) {
            this.type = type;
        }

        @SqlType(value="bigint")
        @TypeParameter(value="T")
        public long fun(@SqlType(value="array(T)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funBigint(@SqlType(value="array(bigint)") Block val) {
            return 17L;
        }

        @SqlType(value="bigint")
        public long funDouble(@SqlType(value="array(double)") Block val) {
            return 17L;
        }
    }

    @ScalarFunction(value="parametric_scalar_inject")
    @Description(value="Parametric scalar with literal injected")
    public static final class SimpleInjectionScalarFunction {
        @SqlType(value="bigint")
        @LiteralParameters(value={"x"})
        public static long fun(@LiteralParameter(value="x") Long literalParam, @SqlType(value="varchar(x)") Slice val) {
            return literalParam;
        }
    }

    @ScalarFunction(value="with_exact_scalar")
    @Description(value="Parametric scalar with exact and generic implementations")
    public static final class ComplexParametricScalarFunction {
        @SqlType(value="boolean")
        @LiteralParameters(value={"x"})
        public static boolean fun1(@SqlType(value="array(varchar(x))") Block array) {
            return true;
        }

        @SqlType(value="boolean")
        public static boolean fun2(@SqlType(value="array(varchar(17))") Block array) {
            return true;
        }
    }

    @ScalarFunction(value="parametric_scalar")
    @Description(value="Parametric scalar description")
    public static final class ParametricScalarFunction {
        @SqlType(value="T")
        @TypeParameter(value="T")
        public static double fun(@SqlType(value="T") double v) {
            return v;
        }

        @SqlType(value="T")
        @TypeParameter(value="T")
        public static long fun(@SqlType(value="T") long v) {
            return v;
        }
    }

    public static final class MultiScalarFunction {
        @ScalarFunction(value="static_method_scalar_1")
        @Description(value="Simple scalar with single implementation based on method 1")
        @SqlType(value="double")
        public static double fun1(@SqlType(value="double") double v) {
            return v;
        }

        @ScalarFunction(value="static_method_scalar_2", hidden=true, deterministic=false)
        @Description(value="Simple scalar with single implementation based on method 2")
        @SqlType(value="bigint")
        public static long fun2(@SqlType(value="bigint") long v) {
            return v;
        }
    }

    public static final class StaticMethodScalarFunction {
        @ScalarFunction(value="static_method_scalar")
        @Description(value="Simple scalar with single implementation based on method")
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable_complex")
    @Description(value="Simple scalar with nullable complex type")
    public static final class WithNullableComplexArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlNullable @SqlType(value="double") Double v2) {
            return v;
        }
    }

    @ScalarFunction(value="scalar_with_nullable")
    @Description(value="Simple scalar with nullable primitive")
    public static final class WithNullablePrimitiveArgScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v, @SqlType(value="double") double v2, @IsNull boolean v2isNull) {
            return v;
        }
    }

    @ScalarFunction(value="non_deterministic_scalar_function", deterministic=false)
    @Description(value="Simple scalar with deterministic property reset")
    public static final class NonDeterministicScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="hidden_scalar_function", hidden=true)
    @Description(value="Simple scalar with hidden property set")
    public static final class HiddenScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }

    @ScalarFunction(value="single_implementation_parametric_scalar")
    @Description(value="Simple scalar with single implementation based on class")
    public static final class SingleImplementationScalarFunction {
        @SqlType(value="double")
        public static double fun(@SqlType(value="double") double v) {
            return v;
        }
    }
}

