/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.prestosql.SequencePageBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.SystemSessionProperties;
import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.DynamicFilterSourceOperator;
import io.prestosql.operator.Operator;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PipelineContext;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import io.prestosql.testing.assertions.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDynamicFilterSourceOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private PipelineContext pipelineContext;
    private ImmutableList.Builder<TupleDomain<DynamicFilterId>> partitions;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.pipelineContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false);
        this.partitions = ImmutableList.builder();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    private void verifyPassthrough(Operator operator, List<Type> types, Page ... pages) {
        ImmutableList inputPages = ImmutableList.copyOf((Object[])pages);
        List<Page> outputPages = OperatorAssertion.toPages(operator, inputPages.iterator());
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, outputPages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, (List<Page>)inputPages);
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    private OperatorFactory createOperatorFactory(DynamicFilterSourceOperator.Channel ... buildChannels) {
        return new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(0, new PlanNodeId("PLAN_NODE_ID"), this::consumePredicate, Arrays.stream(buildChannels).collect(Collectors.toList()), SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)SessionTestUtils.TEST_SESSION), SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)SessionTestUtils.TEST_SESSION));
    }

    private void consumePredicate(TupleDomain<DynamicFilterId> partitionPredicate) {
        this.partitions.add(partitionPredicate);
    }

    private Operator createOperator(OperatorFactory operatorFactory) {
        return operatorFactory.createOperator(this.pipelineContext.addDriverContext());
    }

    private static DynamicFilterSourceOperator.Channel channel(int index, Type type) {
        return new DynamicFilterSourceOperator.Channel(new DynamicFilterId(Integer.toString(index)), type, index);
    }

    @Test
    public void testCollectMultipleOperators() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        Operator op1 = this.createOperator(operatorFactory);
        this.verifyPassthrough(op1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2)}), new Page(new Block[]{BlockAssertions.createLongsBlock(3, 5)}));
        Operator op2 = this.createOperator(operatorFactory);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L))))));
        this.verifyPassthrough(op2, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(2, 3)}), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 4)}));
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L)))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L))))));
    }

    @Test
    public void testCollectMultipleColumns() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN), TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false)), (Object)new DynamicFilterId("1"), (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectOnlyFirstColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false))))));
    }

    @Test
    public void testCollectOnlyLastColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("1"), (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectWithNulls() {
        Block blockWithNulls = IntegerType.INTEGER.createFixedSizeBlockBuilder(0).writeInt(3).appendNull().writeInt(4).build();
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)IntegerType.INTEGER));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}), new Page(new Block[]{blockWithNulls}), new Page(new Block[]{BlockAssertions.createLongsBlock(4, 5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}), (boolean)false)))));
    }

    @Test
    public void testCollectWithDoubleNaN() {
        BlockBuilder input = DoubleType.DOUBLE.createBlockBuilder(null, 10);
        DoubleType.DOUBLE.writeDouble(input, 42.0);
        DoubleType.DOUBLE.writeDouble(input, Double.NaN);
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), new Page(new Block[]{input.build()}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)42.0))))));
    }

    @Test
    public void testCollectWithRealNaN() {
        BlockBuilder input = RealType.REAL.createBlockBuilder(null, 10);
        RealType.REAL.writeLong(input, (long)Float.floatToRawIntBits(42.0f));
        RealType.REAL.writeLong(input, (long)Float.floatToRawIntBits(Float.NaN));
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)RealType.REAL));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)RealType.REAL), new Page(new Block[]{input.build()}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)RealType.REAL, (List)ImmutableList.of((Object)Float.floatToRawIntBits(42.0f)))))));
    }

    @Test
    public void testCollectNoFilters() {
        OperatorFactory operatorFactory = this.createOperatorFactory(new DynamicFilterSourceOperator.Channel[0]);
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectEmptyBuildSide() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page[0]);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.none()));
    }

    @Test
    public void testCollectTooMuchRows() {
        int maxRowCount = SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)this.pipelineContext.getSession());
        Page largePage = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), maxRowCount + 1);
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), largePage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooMuchBytesSingleColumn() {
        long maxByteSize = SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)this.pipelineContext.getSession()).toBytes();
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock("A".repeat((int)maxByteSize + 1))});
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)VarcharType.VARCHAR));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), largePage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooMuchBytesMultipleColumns() {
        long maxByteSize = SystemSessionProperties.getDynamicFilteringMaxPerDriverSize((Session)this.pipelineContext.getSession()).toBytes();
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock("A".repeat((int)(maxByteSize / 2L) + 1)), BlockAssertions.createStringsBlock("B".repeat((int)(maxByteSize / 2L) + 1))});
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)VarcharType.VARCHAR), TestDynamicFilterSourceOperator.channel(1, (Type)VarcharType.VARCHAR));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), largePage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectDeduplication() {
        int maxRowCount = SystemSessionProperties.getDynamicFilteringMaxPerDriverRowCount((Session)this.pipelineContext.getSession());
        Page largePage = new Page(new Block[]{BlockAssertions.createLongRepeatBlock(7, maxRowCount * 10)});
        Page nullsPage = new Page(new Block[]{BlockAssertions.createLongsBlock(Arrays.asList(new Long[maxRowCount * 10]))});
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), largePage, nullsPage);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)7L, (Object[])new Object[0]), (boolean)false)))));
    }
}

