/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.SizeOf;
import io.airlift.testing.Assertions;
import io.prestosql.RowPagesBuilder;
import io.prestosql.array.ObjectBigArray;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.GroupByHash;
import io.prestosql.operator.GroupedTopNBuilder;
import io.prestosql.operator.NoChannelGroupByHash;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.PageWithPositionComparator;
import io.prestosql.operator.SimplePageWithPositionComparator;
import io.prestosql.operator.UpdateMemory;
import io.prestosql.operator.Work;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupedTopNBuilder {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(GroupedTopNBuilder.class).instanceSize();
    private static final long INT_FIFO_QUEUE_SIZE = ClassLayout.parseClass(IntArrayFIFOQueue.class).instanceSize();
    private static final long OBJECT_OVERHEAD = ClassLayout.parseClass(Object.class).instanceSize();
    private static final long PAGE_REFERENCE_INSTANCE_SIZE = ClassLayout.parseClass(TestPageReference.class).instanceSize();

    @DataProvider
    public static Object[][] produceRowNumbers() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider
    public static Object[][] pageRowCounts() {
        return new Object[][]{{10000, 20}, {20, 10000}};
    }

    @Test
    public void testEmptyInput() {
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)ImmutableList.of((Object)BigintType.BIGINT), (left, leftPosition, right, rightPosition) -> {
            throw new UnsupportedOperationException();
        }, 5, false, (GroupByHash)new NoChannelGroupByHash());
        Assert.assertFalse((boolean)groupedTopNBuilder.buildResult().hasNext());
    }

    @Test(dataProvider="produceRowNumbers")
    public void testMultiGroupTopN(boolean produceRowNumbers) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(2L, 0.2).row(3L, 0.9).row(3L, 0.1).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(4L, 0.6).row(2L, 0.8).row(2L, 0.7).pageBreak().row(2L, 0.9).build();
        for (Page page : input) {
            page.compact();
        }
        GroupByHash groupByHash = TestGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), UpdateMemory.NOOP);
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 2, produceRowNumbers, groupByHash);
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of(), (List<Integer>)ImmutableList.of(), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4), (List<Integer>)ImmutableList.of((Object)1, (Object)1, (Object)2), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4, (Object)1), (List<Integer>)ImmutableList.of((Object)2, (Object)1, (Object)2), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4, (Object)1, (Object)2), (List<Integer>)ImmutableList.of((Object)2, (Object)2, (Object)2, (Object)1), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4, (Object)1, (Object)2, (Object)0), (List<Integer>)ImmutableList.of((Object)2, (Object)2, (Object)2, (Object)1), groupedTopNBuilder.getEstimatedSizeInBytes());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT}).row(1L, 0.3, 1).row(1L, 0.4, 2).row(2L, 0.2, 1).row(2L, 0.7, 2).row(3L, 0.1, 1).row(3L, 0.9, 2).row(4L, 0.6, 1).build().get(0);
        if (produceRowNumbers) {
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), (Page)output.get(0), expected);
        } else {
            PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), new Page(new Block[]{expected.getBlock(0), expected.getBlock(1)}));
        }
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of((Object)0, (Object)0, (Object)0, (Object)0), (List<Integer>)ImmutableList.of((Object)0, (Object)0, (Object)0, (Object)0), groupedTopNBuilder.getEstimatedSizeInBytes());
    }

    @Test(dataProvider="produceRowNumbers")
    public void testSingleGroupTopN(boolean produceRowNumbers) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(2L, 0.2).row(3L, 0.9).row(3L, 0.1).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(4L, 0.6).row(2L, 0.8).row(2L, 0.7).pageBreak().row(2L, 0.9).build();
        for (Page page : input) {
            page.compact();
        }
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 5, produceRowNumbers, (GroupByHash)new NoChannelGroupByHash());
        TestGroupedTopNBuilder.assertBuilderSize((GroupByHash)new NoChannelGroupByHash(), (List<Type>)types, (List<Integer>)ImmutableList.of(), (List<Integer>)ImmutableList.of(), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        TestGroupedTopNBuilder.assertBuilderSize((GroupByHash)new NoChannelGroupByHash(), (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4), (List<Integer>)ImmutableList.of((Object)4), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        TestGroupedTopNBuilder.assertBuilderSize((GroupByHash)new NoChannelGroupByHash(), (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4, (Object)1), (List<Integer>)ImmutableList.of((Object)5), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        TestGroupedTopNBuilder.assertBuilderSize((GroupByHash)new NoChannelGroupByHash(), (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4, (Object)1, (Object)1), (List<Integer>)ImmutableList.of((Object)5), groupedTopNBuilder.getEstimatedSizeInBytes());
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        TestGroupedTopNBuilder.assertBuilderSize((GroupByHash)new NoChannelGroupByHash(), (List<Type>)types, (List<Integer>)ImmutableList.of((Object)4, (Object)1, (Object)1), (List<Integer>)ImmutableList.of((Object)5), groupedTopNBuilder.getEstimatedSizeInBytes());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT}).row(3L, 0.1, 1).row(2L, 0.2, 2).row(1L, 0.3, 3).row(1L, 0.4, 4).row(1L, 0.5, 5).build().get(0);
        if (produceRowNumbers) {
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT), (Page)output.get(0), expected);
        } else {
            PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), new Page(new Block[]{expected.getBlock(0), expected.getBlock(1)}));
        }
        TestGroupedTopNBuilder.assertBuilderSize((GroupByHash)new NoChannelGroupByHash(), (List<Type>)types, (List<Integer>)ImmutableList.of((Object)0, (Object)0, (Object)0), (List<Integer>)ImmutableList.of((Object)0), groupedTopNBuilder.getEstimatedSizeInBytes());
    }

    @Test
    public void testYield() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        Page input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.3).row(1L, 0.2).row(1L, 0.9).row(1L, 0.1).build().get(0);
        input.compact();
        AtomicBoolean unblock = new AtomicBoolean();
        GroupByHash groupByHash = TestGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), unblock::get);
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 5, false, groupByHash);
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of(), (List<Integer>)ImmutableList.of(), groupedTopNBuilder.getEstimatedSizeInBytes());
        Work work = groupedTopNBuilder.processPage(input);
        Assert.assertFalse((boolean)work.process());
        Assert.assertFalse((boolean)work.process());
        unblock.set(true);
        Assert.assertTrue((boolean)work.process());
        ImmutableList output = ImmutableList.copyOf((Iterator)groupedTopNBuilder.buildResult());
        Assert.assertEquals((int)output.size(), (int)1);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.1).row(1L, 0.2).row(1L, 0.3).row(1L, 0.9).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)output.get(0), expected);
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (List<Integer>)ImmutableList.of((Object)0), (List<Integer>)ImmutableList.of(), groupedTopNBuilder.getEstimatedSizeInBytes());
    }

    @Test
    public void testAutoCompact() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        List<Page> input = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.8).row(2L, 0.7).row(3L, 0.9).row(3L, 0.2).row(3L, 0.2).row(3L, 0.2).row(3L, 0.2).pageBreak().row(3L, 0.8).pageBreak().row(2L, 0.6).row(3L, 0.1).pageBreak().row(1L, 0.7).pageBreak().row(1L, 0.6).build();
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), 1, false, TestGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), UpdateMemory.NOOP));
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(0)).process());
        Assert.assertEquals((int)groupedTopNBuilder.getBufferedPages().size(), (int)1);
        Page firstCompactPage = (Page)groupedTopNBuilder.getBufferedPages().get(0);
        Page expected = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.8).row(2L, 0.7).row(3L, 0.2).build().get(0);
        PageAssertions.assertPageEquals((List<? extends Type>)types, firstCompactPage, expected);
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(1)).process());
        Assert.assertEquals((int)groupedTopNBuilder.getBufferedPages().size(), (int)1);
        Assert.assertEquals((Object)firstCompactPage, groupedTopNBuilder.getBufferedPages().get(0));
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(2)).process());
        List bufferedPages = groupedTopNBuilder.getBufferedPages();
        Assert.assertEquals((int)bufferedPages.size(), (int)2);
        Assert.assertNotEquals((Object)firstCompactPage, bufferedPages.get(0));
        Assert.assertNotEquals((Object)firstCompactPage, bufferedPages.get(1));
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.8).pageBreak().row(2L, 0.6).row(3L, 0.1).build();
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)bufferedPages.get(0), expectedPages.get(0));
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)bufferedPages.get(1), expectedPages.get(1));
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(3)).process());
        bufferedPages = groupedTopNBuilder.getBufferedPages();
        Assert.assertEquals((int)bufferedPages.size(), (int)2);
        expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2L, 0.6).row(3L, 0.1).pageBreak().row(1L, 0.7).build();
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)bufferedPages.get(0), expectedPages.get(0));
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)bufferedPages.get(1), expectedPages.get(1));
        Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(4)).process());
        bufferedPages = groupedTopNBuilder.getBufferedPages();
        Assert.assertEquals((int)bufferedPages.size(), (int)2);
        expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, 0.6).pageBreak().row(2L, 0.6).row(3L, 0.1).build();
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)bufferedPages.get(0), expectedPages.get(0));
        PageAssertions.assertPageEquals((List<? extends Type>)types, (Page)bufferedPages.get(1), expectedPages.get(1));
    }

    @Test(dataProvider="pageRowCounts")
    public void testLargePagesMemoryTracking(int pageCount, int rowCount) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types);
        for (int i = 0; i < pageCount; ++i) {
            rowPagesBuilder.addSequencePage(rowCount, 0, rowCount * i);
        }
        List<Page> input = rowPagesBuilder.build();
        GroupByHash groupByHash = TestGroupedTopNBuilder.createGroupByHash((List<Type>)ImmutableList.of((Object)((Type)types.get(0))), (List<Integer>)ImmutableList.of((Object)0), UpdateMemory.NOOP);
        GroupedTopNBuilder groupedTopNBuilder = new GroupedTopNBuilder((List)types, (PageWithPositionComparator)new SimplePageWithPositionComparator((List)types, (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST)), pageCount * rowCount, false, groupByHash);
        for (int i = 0; i < pageCount; ++i) {
            Assert.assertTrue((boolean)groupedTopNBuilder.processPage(input.get(i)).process());
            TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, Collections.nCopies(i + 1, rowCount), Collections.nCopies(rowCount, i + 1), groupedTopNBuilder.getEstimatedSizeInBytes());
        }
        int outputPageCount = 0;
        int remainingRows = pageCount * rowCount;
        Iterator output = groupedTopNBuilder.buildResult();
        while (output.hasNext()) {
            TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, (remainingRows -= ((Page)output.next()).getPositionCount()) == 0 ? Collections.nCopies(pageCount, 0) : Collections.nCopies(pageCount, rowCount), (List<Integer>)new ImmutableList.Builder().addAll(Collections.nCopies((remainingRows + pageCount - 1) / pageCount, pageCount)).addAll(Collections.nCopies(rowCount - (remainingRows + pageCount - 1) / pageCount, 0)).build(), groupedTopNBuilder.getEstimatedSizeInBytes());
            ++outputPageCount;
        }
        Assert.assertEquals((int)remainingRows, (int)0);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(outputPageCount), (Comparable)Integer.valueOf(3));
        TestGroupedTopNBuilder.assertBuilderSize(groupByHash, (List<Type>)types, Collections.nCopies(pageCount, 0), Collections.nCopies(rowCount, 0), groupedTopNBuilder.getEstimatedSizeInBytes());
    }

    private static GroupByHash createGroupByHash(List<Type> partitionTypes, List<Integer> partitionChannels, UpdateMemory updateMemory) {
        return GroupByHash.createGroupByHash(partitionTypes, (int[])Ints.toArray(partitionChannels), Optional.empty(), (int)1, (boolean)false, (JoinCompiler)new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()), (UpdateMemory)updateMemory);
    }

    private static void assertBuilderSize(GroupByHash groupByHash, List<Type> types, List<Integer> pagePositions, List<Integer> rowCounts, long actualSizeInBytes) {
        ObjectBigArray pageReferences = new ObjectBigArray();
        pageReferences.ensureCapacity((long)pagePositions.size());
        long pageReferencesSizeInBytes = pageReferences.sizeOf();
        ObjectBigArray groupedRows = new ObjectBigArray();
        groupedRows.ensureCapacity((long)rowCounts.size());
        long groupedRowsSizeInBytes = groupedRows.sizeOf();
        int emptySlots = 4;
        long emptyPageReferenceSlotsSizeInBytes = INT_FIFO_QUEUE_SIZE + SizeOf.sizeOf((int[])new int[emptySlots]);
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(types);
        for (int pagePosition : pagePositions) {
            if (pagePosition <= 0) continue;
            rowPagesBuilder.addSequencePage(pagePosition, new int[types.size()]);
        }
        long referencedPagesSizeInBytes = 0L;
        for (Page page : rowPagesBuilder.build()) {
            referencedPagesSizeInBytes += PAGE_REFERENCE_INSTANCE_SIZE + page.getRetainedSizeInBytes() + SizeOf.sizeOf((Object[])new Object[page.getPositionCount()]);
        }
        long rowHeapsSizeInBytes = 0L;
        for (int count : rowCounts) {
            if (count <= 0) continue;
            rowHeapsSizeInBytes += new TestRowHeap(count).getEstimatedSizeInBytes();
        }
        long expectedSizeInBytes = INSTANCE_SIZE + groupByHash.getEstimatedSize() + referencedPagesSizeInBytes + rowHeapsSizeInBytes + pageReferencesSizeInBytes + groupedRowsSizeInBytes + emptyPageReferenceSlotsSizeInBytes;
        Assert.assertEquals((long)actualSizeInBytes, (long)expectedSizeInBytes);
    }

    private static class TestPageReference {
        private Object page;
        private Object reference;
        private int usedPositionCount;

        private TestPageReference() {
        }
    }

    private static class TestRowHeap
    extends ObjectHeapPriorityQueue<Object> {
        private static final long INSTANCE_SIZE = ClassLayout.parseClass(TestRowHeap.class).instanceSize();
        private static final long ROW_ENTRY_SIZE = 8L + OBJECT_OVERHEAD;

        private TestRowHeap(int count) {
            super((left, right) -> 0);
            for (int i = 0; i < count; ++i) {
                this.enqueue(new Object());
            }
        }

        private long getEstimatedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.heap) + (long)this.size() * ROW_ENTRY_SIZE;
        }
    }
}

