/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.prestosql.RowPagesBuilder;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.MergeHashSort;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorAssertion;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMergeHashSort {
    @Test
    public void testBinaryMergeIteratorOverEmptyPage() {
        Page emptyPage = new Page(0, new Block[]{BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});
        WorkProcessor mergedPage = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext()).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)emptyPage).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        WorkProcessorAssertion.assertFinishes(mergedPage);
    }

    @Test
    public void testBinaryMergeIteratorOverEmptyPageAndNonEmptyPage() {
        Page emptyPage = new Page(0, new Block[]{BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});
        Page page = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0);
        WorkProcessor mergedPage = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext()).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)emptyPage, (Object)page).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        Assert.assertTrue((boolean)mergedPage.process());
        Page actualPage = (Page)mergedPage.getResult();
        Assert.assertEquals((int)actualPage.getPositionCount(), (int)1);
        Assert.assertEquals((int)actualPage.getChannelCount(), (int)1);
        Assert.assertEquals((long)actualPage.getBlock(0).getLong(0, 0), (long)42L);
        WorkProcessorAssertion.assertFinishes(mergedPage);
    }

    @Test
    public void testBinaryMergeIteratorOverPageWith() {
        Page emptyPage = new Page(0, new Block[]{BigintType.BIGINT.createFixedSizeBlockBuilder(0).build()});
        Page page = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0);
        WorkProcessor mergedPage = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext()).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)emptyPage, (Object)page).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        Assert.assertTrue((boolean)mergedPage.process());
        Page actualPage = (Page)mergedPage.getResult();
        Assert.assertEquals((int)actualPage.getPositionCount(), (int)1);
        Assert.assertEquals((int)actualPage.getChannelCount(), (int)1);
        Assert.assertEquals((long)actualPage.getBlock(0).getLong(0, 0), (long)42L);
        WorkProcessorAssertion.assertFinishes(mergedPage);
    }

    @Test
    public void testBinaryMergeIteratorOverPageWithDifferentHashes() {
        Page page = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).row(42).row(52).row(60).build().get(0);
        WorkProcessor mergedPages = new MergeHashSort(AggregatedMemoryContext.newSimpleAggregatedMemoryContext()).merge((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableList.of((Object)page).iterator()).stream().map(WorkProcessor::fromIterator).collect(ImmutableList.toImmutableList()), new DriverYieldSignal());
        Assert.assertTrue((boolean)mergedPages.process());
        Page resultPage = (Page)mergedPages.getResult();
        Assert.assertEquals((int)resultPage.getPositionCount(), (int)4);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(0, 0), (long)42L);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(1, 0), (long)42L);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(2, 0), (long)52L);
        Assert.assertEquals((long)resultPage.getBlock(0).getLong(3, 0), (long)60L);
        WorkProcessorAssertion.assertFinishes(mergedPages);
    }
}

