/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockAssertions;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.buffer.BufferState;
import io.prestosql.execution.buffer.OutputBuffer;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.execution.buffer.PartitionedOutputBuffer;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.memory.context.SimpleLocalMemoryContext;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.HashGenerator;
import io.prestosql.operator.InterpretedHashGenerator;
import io.prestosql.operator.OperatorContext;
import io.prestosql.operator.PartitionFunction;
import io.prestosql.operator.PartitionedOutputOperator;
import io.prestosql.operator.exchange.LocalPartitionGenerator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPartitionedOutputOperator {
    private static final DataSize MAX_MEMORY = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize PARTITION_MAX_MEMORY = DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int PAGE_COUNT = 10;
    private static final int POSITIONS_PER_PAGE = 1000;
    private static final int PARTITION_COUNT = 512;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final List<Type> REPLICATION_TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private static final Block NULL_BLOCK = new RunLengthEncodedBlock(BigintType.BIGINT.createBlockBuilder(null, 1).appendNull().build(), 1000);
    private static final Block TESTING_BLOCK = BlockAssertions.createLongSequenceBlock(0, 1000);
    private static final Block TESTING_DICTIONARY_BLOCK = BlockAssertions.createLongDictionaryBlock(0, 1000);
    private static final Block TESTING_RLE_BLOCK = BlockAssertions.createRLEBlock(new Random(0L).nextLong(), 1000);
    private static final Page TESTING_PAGE = new Page(new Block[]{TESTING_BLOCK});
    private static final Page TESTING_PAGE_WITH_NULL_BLOCK = new Page(1000, new Block[]{NULL_BLOCK, TESTING_BLOCK});
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-EXECUTOR-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"test-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test
    public void testOutputForSimplePage() {
        PartitionedOutputOperator partitionedOutputOperator = this.createPartitionedOutputOperator(false);
        for (int i = 0; i < 10; ++i) {
            partitionedOutputOperator.addInput(TESTING_PAGE);
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(10L * TESTING_PAGE.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(10 * TESTING_PAGE.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithDictionary() {
        PartitionedOutputOperator partitionedOutputOperator = this.createPartitionedOutputOperator(false);
        for (int i = 0; i < 10; ++i) {
            partitionedOutputOperator.addInput(new Page(new Block[]{TESTING_DICTIONARY_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(10L * TESTING_PAGE.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(10 * TESTING_PAGE.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithRunLength() {
        PartitionedOutputOperator partitionedOutputOperator = this.createPartitionedOutputOperator(false);
        for (int i = 0; i < 10; ++i) {
            partitionedOutputOperator.addInput(new Page(new Block[]{TESTING_RLE_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(10L * TESTING_PAGE.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(10 * TESTING_PAGE.getPositionCount()));
    }

    @Test
    public void testOutputForSimplePageAndReplication() {
        PartitionedOutputOperator partitionedOutputOperator = this.createPartitionedOutputOperator(true);
        for (int i = 0; i < 10; ++i) {
            partitionedOutputOperator.addInput(new Page(1000, new Block[]{NULL_BLOCK, TESTING_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(5120L * TESTING_PAGE_WITH_NULL_BLOCK.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(5120 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithDictionaryAndReplication() {
        PartitionedOutputOperator partitionedOutputOperator = this.createPartitionedOutputOperator(true);
        for (int i = 0; i < 10; ++i) {
            partitionedOutputOperator.addInput(new Page(1000, new Block[]{NULL_BLOCK, TESTING_DICTIONARY_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(5120L * TESTING_PAGE_WITH_NULL_BLOCK.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(5120 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount()));
    }

    @Test
    public void testOutputForPageWithRunLengthAndReplication() {
        PartitionedOutputOperator partitionedOutputOperator = this.createPartitionedOutputOperator(true);
        for (int i = 0; i < 10; ++i) {
            partitionedOutputOperator.addInput(new Page(1000, new Block[]{NULL_BLOCK, TESTING_RLE_BLOCK}));
        }
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)(5120L * TESTING_PAGE_WITH_NULL_BLOCK.getSizeInBytes()));
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)(5120 * TESTING_PAGE_WITH_NULL_BLOCK.getPositionCount()));
    }

    private PartitionedOutputOperator createPartitionedOutputOperator(boolean shouldReplicate) {
        LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new InterpretedHashGenerator((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}), 512);
        PagesSerdeFactory serdeFactory = new PagesSerdeFactory(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), false);
        DriverContext driverContext = TestingTaskContext.builder((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(MAX_MEMORY).build().addPipelineContext(0, true, true, false).addDriverContext();
        OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
        for (int partition = 0; partition < 512; ++partition) {
            buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
        }
        PartitionedOutputBuffer buffer = new PartitionedOutputBuffer("task-instance-id", new StateMachine("bufferState", (Executor)this.scheduledExecutor, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers.withNoMoreBufferIds(), DataSize.ofBytes((long)Long.MAX_VALUE), () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)this.scheduledExecutor);
        if (shouldReplicate) {
            PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty()), true, OptionalInt.of(0), (OutputBuffer)buffer, PARTITION_MAX_MEMORY);
            return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), REPLICATION_TYPES, Function.identity(), serdeFactory).createOperator(driverContext);
        }
        PartitionedOutputOperator.PartitionedOutputFactory operatorFactory = new PartitionedOutputOperator.PartitionedOutputFactory((PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty(), Optional.empty()), false, OptionalInt.empty(), (OutputBuffer)buffer, PARTITION_MAX_MEMORY);
        return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), TYPES, Function.identity(), serdeFactory).createOperator(driverContext);
    }
}

