/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.AggregationOperator;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.TableFinishInfo;
import io.prestosql.operator.TableFinishOperator;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.StatisticAggregationsDescriptor;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.TestingTaskContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTableFinishOperator {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction LONG_MAX = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test
    public void testStatisticsAggregation() throws Exception {
        TestTableFinisher tableFinisher = new TestTableFinisher();
        ColumnStatisticMetadata statisticMetadata = new ColumnStatisticMetadata("column", ColumnStatisticType.MAX_VALUE);
        StatisticAggregationsDescriptor descriptor = new StatisticAggregationsDescriptor((Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of((Object)statisticMetadata, (Object)0));
        Session session = TestingSession.testSessionBuilder().setSystemProperty("statistics_cpu_timer_enabled", "true").build();
        TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(0, new PlanNodeId("node"), (TableFinishOperator.TableFinisher)tableFinisher, (OperatorFactory)new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)LONG_MAX.bind((List)ImmutableList.of((Object)2), Optional.empty())), true), descriptor, session);
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.scheduledExecutor, (ScheduledExecutorService)this.scheduledExecutor, (Session)session).addPipelineContext(0, true, true, false).addDriverContext();
        TableFinishOperator operator = (TableFinishOperator)operatorFactory.createOperator(driverContext);
        ImmutableList inputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)BigintType.BIGINT);
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(4, null, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(5, null, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, new byte[]{1}, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, new byte[]{2}, null).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, 6).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder((Iterable<Type>)inputTypes).row(null, null, 7).build().get(0));
        Assertions.assertThat((long)driverContext.getSystemMemoryUsage()).isGreaterThan(0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.finish();
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertNull((Object)operator.getOutput());
        ImmutableList outputTypes = ImmutableList.of((Object)BigintType.BIGINT);
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(9).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertTrue((boolean)operator.isFinished());
        operator.close();
        Assert.assertEquals(tableFinisher.getFragments(), (Collection)ImmutableList.of((Object)Slices.wrappedBuffer((byte[])new byte[]{1}), (Object)Slices.wrappedBuffer((byte[])new byte[]{2})));
        Assert.assertEquals((int)tableFinisher.getComputedStatistics().size(), (int)1);
        Assert.assertEquals((int)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().size(), (int)1);
        Block expectedStatisticsBlock = new LongArrayBlockBuilder(null, 1).writeLong(7L).closeEntry().build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, (Block)((ComputedStatistics)Iterables.getOnlyElement(tableFinisher.getComputedStatistics())).getColumnStatistics().get(statisticMetadata), expectedStatisticsBlock);
        TableFinishInfo tableFinishInfo = operator.getInfo();
        Assertions.assertThat((double)tableFinishInfo.getStatisticsWallTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assertions.assertThat((double)tableFinishInfo.getStatisticsCpuTime().getValue(TimeUnit.NANOSECONDS)).isGreaterThan(0.0);
        Assert.assertEquals((long)driverContext.getSystemMemoryUsage(), (long)0L);
        Assert.assertEquals((long)driverContext.getMemoryUsage(), (long)0L);
    }

    private static class TestTableFinisher
    implements TableFinishOperator.TableFinisher {
        private boolean finished;
        private Collection<Slice> fragments;
        private Collection<ComputedStatistics> computedStatistics;

        private TestTableFinisher() {
        }

        public Optional<ConnectorOutputMetadata> finishTable(Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"already finished");
            this.finished = true;
            this.fragments = fragments;
            this.computedStatistics = computedStatistics;
            return Optional.empty();
        }

        public Collection<Slice> getFragments() {
            return this.fragments;
        }

        public Collection<ComputedStatistics> getComputedStatistics() {
            return this.computedStatistics;
        }
    }
}

