/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import io.prestosql.RowPagesBuilder;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.DriverContext;
import io.prestosql.operator.GroupByHashYieldAssertion;
import io.prestosql.operator.OperatorAssertion;
import io.prestosql.operator.OperatorFactory;
import io.prestosql.operator.TopNRowNumberOperator;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTopNRowNumberOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private JoinCompiler joinCompiler;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
        this.joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @DataProvider
    public Object[][] partial() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testPartitioned(boolean hashEnabled) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT, DoubleType.DOUBLE});
        List<Page> input = rowPagesBuilder.row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.91).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).pageBreak().row(2L, 0.9).build();
        TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, false, Optional.empty(), 10, this.joinCompiler);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.3, 1L, 1L}).row(new Object[]{0.4, 1L, 2L}).row(new Object[]{0.5, 1L, 3L}).row(new Object[]{0.2, 2L, 1L}).row(new Object[]{0.7, 2L, 2L}).row(new Object[]{0.8, 2L, 3L}).row(new Object[]{0.1, 3L, 1L}).row(new Object[]{0.91, 3L, 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test(dataProvider="partial")
    public void testUnPartitioned(boolean partial) {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.3).row(2L, 0.2).row(3L, 0.1).row(3L, 0.91).pageBreak().row(1L, 0.4).pageBreak().row(1L, 0.5).row(1L, 0.6).row(2L, 0.7).row(2L, 0.8).pageBreak().row(2L, 0.9).build();
        TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[0]), (List)ImmutableList.of(), Ints.asList((int[])new int[]{1}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, partial, Optional.empty(), 10, this.joinCompiler);
        MaterializedResult expected = partial ? MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT}).row(new Object[]{0.1, 3L}).row(new Object[]{0.2, 2L}).row(new Object[]{0.3, 1L}).build() : MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{0.1, 3L, 1L}).row(new Object[]{0.2, 2L, 2L}).row(new Object[]{0.3, 1L, 3L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testMemoryReservationYield() {
        BigintType type = BigintType.BIGINT;
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys((Type)type, 1000, 500);
        TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)type), Ints.asList((int[])new int[]{0}), (List)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 3, false, Optional.empty(), 10, this.joinCompiler);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, (Type)type, (OperatorFactory)operatorFactory, operator -> ((TopNRowNumberOperator)operator).getCapacity(), 1000000L);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(3));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x500000L));
        int count = 0;
        for (Page page : result.getOutput()) {
            Assert.assertEquals((int)page.getChannelCount(), (int)2);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assert.assertEquals((int)page.getBlock(1).getByte(i, 0), (int)1);
                ++count;
            }
        }
        Assert.assertEquals((int)count, (int)500000);
    }
}

