/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.operator.WorkProcessor;
import io.prestosql.operator.WorkProcessorUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.testng.Assert;

public final class WorkProcessorAssertion {
    private WorkProcessorAssertion() {
    }

    public static <T> void assertBlocks(WorkProcessor<T> processor) {
        Assert.assertFalse((boolean)processor.process());
        Assert.assertTrue((boolean)processor.isBlocked());
        Assert.assertFalse((boolean)processor.isFinished());
        Assert.assertFalse((boolean)processor.process());
    }

    public static <T, V> void assertUnblocks(WorkProcessor<T> processor, SettableFuture<V> future) {
        future.set(null);
        Assert.assertFalse((boolean)processor.isBlocked());
    }

    public static <T> void assertYields(WorkProcessor<T> processor) {
        Assert.assertFalse((boolean)processor.process());
        Assert.assertFalse((boolean)processor.isBlocked());
        Assert.assertFalse((boolean)processor.isFinished());
    }

    public static <T> void assertResult(WorkProcessor<T> processor, T result) {
        WorkProcessorAssertion.validateResult(processor, actualResult -> Assert.assertEquals((Object)processor.getResult(), (Object)result));
    }

    public static <T> void validateResult(WorkProcessor<T> processor, Consumer<T> validator) {
        Assert.assertTrue((boolean)processor.process());
        Assert.assertFalse((boolean)processor.isBlocked());
        Assert.assertFalse((boolean)processor.isFinished());
        validator.accept(processor.getResult());
    }

    public static <T> void assertFinishes(WorkProcessor<T> processor) {
        Assert.assertTrue((boolean)processor.process());
        Assert.assertFalse((boolean)processor.isBlocked());
        Assert.assertTrue((boolean)processor.isFinished());
        Assert.assertTrue((boolean)processor.process());
    }

    public static <T, R> WorkProcessor.Transformation<T, R> transformationFrom(List<Transform<T, R>> transformations) {
        return WorkProcessorAssertion.transformationFrom(transformations, Objects::equals);
    }

    public static <T, R> WorkProcessor.Transformation<T, R> transformationFrom(List<Transform<T, R>> transformations, BiPredicate<T, T> equalsPredicate) {
        Iterator iterator = transformations.iterator();
        return element -> {
            Assert.assertTrue((boolean)iterator.hasNext());
            return ((Transform)iterator.next()).transform(Optional.ofNullable(element), (left, right) -> left.isPresent() == right.isPresent() && (left.isEmpty() || equalsPredicate.test(left.get(), right.get())));
        };
    }

    public static <T> WorkProcessor<T> processorFrom(List<WorkProcessor.ProcessState<T>> states) {
        Iterator iterator = states.iterator();
        return WorkProcessorUtils.create(() -> {
            Assert.assertTrue((boolean)iterator.hasNext());
            return (WorkProcessor.ProcessState)iterator.next();
        });
    }

    public static class Transform<T, R> {
        private final Optional<T> from;
        private final WorkProcessor.TransformationState<R> to;

        public static <T, R> Transform<T, R> of(Optional<T> from, WorkProcessor.TransformationState<R> to) {
            return new Transform<T, R>(from, to);
        }

        private Transform(Optional<T> from, WorkProcessor.TransformationState<R> to) {
            this.from = Objects.requireNonNull(from);
            this.to = Objects.requireNonNull(to);
        }

        private WorkProcessor.TransformationState<R> transform(Optional<T> from, BiPredicate<Optional<T>, Optional<T>> equalsPredicate) {
            Assert.assertTrue((boolean)equalsPredicate.test(from, this.from), (String)String.format("Expected %s to be equal to %s", from, this.from));
            return this.to;
        }
    }
}

