/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import io.prestosql.operator.aggregation.AbstractTestApproximateCountDistinct;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestApproximateCountDistinctBoolean
extends AbstractTestApproximateCountDistinct {
    @Override
    protected Type getValueType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    protected Object randomValue() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @DataProvider(name="inputSequences")
    public Object[][] inputSequences() {
        return new Object[][]{{true}, {false}, {true, false}, {true, true, true}, {false, false, false}, {true, false, true, false}};
    }

    @Test(dataProvider="inputSequences")
    public void testNonEmptyInputs(boolean ... inputSequence) {
        List values = Booleans.asList((boolean[])inputSequence);
        this.assertCount(values, 0.0, this.distinctCount(values));
    }

    @Test
    public void testNoInput() {
        this.assertCount((List<?>)ImmutableList.of(), 0.0, 0L);
    }

    private long distinctCount(List<Boolean> inputSequence) {
        return ImmutableSet.copyOf(inputSequence).size();
    }

    @Override
    protected int getUniqueValuesCount() {
        return 2;
    }
}

