/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArbitraryAggregation {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testAllRegistered() {
        for (Type valueType : metadata.getTypes()) {
            Assert.assertNotNull((Object)metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}))));
        }
    }

    @Test
    public void testNullBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[]{null}));
    }

    @Test
    public void testValidBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)true, BlockAssertions.createBooleansBlock(true, true));
    }

    @Test
    public void testNullLong() {
        InternalAggregationFunction longAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(longAgg, null, BlockAssertions.createLongsBlock(null, null));
    }

    @Test
    public void testValidLong() {
        InternalAggregationFunction longAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(longAgg, (Object)1L, BlockAssertions.createLongsBlock(1L, null));
    }

    @Test
    public void testNullDouble() {
        InternalAggregationFunction doubleAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(doubleAgg, null, BlockAssertions.createDoublesBlock(null, null));
    }

    @Test
    public void testValidDouble() {
        InternalAggregationFunction doubleAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)2.0, BlockAssertions.createDoublesBlock(null, 2.0));
    }

    @Test
    public void testNullString() {
        InternalAggregationFunction stringAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(stringAgg, null, BlockAssertions.createStringsBlock(null, null));
    }

    @Test
    public void testValidString() {
        InternalAggregationFunction stringAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(stringAgg, (Object)"a", BlockAssertions.createStringsBlock("a", "a"));
    }

    @Test
    public void testNullArray() {
        InternalAggregationFunction arrayAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(arrayAgg, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null, null)));
    }

    @Test
    public void testValidArray() {
        InternalAggregationFunction arrayAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)ImmutableList.of((Object)23L, (Object)45L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L))));
    }

    @Test
    public void testValidInt() {
        InternalAggregationFunction arrayAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})));
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)3, BlockAssertions.createIntsBlock(3, 3, null));
    }
}

