/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import java.util.List;

public class TestBooleanOrAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, i % 2 != 0);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Boolean getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return length > 1 || start % 2 == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    protected String getFunctionName() {
        return "bool_or";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BooleanType.BOOLEAN);
    }
}

