/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import java.util.List;

public class TestDoubleMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return (double)(start + length - 1);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DoubleType.DOUBLE);
    }
}

