/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestDecimalAverageAggregation;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import java.math.BigDecimal;
import java.util.List;

public class TestLongDecimalAverageAggregation
extends AbstractTestDecimalAverageAggregation {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)19);

    @Override
    protected DecimalType getDecimalType() {
        return LONG_DECIMAL_TYPE;
    }

    @Override
    protected void writeDecimalToBlock(BigDecimal decimal, BlockBuilder blockBuilder) {
        LONG_DECIMAL_TYPE.writeSlice(blockBuilder, Decimals.encodeScaledValue((BigDecimal)decimal));
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)DecimalType.createDecimalType((int)19, (int)2));
    }
}

