/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import java.util.List;

public class TestLongMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return (long)start + (long)length - 1L;
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)BigintType.BIGINT);
    }
}

