/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.stats.cardinality.HyperLogLog;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.SqlVarbinary;
import io.prestosql.spi.type.Type;
import java.util.List;

public class TestMergeHyperLogLogAggregation
extends AbstractTestAggregationFunction {
    private static final int NUMBER_OF_BUCKETS = 16;

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = HyperLogLogType.HYPER_LOG_LOG.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            HyperLogLog hll = HyperLogLog.newInstance((int)16);
            hll.add((long)i);
            hll.makeDense();
            HyperLogLogType.HYPER_LOG_LOG.writeSlice(blockBuilder, hll.serialize());
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)HyperLogLogType.HYPER_LOG_LOG);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        HyperLogLog hll = HyperLogLog.newInstance((int)16);
        for (int i = start; i < start + length; ++i) {
            hll.add((long)i);
        }
        hll.makeDense();
        return new SqlVarbinary(hll.serialize().getBytes());
    }
}

