/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.VariableReferenceExpression;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.type.FunctionType;
import io.prestosql.util.StructuralTestUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkTransformValue {
    private static final int POSITIONS = 100000;
    private static final int NUM_TYPES = 3;

    @Benchmark
    @OperationsPerInvocation(value=300000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkTransformValue().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.BULK).include(".*" + BenchmarkTransformValue.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "DOUBLE", "VARCHAR"})
        private String type = "VARCHAR";
        private String name = "transform_values";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            Number compareValue;
            BigintType elementType;
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    compareValue = 0L;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    compareValue = 0.0;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    compareValue = Slices.utf8Slice((String)"0");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            MapType mapType = StructuralTestUtil.mapType((Type)elementType, (Type)elementType);
            MapType returnType = StructuralTestUtil.mapType((Type)elementType, (Type)BooleanType.BOOLEAN);
            ResolvedFunction resolvedFunction = metadata.resolveFunction(QualifiedName.of((String)this.name), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType, new FunctionType((List)ImmutableList.of((Object)elementType), (Type)elementType)}));
            ResolvedFunction greaterThan = metadata.resolveOperator(OperatorType.GREATER_THAN, (List)ImmutableList.of((Object)elementType, (Object)elementType));
            projectionsBuilder.add((Object)Expressions.call((ResolvedFunction)resolvedFunction, (Type)returnType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)mapType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)elementType, (Object)elementType), (List)ImmutableList.of((Object)"x", (Object)"y"), (RowExpression)Expressions.call((ResolvedFunction)greaterThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new VariableReferenceExpression("y", (Type)elementType), (Object)Expressions.constant((Object)compareValue, (Type)elementType)))))));
            Block block = BenchmarkData.createChannel(100000, mapType, (Type)elementType);
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{block});
        }

        private static Block createChannel(int positionCount, MapType mapType, Type elementType) {
            BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
            BlockBuilder singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            for (int position = 0; position < positionCount; ++position) {
                Number value;
                Integer key;
                if (elementType.equals(BigintType.BIGINT)) {
                    key = position;
                    value = ThreadLocalRandom.current().nextLong();
                } else if (elementType.equals(DoubleType.DOUBLE)) {
                    key = position;
                    value = ThreadLocalRandom.current().nextDouble();
                } else if (elementType.equals(VarcharType.VARCHAR)) {
                    key = Slices.utf8Slice((String)Integer.toString(position));
                    value = Slices.utf8Slice((String)Double.toString(ThreadLocalRandom.current().nextDouble()));
                } else {
                    throw new UnsupportedOperationException();
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)singleMapBlockWriter, (Object)key);
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)singleMapBlockWriter, (Object)value);
            }
            mapBlockBuilder.closeEntry();
            return mapBlockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

