/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.Session;
import io.prestosql.operator.scalar.FunctionAssertions;
import io.prestosql.operator.scalar.TestDateTimeFunctionsBase;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.time.Instant;
import org.joda.time.DateTime;
import org.testng.annotations.Test;

public class TestDateTimeFunctionsLegacy
extends TestDateTimeFunctionsBase {
    public TestDateTimeFunctionsLegacy() {
        super(true);
    }

    @Test
    public void testFormatDateCanImplicitlyAddTimeZoneToTimestampLiteral() {
        this.assertFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321', 'YYYY/MM/dd HH:mm ZZZZ')", (Type)VarcharType.VARCHAR, "2001/08/22 03:04 " + DATE_TIME_ZONE.getID());
    }

    @Test
    public void testLocalTimestamp() {
        Session localSession = Session.builder((Session)this.session).setStart(Instant.ofEpochMilli(new DateTime(2017, 3, 1, 14, 30, 0, 0, DATE_TIME_ZONE).getMillis())).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("LOCALTIMESTAMP", (Type)TimestampType.TIMESTAMP, "2017-03-01 14:30:00.000");
        }
    }

    @Test
    public void testCurrentTimestamp() {
        Session localSession = Session.builder((Session)this.session).setStart(Instant.ofEpochMilli(new DateTime(2017, 3, 1, 14, 30, 0, 0, DATE_TIME_ZONE).getMillis())).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("CURRENT_TIMESTAMP", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2017-03-01 14:30:00.000 " + DATE_TIME_ZONE.getID());
            localAssertion.assertFunctionString("NOW()", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2017-03-01 14:30:00.000 " + DATE_TIME_ZONE.getID());
        }
    }
}

