/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.UnknownType;
import io.prestosql.util.StructuralTestUtil;
import java.util.HashMap;
import org.testng.annotations.Test;

public class TestMapTransformValuesFunction
extends AbstractTestFunctions {
    @Test
    public void testRetainedSizeBounded() {
        this.assertCachedInstanceHasBoundedRetainedSize("transform_values(map(ARRAY [25, 26, 27], ARRAY [25, 26, 27]), (k, v) -> k + v)");
    }

    @Test
    public void testEmpty() {
        this.assertFunction("transform_values(map(ARRAY[], ARRAY[]), (k, v) -> NULL)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_values(map(ARRAY[], ARRAY[]), (k, v) -> k)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_values(map(ARRAY[], ARRAY[]), (k, v) -> v)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN), ImmutableMap.of());
        this.assertFunction("transform_values(map(ARRAY[], ARRAY[]), (k, v) -> 0)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)IntegerType.INTEGER), ImmutableMap.of());
        this.assertFunction("transform_values(map(ARRAY[], ARRAY[]), (k, v) -> true)", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)BooleanType.BOOLEAN), ImmutableMap.of());
        this.assertFunction("transform_values(map(ARRAY[], ARRAY[]), (k, v) -> 'value')", (Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)VarcharType.createVarcharType((int)5)), ImmutableMap.of());
        this.assertFunction("transform_values(CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR)), (k, v) -> k + CAST(v as BIGINT))", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT), ImmutableMap.of());
        this.assertFunction("transform_values(CAST (map(ARRAY[], ARRAY[]) AS MAP(BIGINT,VARCHAR)), (k, v) -> CAST(k AS VARCHAR) || v)", (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR), ImmutableMap.of());
    }

    @Test
    public void testNullValue() {
        HashMap<Integer, Object> sequenceToNullMap = new HashMap<Integer, Object>();
        sequenceToNullMap.put(1, null);
        sequenceToNullMap.put(2, null);
        sequenceToNullMap.put(3, null);
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY ['a', 'b', 'c']), (k, v) -> NULL)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN), sequenceToNullMap);
        HashMap<Integer, String> mapWithNullValue = new HashMap<Integer, String>();
        mapWithNullValue.put(1, "a");
        mapWithNullValue.put(2, "b");
        mapWithNullValue.put(3, null);
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY ['a', 'b', NULL]), (k, v) -> v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), mapWithNullValue);
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY [10, 11, NULL]), (k, v) -> to_base(v, 16))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)64)), mapWithNullValue);
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY ['10', '11', 'Invalid']), (k, v) -> to_base(TRY_CAST(v as BIGINT), 16))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)64)), mapWithNullValue);
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY [0, 0, 0]), (k, v) -> element_at(map(ARRAY[1, 2], ARRAY['a', 'b']), k + v))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1)), mapWithNullValue);
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY ['a', 'b', NULL]), (k, v) -> IF(v IS NULL, k + 1.0E0, k + 0.5E0))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)1, (Object)1.5, (Object)2, (Object)2.5, (Object)3, (Object)4.0));
    }

    @Test
    public void testBasic() {
        this.assertFunction("transform_values(map(ARRAY [1, 2, 3, 4], ARRAY [10, 20, 30, 40]), (k, v) -> k + v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)1, (Object)11, (Object)2, (Object)22, (Object)3, (Object)33, (Object)4, (Object)44));
        this.assertFunction("transform_values(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, 2, 3, 4]), (k, v) -> v * v)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER), ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)4, (Object)"c", (Object)9, (Object)"d", (Object)16));
        this.assertFunction("transform_values(map(ARRAY ['a', 'b', 'c', 'd'], ARRAY [1, 2, 3, 4]), (k, v) -> k || CAST(v as VARCHAR))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"a", (Object)"a1", (Object)"b", (Object)"b2", (Object)"c", (Object)"c3", (Object)"d", (Object)"d4"));
        this.assertFunction("transform_values(map(ARRAY[1, 2, 3], ARRAY [1.0E0, 1.4E0, 1.7E0]), (k, v) -> map(ARRAY[1, 2, 3], ARRAY['one', 'two', 'three'])[k] || '_' || CAST(v AS VARCHAR))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1, (Object)"one_1.0", (Object)2, (Object)"two_1.4", (Object)3, (Object)"three_1.7"));
        this.assertFunction("transform_values(map(ARRAY[1, 2], ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2010-05-10 12:34:56.123456789']), (k, v) -> date_add('year', 1, v))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)TimestampType.createTimestampType((int)9)), ImmutableMap.of((Object)1, (Object)TestMapTransformValuesFunction.legacyTimestamp(9, "2021-05-10 12:34:56.123456789"), (Object)2, (Object)TestMapTransformValuesFunction.legacyTimestamp(9, "2011-05-10 12:34:56.123456789")));
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("transform_values(map(ARRAY [25, 26, 27], ARRAY [25, 26, 27]), (k, v) -> k + v)", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)25, (Object)50, (Object)26, (Object)52, (Object)27, (Object)54));
        this.assertFunction("transform_values(map(ARRAY [25, 26, 27], ARRAY [26.1E0, 31.2E0, 37.1E0]), (k, v) -> CAST(v - k AS BIGINT))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT), ImmutableMap.of((Object)25, (Object)1L, (Object)26, (Object)5L, (Object)27, (Object)10L));
        this.assertFunction("transform_values(map(ARRAY [25, 27], ARRAY [false, true]), (k, v) -> if(v, k + 1, k + 2))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), ImmutableMap.of((Object)25, (Object)27, (Object)27, (Object)28));
        this.assertFunction("transform_values(map(ARRAY [25, 26, 27], ARRAY ['abc', 'd', 'xy']), (k, v) -> k + length(v))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT), ImmutableMap.of((Object)25, (Object)28L, (Object)26, (Object)27L, (Object)27, (Object)29L));
        this.assertFunction("transform_values(map(ARRAY [25, 26, 27], ARRAY [ARRAY ['a'], ARRAY ['a', 'c'], ARRAY ['a', 'b', 'c']]), (k, v) -> k + cardinality(v))", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT), ImmutableMap.of((Object)25, (Object)26L, (Object)26, (Object)28L, (Object)27, (Object)30L));
        this.assertFunction("transform_values(map(ARRAY [25.5E0, 26.75E0, 27.875E0], ARRAY [25, 26, 27]), (k, v) -> k - v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)0.5, (Object)26.75, (Object)0.75, (Object)27.875, (Object)0.875));
        this.assertFunction("transform_values(map(ARRAY [25.5E0, 26.75E0, 27.875E0], ARRAY [25.0E0, 26.0E0, 27.0E0]), (k, v) -> k - v)", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)0.5, (Object)26.75, (Object)0.75, (Object)27.875, (Object)0.875));
        this.assertFunction("transform_values(map(ARRAY [25.5E0, 27.5E0], ARRAY [false, true]), (k, v) -> if(v, k + 0.1E0, k + 0.2E0))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)25.7, (Object)27.5, (Object)27.6));
        this.assertFunction("transform_values(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY ['a', 'def', 'xy']), (k, v) -> k + length(v))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)26.5, (Object)26.5, (Object)29.5, (Object)27.5, (Object)29.5));
        this.assertFunction("transform_values(map(ARRAY [25.5E0, 26.5E0, 27.5E0], ARRAY [ARRAY ['a'], ARRAY ['a', 'c'], ARRAY ['a', 'b', 'c']]), (k, v) -> k + cardinality(v))", (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE), ImmutableMap.of((Object)25.5, (Object)26.5, (Object)26.5, (Object)28.5, (Object)27.5, (Object)30.5));
        this.assertFunction("transform_values(map(ARRAY [true, false], ARRAY [25, 26]), (k, v) -> k AND v = 25)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)true, (Object)true, (Object)false, (Object)false));
        this.assertFunction("transform_values(map(ARRAY [false, true], ARRAY [25.5E0, 26.5E0]), (k, v) -> k OR v > 100)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)false, (Object)true, (Object)true));
        this.assertFunction("transform_values(map(ARRAY [true, false], ARRAY [false, null]), (k, v) -> NOT k OR v)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)true, (Object)true, (Object)false));
        this.assertFunction("transform_values(map(ARRAY [false, true], ARRAY ['abc', 'def']), (k, v) -> NOT k AND v = 'abc')", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)true, (Object)true, (Object)false));
        this.assertFunction("transform_values(map(ARRAY [true, false], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'b', 'c']]), (k, v) -> k OR cardinality(v) = 3)", (Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN), ImmutableMap.of((Object)false, (Object)true, (Object)true, (Object)true));
        this.assertFunction("transform_values(map(ARRAY ['s0', 's1', 's2'], ARRAY [25, 26, 27]), (k, v) -> k || ':' || CAST(v as VARCHAR))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"s0", (Object)"s0:25", (Object)"s1", (Object)"s1:26", (Object)"s2", (Object)"s2:27"));
        this.assertFunction("transform_values(map(ARRAY ['s0', 's1', 's2'], ARRAY [25.5E0, 26.5E0, 27.5E0]), (k, v) -> k || ':' || CAST(v as VARCHAR))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"s0", (Object)"s0:25.5", (Object)"s1", (Object)"s1:26.5", (Object)"s2", (Object)"s2:27.5"));
        this.assertFunction("transform_values(map(ARRAY ['s0', 's2'], ARRAY [false, true]), (k, v) -> if(v, k, CAST(v AS VARCHAR)))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"s0", (Object)"false", (Object)"s2", (Object)"s2"));
        this.assertFunction("transform_values(map(ARRAY ['s0', 's1', 's2'], ARRAY ['abc', 'def', 'xyz']), (k, v) -> k || ':' || v)", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"s0", (Object)"s0:abc", (Object)"s1", (Object)"s1:def", (Object)"s2", (Object)"s2:xyz"));
        this.assertFunction("transform_values(map(ARRAY ['s0', 's1', 's2'], ARRAY [ARRAY ['a', 'b'], ARRAY ['a', 'c'], ARRAY ['a', 'b', 'c']]), (k, v) -> k || ':' || array_max(v))", (Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)2), (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)"s0", (Object)"s0:b", (Object)"s1", (Object)"s1:c", (Object)"s2", (Object)"s2:c"));
        this.assertFunction("transform_values(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [25, 26]), (k, v) -> if(v % 2 = 0, reverse(k), k))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)4, (Object)3)));
        this.assertFunction("transform_values(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [25.5E0, 26.5E0]), (k, v) -> CAST(k AS ARRAY(DOUBLE)) || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)25.5), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)3.0, (Object)4.0, (Object)26.5)));
        this.assertFunction("transform_values(map(ARRAY [ARRAY [1, 2], ARRAY [3, 4]], ARRAY [false, true]), (k, v) -> if(v, reverse(k), k))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)4, (Object)3)));
        this.assertFunction("transform_values(map(ARRAY [ARRAY [1, 2], ARRAY []], ARRAY ['a', 'ff']), (k, v) -> k || from_base(v, 16))", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)BigintType.BIGINT)), ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)1L, (Object)2L, (Object)10L), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)255L)));
        this.assertFunction("transform_values(map(ARRAY [ARRAY [3, 4], ARRAY []], ARRAY [ARRAY ['a', 'b', 'c'], ARRAY ['a', 'c']]), (k, v) -> transform(k, x -> CAST(x AS VARCHAR)) || v)", (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)new ArrayType((Type)VarcharType.VARCHAR)), ImmutableMap.of((Object)ImmutableList.of((Object)3, (Object)4), (Object)ImmutableList.of((Object)"3", (Object)"4", (Object)"a", (Object)"b", (Object)"c"), (Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"a", (Object)"c")));
    }
}

