/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.SqlVarbinaryTestingUtil;
import io.prestosql.type.VarbinaryOperators;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVarbinaryFunctions
extends AbstractTestFunctions {
    private static final byte[] ALL_BYTES = new byte[256];

    @Test
    public void testBinaryLiteral() {
        this.assertFunction("X'58F7'", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
    }

    @Test
    public void testLength() {
        this.assertFunction("length(CAST('' AS VARBINARY))", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("length(CAST('a' AS VARBINARY))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("length(CAST('abc' AS VARBINARY))", (Type)BigintType.BIGINT, 3L);
    }

    @Test
    public void testConcat() {
        this.assertInvalidFunction("CONCAT(X'')", "There must be two or more concatenation arguments");
        this.assertFunction("CAST('foo' AS VARBINARY) || CAST ('bar' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobar"));
        this.assertFunction("CAST('foo' AS VARBINARY) || CAST ('bar' AS VARBINARY) || CAST ('baz' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbaz"));
        this.assertFunction("CAST(' foo ' AS VARBINARY) || CAST ('  bar  ' AS VARBINARY) || CAST ('   baz   ' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)" foo   bar     baz   "));
        this.assertFunction("CAST('foo' AS VARBINARY) || CAST ('bar' AS VARBINARY) || CAST ('bazbaz' AS VARBINARY)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbazbaz"));
        this.assertFunction("X'000102' || X'AAABAC' || X'FDFEFF'", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"000102AAABACFDFEFF"));
        this.assertFunction("X'CAFFEE' || X'F7' || X'DE58'", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"CAFFEEF7DE58"));
        this.assertFunction("X'58' || X'F7'", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("X'' || X'58' || X'F7'", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("X'58' || X'' || X'F7'", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("X'58' || X'F7' || X''", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("X'' || X'58' || X'' || X'F7' || X''", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("X'' || X'' || X'' || X'' || X'' || X''", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
        this.assertFunction("CONCAT(CAST('foo' AS VARBINARY), CAST ('bar' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobar"));
        this.assertFunction("CONCAT(CAST('foo' AS VARBINARY), CAST ('bar' AS VARBINARY), CAST ('baz' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbaz"));
        this.assertFunction("CONCAT(CAST('foo' AS VARBINARY), CAST ('bar' AS VARBINARY), CAST ('bazbaz' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"foobarbazbaz"));
        this.assertFunction("CONCAT(X'000102', X'AAABAC', X'FDFEFF')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"000102AAABACFDFEFF"));
        this.assertFunction("CONCAT(X'CAFFEE', X'F7', X'DE58')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"CAFFEEF7DE58"));
        this.assertFunction("CONCAT(X'58', X'F7')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("CONCAT(X'', X'58', X'F7')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("CONCAT(X'58', X'', X'F7')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("CONCAT(X'58', X'F7', X'')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("CONCAT(X'', X'58', X'', X'F7', X'')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"58F7"));
        this.assertFunction("CONCAT(X'', X'', X'', X'', X'', X'')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
    }

    @Test
    public void testToBase64() {
        this.assertFunction("to_base64(CAST('' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64(""));
        this.assertFunction("to_base64(CAST('a' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64("a"));
        this.assertFunction("to_base64(CAST('abc' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64("abc"));
        this.assertFunction("to_base64(CAST('hello world' AS VARBINARY))", (Type)VarcharType.VARCHAR, "aGVsbG8gd29ybGQ=");
    }

    @Test
    public void testFromBase64() {
        this.assertFunction("from_base64(to_base64(CAST('' AS VARBINARY)))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("from_base64(to_base64(CAST('a' AS VARBINARY)))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        this.assertFunction("from_base64(to_base64(CAST('abc' AS VARBINARY)))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        this.assertFunction("from_base64(CAST(to_base64(CAST('' AS VARBINARY)) AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("from_base64(CAST(to_base64(CAST('a' AS VARBINARY)) AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        this.assertFunction("from_base64(CAST(to_base64(CAST('abc' AS VARBINARY)) AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        this.assertFunction(String.format("to_base64(from_base64('%s'))", TestVarbinaryFunctions.encodeBase64(ALL_BYTES)), (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64(ALL_BYTES));
    }

    @Test
    public void testToBase64Url() {
        this.assertFunction("to_base64url(CAST('' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64Url(""));
        this.assertFunction("to_base64url(CAST('a' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64Url("a"));
        this.assertFunction("to_base64url(CAST('abc' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64Url("abc"));
        this.assertFunction("to_base64url(CAST('hello world' AS VARBINARY))", (Type)VarcharType.VARCHAR, "aGVsbG8gd29ybGQ=");
    }

    @Test
    public void testFromBase64Url() {
        this.assertFunction("from_base64url(to_base64url(CAST('' AS VARBINARY)))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("from_base64url(to_base64url(CAST('a' AS VARBINARY)))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        this.assertFunction("from_base64url(to_base64url(CAST('abc' AS VARBINARY)))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        this.assertFunction("from_base64url(CAST(to_base64url(CAST('' AS VARBINARY)) AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("from_base64url(CAST(to_base64url(CAST('a' AS VARBINARY)) AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        this.assertFunction("from_base64url(CAST(to_base64url(CAST('abc' AS VARBINARY)) AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"abc"));
        this.assertFunction(String.format("to_base64url(from_base64url('%s'))", TestVarbinaryFunctions.encodeBase64Url(ALL_BYTES)), (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeBase64Url(ALL_BYTES));
    }

    @Test
    public void testToHex() {
        this.assertFunction("to_hex(CAST('' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeHex(""));
        this.assertFunction("to_hex(CAST('a' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeHex("a"));
        this.assertFunction("to_hex(CAST('abc' AS VARBINARY))", (Type)VarcharType.VARCHAR, TestVarbinaryFunctions.encodeHex("abc"));
        this.assertFunction("to_hex(CAST('hello world' AS VARBINARY))", (Type)VarcharType.VARCHAR, "68656C6C6F20776F726C64");
    }

    @Test
    public void testFromHex() {
        this.assertFunction("from_hex('')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("from_hex('61')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        this.assertFunction("from_hex('617a6f')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"azo"));
        this.assertFunction("from_hex('617A6F')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"azo"));
        this.assertFunction("from_hex(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("from_hex(CAST('61' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"a"));
        this.assertFunction("from_hex(CAST('617a6F' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"azo"));
        this.assertFunction(String.format("to_hex(from_hex('%s'))", BaseEncoding.base16().encode(ALL_BYTES)), (Type)VarcharType.VARCHAR, BaseEncoding.base16().encode(ALL_BYTES));
        this.assertInvalidFunction("from_hex('f/')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_hex('f:')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_hex('f@')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_hex('fG')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_hex('f`')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_hex('fg')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_hex('fff')", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testToBigEndian64() {
        this.assertFunction("to_big_endian_64(0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000000"));
        this.assertFunction("to_big_endian_64(1)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000001"));
        this.assertFunction("to_big_endian_64(9223372036854775807)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FFFFFFFFFFFFFFF"));
        this.assertFunction("to_big_endian_64(-9223372036854775807)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"8000000000000001"));
    }

    @Test
    public void testFromBigEndian64() {
        this.assertFunction("from_big_endian_64(from_hex('0000000000000000'))", (Type)BigintType.BIGINT, 0L);
        this.assertFunction("from_big_endian_64(from_hex('0000000000000001'))", (Type)BigintType.BIGINT, 1L);
        this.assertFunction("from_big_endian_64(from_hex('7FFFFFFFFFFFFFFF'))", (Type)BigintType.BIGINT, Long.MAX_VALUE);
        this.assertFunction("from_big_endian_64(from_hex('8000000000000001'))", (Type)BigintType.BIGINT, -9223372036854775807L);
        this.assertInvalidFunction("from_big_endian_64(from_hex(''))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_big_endian_64(from_hex('1111'))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_big_endian_64(from_hex('000000000000000011'))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testToBigEndian32() {
        this.assertFunction("to_big_endian_32(0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000"));
        this.assertFunction("to_big_endian_32(1)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000001"));
        this.assertFunction("to_big_endian_32(2147483647)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FFFFFFF"));
        this.assertFunction("to_big_endian_32(-2147483647)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"80000001"));
    }

    @Test
    public void testFromBigEndian32() {
        this.assertFunction("from_big_endian_32(from_hex('00000000'))", (Type)IntegerType.INTEGER, 0);
        this.assertFunction("from_big_endian_32(from_hex('00000001'))", (Type)IntegerType.INTEGER, 1);
        this.assertFunction("from_big_endian_32(from_hex('7FFFFFFF'))", (Type)IntegerType.INTEGER, Integer.MAX_VALUE);
        this.assertFunction("from_big_endian_32(from_hex('80000001'))", (Type)IntegerType.INTEGER, -2147483647);
        this.assertInvalidFunction("from_big_endian_32(from_hex(''))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_big_endian_32(from_hex('1111'))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
        this.assertInvalidFunction("from_big_endian_32(from_hex('000000000000000011'))", (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT);
    }

    @Test
    public void testToIEEE754Binary32() {
        this.assertFunction("to_ieee754_32(CAST(0.0 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000000"));
        this.assertFunction("to_ieee754_32(CAST(1.0 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"3F800000"));
        this.assertFunction("to_ieee754_32(CAST(3.14 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"4048F5C3"));
        this.assertFunction("to_ieee754_32(CAST(NAN() AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FC00000"));
        this.assertFunction("to_ieee754_32(CAST(INFINITY() AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7F800000"));
        this.assertFunction("to_ieee754_32(CAST(-INFINITY() AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FF800000"));
        this.assertFunction("to_ieee754_32(CAST(3.4028235E38 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7F7FFFFF"));
        this.assertFunction("to_ieee754_32(CAST(-3.4028235E38 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FF7FFFFF"));
        this.assertFunction("to_ieee754_32(CAST(1.4E-45 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"00000001"));
        this.assertFunction("to_ieee754_32(CAST(-1.4E-45 AS REAL))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"80000001"));
    }

    @Test
    public void testFromIEEE754Binary32() {
        this.assertFunction("from_ieee754_32(from_hex('3F800000'))", (Type)RealType.REAL, Float.valueOf(1.0f));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(1.0 AS REAL)))", (Type)RealType.REAL, Float.valueOf(1.0f));
        this.assertFunction("from_ieee754_32(from_hex('4048F5C3'))", (Type)RealType.REAL, Float.valueOf(3.14f));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(3.14 AS REAL)))", (Type)RealType.REAL, Float.valueOf(3.14f));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(NAN() AS REAL)))", (Type)RealType.REAL, Float.valueOf(Float.NaN));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(INFINITY() AS REAL)))", (Type)RealType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(-INFINITY() AS REAL)))", (Type)RealType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(3.4028235E38 AS REAL)))", (Type)RealType.REAL, Float.valueOf(Float.MAX_VALUE));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(-3.4028235E38 AS REAL)))", (Type)RealType.REAL, Float.valueOf(-3.4028235E38f));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(1.4E-45 AS REAL)))", (Type)RealType.REAL, Float.valueOf(Float.MIN_VALUE));
        this.assertFunction("from_ieee754_32(to_ieee754_32(CAST(-1.4E-45 AS REAL)))", (Type)RealType.REAL, Float.valueOf(-1.4E-45f));
        this.assertInvalidFunction("from_ieee754_32(from_hex('0000'))", "Input floating-point value must be exactly 4 bytes long");
    }

    @Test
    public void testToIEEE754Binary64() {
        this.assertFunction("to_ieee754_64(0.0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000000"));
        this.assertFunction("to_ieee754_64(1.0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"3FF0000000000000"));
        this.assertFunction("to_ieee754_64(3.1415926)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"400921FB4D12D84A"));
        this.assertFunction("to_ieee754_64(NAN())", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FF8000000000000"));
        this.assertFunction("to_ieee754_64(INFINITY())", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FF0000000000000"));
        this.assertFunction("to_ieee754_64(-INFINITY())", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FFF0000000000000"));
        this.assertFunction("to_ieee754_64(1.7976931348623157E308)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"7FEFFFFFFFFFFFFF"));
        this.assertFunction("to_ieee754_64(-1.7976931348623157E308)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FFEFFFFFFFFFFFFF"));
        this.assertFunction("to_ieee754_64(4.9E-324)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0000000000000001"));
        this.assertFunction("to_ieee754_64(-4.9E-324)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"8000000000000001"));
    }

    @Test
    public void testFromIEEE754Binary64() {
        this.assertFunction("from_ieee754_64(from_hex('0000000000000000'))", (Type)DoubleType.DOUBLE, 0.0);
        this.assertFunction("from_ieee754_64(from_hex('3FF0000000000000'))", (Type)DoubleType.DOUBLE, 1.0);
        this.assertFunction("from_ieee754_64(to_ieee754_64(3.1415926))", (Type)DoubleType.DOUBLE, 3.1415926);
        this.assertFunction("from_ieee754_64(to_ieee754_64(NAN()))", (Type)DoubleType.DOUBLE, Double.NaN);
        this.assertFunction("from_ieee754_64(to_ieee754_64(INFINITY()))", (Type)DoubleType.DOUBLE, Double.POSITIVE_INFINITY);
        this.assertFunction("from_ieee754_64(to_ieee754_64(-INFINITY()))", (Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.assertFunction("from_ieee754_64(to_ieee754_64(1.7976931348623157E308))", (Type)DoubleType.DOUBLE, Double.MAX_VALUE);
        this.assertFunction("from_ieee754_64(to_ieee754_64(-1.7976931348623157E308))", (Type)DoubleType.DOUBLE, -1.7976931348623157E308);
        this.assertFunction("from_ieee754_64(to_ieee754_64(4.9E-324))", (Type)DoubleType.DOUBLE, Double.MIN_VALUE);
        this.assertFunction("from_ieee754_64(to_ieee754_64(-4.9E-324))", (Type)DoubleType.DOUBLE, -4.9E-324);
        this.assertInvalidFunction("from_ieee754_64(from_hex('00000000'))", "Input floating-point value must be exactly 8 bytes long");
    }

    @Test
    public void testLpad() {
        this.assertFunction("lpad(x'1234',7,x'45')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"45454545451234"));
        this.assertFunction("lpad(x'1234',7,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"45244524451234"));
        this.assertFunction("lpad(x'1234',3,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"451234"));
        this.assertFunction("lpad(x'1234',0,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
        this.assertFunction("lpad(x'1234',1,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12"));
        this.assertInvalidFunction("lpad(x'2312',-1,x'4524')", "Target length must be in the range [0..2147483647]");
        this.assertInvalidFunction("lpad(x'2312',1,x'')", "Padding bytes must not be empty");
    }

    @Test
    public void testRpad() {
        this.assertFunction("rpad(x'1234',7,x'45')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12344545454545"));
        this.assertFunction("rpad(x'1234',7,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12344524452445"));
        this.assertFunction("rpad(x'1234',3,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"123445"));
        this.assertFunction("rpad(x'23',0,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)""));
        this.assertFunction("rpad(x'1234',1,x'4524')", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"12"));
        this.assertInvalidFunction("rpad(x'1234',-1,x'4524')", "Target length must be in the range [0..2147483647]");
        this.assertInvalidFunction("rpad(x'1234',1,x'')", "Padding bytes must not be empty");
    }

    @Test
    public void testMd5() {
        this.assertFunction("md5(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"D41D8CD98F00B204E9800998ECF8427E"));
        this.assertFunction("md5(CAST('hashme' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"533F6357E0210E67D91F651BC49E1278"));
    }

    @Test
    public void testSha1() {
        this.assertFunction("sha1(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"DA39A3EE5E6B4B0D3255BFEF95601890AFD80709"));
        this.assertFunction("sha1(CAST('hashme' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FB78992E561929A6967D5328F49413FA99048D06"));
    }

    @Test
    public void testSha256() {
        this.assertFunction("sha256(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"E3B0C44298FC1C149AFBF4C8996FB92427AE41E4649B934CA495991B7852B855"));
        this.assertFunction("sha256(CAST('hashme' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"02208B9403A87DF9F4ED6B2EE2657EFAA589026B4CCE9ACCC8E8A5BF3D693C86"));
    }

    @Test
    public void testSha512() {
        this.assertFunction("sha512(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"CF83E1357EEFB8BDF1542850D66D8007D620E4050B5715DC83F4A921D36CE9CE47D0D13C5D85F2B0FF8318D2877EEC2F63B931BD47417A81A538327AF927DA3E"));
        this.assertFunction("sha512(CAST('hashme' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"8A4B59FB9188D09B989FF596AC9CEFBF2ED91DED8DCD9498E8BF2236814A92B23BE6867E7FC340880E514F8FDF97E1F147EA4B0FD6C2DA3557D0CF1C0B58A204"));
    }

    @Test
    public void testXxhash64() {
        this.assertFunction("xxhash64(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"EF46DB3751D8E999"));
        this.assertFunction("xxhash64(CAST('hashme' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"F9D96E0E1165E892"));
    }

    @Test
    public void testSpookyHash() {
        this.assertFunction("spooky_hash_v2_32(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"6BF50919"));
        this.assertFunction("spooky_hash_v2_32(CAST('hello' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"D382E6CA"));
        this.assertFunction("spooky_hash_v2_64(CAST('' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"232706FC6BF50919"));
        this.assertFunction("spooky_hash_v2_64(CAST('hello' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"3768826AD382E6CA"));
    }

    @Test
    public void testHashCode() {
        Slice data = Slices.wrappedBuffer((byte[])ALL_BYTES);
        Block block = VarbinaryType.VARBINARY.createBlockBuilder(null, 1, ALL_BYTES.length).writeBytes(data, 0, data.length()).closeEntry().build();
        Assert.assertEquals((long)VarbinaryOperators.hashCode((Slice)data), (long)VarbinaryType.VARBINARY.hash(block, 0));
    }

    @Test
    public void testCrc32() {
        this.assertFunction("crc32(to_utf8('CRC me!'))", (Type)BigintType.BIGINT, 38028046L);
        this.assertFunction("crc32(to_utf8('1234567890'))", (Type)BigintType.BIGINT, 639479525L);
        this.assertFunction("crc32(to_utf8(CAST(1234567890 AS VARCHAR)))", (Type)BigintType.BIGINT, 639479525L);
        this.assertFunction("crc32(to_utf8('ABCDEFGHIJK'))", (Type)BigintType.BIGINT, 1129618807L);
        this.assertFunction("crc32(to_utf8('ABCDEFGHIJKLM'))", (Type)BigintType.BIGINT, 4223167559L);
    }

    @Test
    public void testVarbinarySubstring() {
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 5)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 50)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', -5)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"cally"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', -50)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 5, 6)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratica"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 5, 10)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 5, 50)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 50, 10)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', -5, 4)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"call"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', -5, 40)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"cally"));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', -50, 4)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 0, 4)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTR(VARBINARY 'Quadratically', 5, 0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM 5)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM 50)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM -5)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"cally"));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM -50)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM 0)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)""));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM 5 FOR 6)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratica"));
        this.assertFunction("SUBSTRING(VARBINARY 'Quadratically' FROM 5 FOR 50)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((String)"ratically"));
        this.assertFunction("SUBSTRING(X'4FE15FF5' FROM 1 FOR 1)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{79}));
        this.assertFunction("SUBSTRING(X'4FE15FF5' FROM 2 FOR 2)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{225, 95}));
        this.assertFunction("SUBSTRING(X'4FE15FF5' FROM 3)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{95, 245}));
        this.assertFunction("SUBSTRING(X'4FE15FF5' FROM -2)", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinary((int[])new int[]{95, 245}));
    }

    @Test
    public void testHmacMd5() {
        this.assertFunction("hmac_md5(CAST('' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"63530468A04E386459855DA0063B6596"));
        this.assertFunction("hmac_md5(CAST('hashme' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"0A26EBEB0E7B65F528D96F7BC631BC8F"));
    }

    @Test
    public void testHmacSHA1() {
        this.assertFunction("hmac_sha1(CAST('' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"F42BB0EEB018EBBD4597AE7213711EC60760843F"));
        this.assertFunction("hmac_sha1(CAST('hashme' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"2E7C4C6AEFA7E69F106EEE3CE21944D0046D2F3D"));
    }

    @Test
    public void testHmacSHA256() {
        this.assertFunction("hmac_sha256(CAST('' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"5D5D139563C95B5967B9BD9A8C9B233A9DEDB45072794CD232DC1B74832607D0"));
        this.assertFunction("hmac_sha256(CAST('hashme' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"D3D72F9FACDE059DA3A4EB43A9ABDD4B35118E0FEF00E6D16FB04BB332AF0484"));
    }

    @Test
    public void testHmacSHA512() {
        this.assertFunction("hmac_sha512(CAST('' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"84FA5AA0279BBC473267D05A53EA03310A987CECC4C1535FF29B6D76B8F1444A728DF3AADB89D4A9A6709E1998F373566E8F824A8CA93B1821F0B69BC2A2F65E"));
        this.assertFunction("hmac_sha512(CAST('hashme' AS VARBINARY), CAST('key' AS VARBINARY))", (Type)VarbinaryType.VARBINARY, SqlVarbinaryTestingUtil.sqlVarbinaryFromHex((String)"FEFA712B67DED871E1ED987F8B20D6A69EB9FCC87974218B9A1A6D5202B54C18ECDA4839A979DED22F07E0881CF40B762691992D120408F49D6212E112509D72"));
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "cast(null as varbinary)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "X'58'", (Type)BooleanType.BOOLEAN, false);
    }

    private static String encodeBase64(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }

    private static String encodeBase64(String value) {
        return TestVarbinaryFunctions.encodeBase64(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeBase64Url(byte[] value) {
        return Base64.getUrlEncoder().encodeToString(value);
    }

    private static String encodeBase64Url(String value) {
        return TestVarbinaryFunctions.encodeBase64Url(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String encodeHex(String value) {
        return BaseEncoding.base16().encode(value.getBytes(StandardCharsets.UTF_8));
    }

    static {
        for (int i = 0; i < ALL_BYTES.length; ++i) {
            TestVarbinaryFunctions.ALL_BYTES[i] = (byte)i;
        }
    }
}

