/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.Session;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.TestingSession;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public abstract class BaseTestExtract {
    private final boolean legacyTimestamp;
    private QueryAssertions assertions;

    protected BaseTestExtract(boolean legacyTimestamp) {
        this.legacyTimestamp = legacyTimestamp;
    }

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("legacy_timestamp", String.valueOf(this.legacyTimestamp)).setTimeZoneKey(TestingSession.DEFAULT_TIME_ZONE_KEY).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
    }

    @Test
    public void testMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '5'");
    }

    @Test
    public void testDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '10'");
    }

    @Test
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '12'");
    }

    @Test
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '34'");
    }

    @Test
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIMESTAMP '1500-05-10 12:34:56.123456789012')")))).matches("BIGINT '56'");
    }

    @Test
    public void testMillisecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '123'");
    }

    @Test
    public void testDayOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '7'");
    }

    @Test
    public void testDayOfYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '131'");
    }

    @Test
    public void testQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2'");
    }

    @Test
    public void testWeekOfYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week_of_year(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '19'");
    }

    @Test
    public void testYearOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("BIGINT '2020'");
    }
}

