/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOperators {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu' = TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56 +04:44' = TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1 +04:44' = TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12 +04:44' = TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123 +04:44' = TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234 +04:44' = TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345 +04:44' = TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456 +04:44' = TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234567 +04:44' = TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345678 +04:44' = TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456789 +04:44' = TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234567891 +04:44' = TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345678912 +04:44' = TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456789123 +04:44' = TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu'")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56 +04:44' <> TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234567 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345678 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456789 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234567891 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345678912 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456789123 +04:44' <> TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' <> TIMESTAMP '2021-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.2 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.13 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.124 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1235 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12346 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123457 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1234568 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12345679 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123456781 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.12345678902 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' <> TIMESTAMP '2020-05-01 12:34:56.123456789013 Asia/Kathmandu'")))).isEqualTo(true);
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234567 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345678 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456789 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.1234567891 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.12345678912 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 11:33:56.123456789123 +04:44' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:55 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.0 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.122 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1233 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12344 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123455 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234566 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345677 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456788 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567899 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678900 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789011 Asia/Kathmandu'")))).isEqualTo(true);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.2 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.13 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.124 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1235 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12346 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123457 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1234568 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12345679 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123456790 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12345678902 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123456789013 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' < TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:55 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:55.9 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.122 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1233 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12344 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123455 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1234566 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12345677 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123456788 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1234567889 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12345678899 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123456789011 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' > TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.2 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.13 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.124 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1235 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12346 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123457 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234568 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345679 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456790 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345678902 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456789013 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:55 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.0 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.122 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1233 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12344 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123454 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234566 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345677 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456788 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.1234567889 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.12345678900 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' <= TIMESTAMP '2020-05-01 12:34:56.123456789011 Asia/Kathmandu'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:55 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:55.9 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.122 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1233 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12344 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123455 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234566 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345677 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123456788 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234567889 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345678899 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123456789011 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.2 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.13 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.124 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1235 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12346 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123457 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234568 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345679 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.12345678902 Asia/Kathmandu'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' >= TIMESTAMP '2020-05-01 12:34:56.123456789013 Asia/Kathmandu'")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:55 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.0 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.2 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.13 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.122 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.124 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1233 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.1235 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.12344 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.12346 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.123455 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.123457 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1234566 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.1234568 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.12345677 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.12345679 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.123456788 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.123456790 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1234567889 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.12345678902 Asia/Kathmandu'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' BETWEEN TIMESTAMP '2020-05-01 12:34:56.123456789011 Asia/Kathmandu' and TIMESTAMP '2020-05-01 12:34:56.123456789013 Asia/Kathmandu'")))).isEqualTo(true);
    }

    @Test
    public void testAddIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.223 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.243 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789012 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.223 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.243 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789012 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.100 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.120 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789012 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.100 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.120 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789012 Asia/Kathmandu'");
    }

    @Test
    public void testSubtractIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:54.877 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:54.977 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:54.997 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.0004 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.00045 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.0004567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.00045678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.0004567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.00045678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000456789012 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.100 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.120 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.1234 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.12345 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.1234567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.12345678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.1234567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.12345678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123456789012 Asia/Kathmandu'");
    }

    @Test
    public void testAddIntervalYearToMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789012 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789012 Asia/Kathmandu'");
    }

    @Test
    public void testSubtractIntervalYearToMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1234 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12345 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123456 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1234567 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12345678 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123456789 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1234567890 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12345678901 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123456789012 Asia/Kathmandu'");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55 Asia/Kathmandu'")))).matches("INTERVAL '1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1 Asia/Kathmandu'")))).matches("INTERVAL '1.1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11 Asia/Kathmandu'")))).matches("INTERVAL '1.11' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2222222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22222222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222222222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1 Asia/Kathmandu'")))).matches("INTERVAL '1.8' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11 Asia/Kathmandu'")))).matches("INTERVAL '1.88' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111 Asia/Kathmandu'")))).matches("INTERVAL '1.888' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9999999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.1111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99999999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.11111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999999999999 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.111111111111 Asia/Kathmandu'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.0002 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.0005 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.00022 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.00055 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.000222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.000555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.0002222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.0005555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.00022222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.00055555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.000222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.000555555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.0002222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.0005555555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.00022222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.00055555555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.000222222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.000555555555 Asia/Kathmandu'")))).matches("INTERVAL '1.000' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.0002 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.0009 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.00022 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.00099 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.000222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.000999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.0002222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.0009999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.00022222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.00099999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.000222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.000999999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.0002222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.0009999999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.00022222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.00099999999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.000222222222 Asia/Kathmandu' - TIMESTAMP '2020-05-01 12:34:55.000999999999 Asia/Kathmandu'")))).matches("INTERVAL '0.999' SECOND");
    }
}

