/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.Session;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTimestampWithTimeZone {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0)).isEqualTo(this.timestampWithTimeZone(0, 2020, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)1)).isEqualTo(this.timestampWithTimeZone(1, 2020, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)2)).isEqualTo(this.timestampWithTimeZone(2, 2020, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3)).isEqualTo(this.timestampWithTimeZone(3, 2020, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4)).isEqualTo(this.timestampWithTimeZone(4, 2020, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)5)).isEqualTo(this.timestampWithTimeZone(5, 2020, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6)).isEqualTo(this.timestampWithTimeZone(6, 2020, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)7)).isEqualTo(this.timestampWithTimeZone(7, 2020, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)8)).isEqualTo(this.timestampWithTimeZone(8, 2020, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9)).isEqualTo(this.timestampWithTimeZone(9, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)10)).isEqualTo(this.timestampWithTimeZone(10, 2020, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)11)).isEqualTo(this.timestampWithTimeZone(11, 2020, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).hasType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12)).isEqualTo(this.timestampWithTimeZone(12, 2020, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890123 Asia/Kathmandu'")).hasMessage("line 1:8: TIMESTAMP WITH TIME ZONE precision must be in range [0, 12]");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIMESTAMP '2020-13-01 Asia/Kathmandu'")).hasMessage("line 1:8: '2020-13-01 Asia/Kathmandu' is not a valid timestamp literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, 1500, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, 1500, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, 1500, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, 1500, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, 1500, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, 1500, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, 1500, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, 1500, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, 1500, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, 1500, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, 1500, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, 1500, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '1500-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, 1500, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, 12001, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, 12001, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, 12001, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, 12001, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, 12001, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, 12001, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, 12001, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, 12001, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, 12001, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, 12001, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '12001-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, 12001, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, 12001, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, 12001, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, 12001, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, 12001, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, 12001, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, 12001, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, 12001, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, 12001, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, 12001, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, 12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, 12001, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '+12001-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, 12001, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(0, -12001, 5, 1, 12, 34, 56, 0L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(1, -12001, 5, 1, 12, 34, 56, 100000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(2, -12001, 5, 1, 12, 34, 56, 120000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(3, -12001, 5, 1, 12, 34, 56, 123000000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1234 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(4, -12001, 5, 1, 12, 34, 56, 123400000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12345 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(5, -12001, 5, 1, 12, 34, 56, 123450000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123456 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(6, -12001, 5, 1, 12, 34, 56, 123456000000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1234567 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(7, -12001, 5, 1, 12, 34, 56, 123456700000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12345678 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(8, -12001, 5, 1, 12, 34, 56, 123456780000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123456789 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(9, -12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.1234567890 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(10, -12001, 5, 1, 12, 34, 56, 123456789000L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.12345678901 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(11, -12001, 5, 1, 12, 34, 56, 123456789010L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '-12001-05-01 12:34:56.123456789012 Asia/Kathmandu'")))).isEqualTo(this.timestampWithTimeZone(12, -12001, 5, 1, 12, 34, 56, 123456789012L, TimeZoneKey.getTimeZoneKey((String)"Asia/Kathmandu")));
    }

    @Test
    public void testCurrentTimestamp() {
        Session session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 111111111, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(0)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(1)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(2)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(3)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(4)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(5)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(6)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(7)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(8)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(9)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(10)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111110 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(11)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(12)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111000 Pacific/Apia'");
        session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 555555555, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(0)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(1)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(2)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(3)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(4)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(5)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(6)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(7)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(8)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(9)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(10)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555550 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(11)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555500 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("current_timestamp(12)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555000 Pacific/Apia'");
    }

    @Test
    public void testCastToDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' AS DATE)")))).matches("DATE '2020-05-01'");
    }

    @Test
    public void testCastFromDate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(DATE '2020-05-01' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000000 Pacific/Apia'");
    }

    @Test
    public void testCastFromTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1110 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1110000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11100000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1110000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11100000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.5550 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.55500 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.5550000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.55500000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.5550000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.55500000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555000000000 Pacific/Apia'");
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKeyForOffset((long)-300L)).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIME WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556 Asia/Kathmandu'");
    }

    @Test
    public void testCastFromTimeWithTimeZone() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1110 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11100 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1110000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11100000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.1110000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.11100000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111 -08:00' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.111000000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:57 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.6 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.56 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.5550 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.55500 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.5550000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.55500000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.5550000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.55500000000 -08:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555 -08:00' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '1970-01-01 12:34:56.555000000000 -08:00'");
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234567 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345678 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456789 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.1234567890 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.12345678901 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("2020-05-01 12:34:56.123456789012 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234567 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234567 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345678 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345678 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456789 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456789 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.1234567890 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.1234567890 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.12345678901 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.12345678901 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-01 12:34:56.123456789012 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("1500-05-01 12:34:56.123456789012 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("+12001-05-01 12:34:56 Asia/Kathmandu");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-12001-05-01 12:34:56 Asia/Kathmandu' AS VARCHAR)")))).isEqualTo("-12001-05-01 12:34:56 Asia/Kathmandu");
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('2020-05-01 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-01 12:34:56.555555555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('+12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '12001-05-01 12:34:56.111111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(2) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(5) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(7) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(8) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(11) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.11111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('-12001-05-01 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '-12001-05-01 12:34:56.111111111111 Asia/Kathmandu'");
    }

    @Test
    public void testLowerDigitsZeroed() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111111000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57.000000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(9) WITH TIME ZONE) AS TIMESTAMP(12) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555556000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57.000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE) AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE) AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57.000 Asia/Kathmandu'");
    }

    @Test
    public void testRoundDown() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.1111 Asia/Kathmandu'");
    }

    @Test
    public void testRoundUp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(6) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.5555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu' AS TIMESTAMP(10) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.5555555556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(0) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(1) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.6 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(3) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '2020-05-10 12:34:56.5556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu' AS TIMESTAMP(4) WITH TIME ZONE)")))).matches("TIMESTAMP '1500-05-10 12:34:56.5556 Asia/Kathmandu'");
    }

    @Test
    public void testToIso8601() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)28)).isEqualTo("2020-05-01T12:34:56+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("2020-05-01T12:34:56.1+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-05-01T12:34:56.12+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("2020-05-01T12:34:56.123+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)33)).isEqualTo("2020-05-01T12:34:56.1234+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)34)).isEqualTo("2020-05-01T12:34:56.12345+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)35)).isEqualTo("2020-05-01T12:34:56.123456+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)36)).isEqualTo("2020-05-01T12:34:56.1234567+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)37)).isEqualTo("2020-05-01T12:34:56.12345678+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)38)).isEqualTo("2020-05-01T12:34:56.123456789+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567890 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("2020-05-01T12:34:56.1234567890+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678901 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)40)).isEqualTo("2020-05-01T12:34:56.12345678901+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789012 Asia/Kathmandu')")))).hasType((Type)VarcharType.createVarcharType((int)41)).isEqualTo("2020-05-01T12:34:56.123456789012+05:45");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)28)).isEqualTo("2020-05-01T12:34:56Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)30)).isEqualTo("2020-05-01T12:34:56.1Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)31)).isEqualTo("2020-05-01T12:34:56.12Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)32)).isEqualTo("2020-05-01T12:34:56.123Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)33)).isEqualTo("2020-05-01T12:34:56.1234Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)34)).isEqualTo("2020-05-01T12:34:56.12345Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)35)).isEqualTo("2020-05-01T12:34:56.123456Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)36)).isEqualTo("2020-05-01T12:34:56.1234567Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)37)).isEqualTo("2020-05-01T12:34:56.12345678Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)38)).isEqualTo("2020-05-01T12:34:56.123456789Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.1234567890 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)39)).isEqualTo("2020-05-01T12:34:56.1234567890Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.12345678901 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)40)).isEqualTo("2020-05-01T12:34:56.12345678901Z");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_iso8601(TIMESTAMP '2020-05-01 12:34:56.123456789012 +00:00')")))).hasType((Type)VarcharType.createVarcharType((int)41)).isEqualTo("2020-05-01T12:34:56.123456789012Z");
    }

    @Test
    public void testFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.100+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.110+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111100+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111110+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111100+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111110+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.111111111+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).isEqualTo("2020-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555500+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555550+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555555+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '12001-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).isEqualTo("+12001-05-10T12:34:56.555555556+05:45[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.500+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.550+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555500+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555550+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555500+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555550+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555555+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555556+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555556+05:41:16[Asia/Kathmandu]");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIMESTAMP '-12001-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).isEqualTo("-12001-05-10T12:34:56.555555556+05:41:16[Asia/Kathmandu]");
    }

    @Test
    public void testFormatDateTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.000 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.100 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.110 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.111 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.000 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.500 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.550 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.555 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format_datetime(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu', 'yyyy-MM-dd HH:mm:ss.SSS Z')")))).isEqualTo("2020-05-10 12:34:56.556 +0545");
    }

    @Test
    public void testDateFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.100000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.110000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.1111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.11111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.111111111111 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.111000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.500000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.550000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.555000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.5555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.55555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_format(TIMESTAMP '2020-05-10 12:34:56.555555555555 Asia/Kathmandu', '%Y-%m-%d %H:%i:%s.%f')")))).isEqualTo("2020-05-10 12:34:56.556000");
    }

    @Test
    public void testDateDiff() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2 Asia/Kathmandu')")))).matches("BIGINT '1100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22 Asia/Kathmandu')")))).matches("BIGINT '1110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222222 Asia/Kathmandu')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9 Asia/Kathmandu')")))).matches("BIGINT '1800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99 Asia/Kathmandu')")))).matches("BIGINT '1880'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIMESTAMP '2020-05-10 12:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999999 Asia/Kathmandu')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.2222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.22222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.222222222222 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.1111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.9999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.11111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.99999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIMESTAMP '2020-05-10 11:34:55.111111111111 Asia/Kathmandu', TIMESTAMP '2020-05-10 12:34:56.999999999999 Asia/Kathmandu')")))).matches("BIGINT '1'");
    }

    @Test
    public void testDateAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1010 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10100 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1010000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10100000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.1000000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1010000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.10000000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.10100000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '2020-05-10 12:34:56.100000000000 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:56.101000000000 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1000, TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '2020-05-10 12:34:57 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.1111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.1121111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.11111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.11211111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.111111111111 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.112111111111 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.5555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.5565555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.55555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.55655555555 Asia/Kathmandu'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIMESTAMP '1500-05-10 12:34:56.555555555555 Asia/Kathmandu')")))).matches("TIMESTAMP '1500-05-10 12:34:56.556555555555 Asia/Kathmandu'");
    }

    @Test
    public void testTimeZoneHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1234 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12345 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123456 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1234567 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12345678 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123456789 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.1234567890 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.12345678901 +07:09')")))).isEqualTo(7L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_hour(TIMESTAMP '2020-05-01 12:34:56.123456789012 +07:09')")))).isEqualTo(7L);
    }

    @Test
    public void testTimeZoneMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1234 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12345 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123456 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1234567 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12345678 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123456789 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.1234567890 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.12345678901 +07:09')")))).isEqualTo(9L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("timezone_minute(TIMESTAMP '2020-05-01 12:34:56.123456789012 +07:09')")))).isEqualTo(9L);
    }

    @Test
    public void testLastDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234567 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345678 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456789 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.1234567891 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.12345678912 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("last_day_of_month(TIMESTAMP '2020-05-01 12:34:56.123456789123 Asia/Kathmandu')")))).matches("DATE '2020-05-31'");
    }

    @Test
    public void testToUnixTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56 Asia/Kathmandu')")))).matches("1589093396e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1 Asia/Kathmandu')")))).matches("1589093396.1e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12 Asia/Kathmandu')")))).matches("1589093396.12e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123 Asia/Kathmandu')")))).matches("1589093396.123e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234 Asia/Kathmandu')")))).matches("1589093396.1234e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345 Asia/Kathmandu')")))).matches("1589093396.1234498e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456 Asia/Kathmandu')")))).matches("1589093396.123456e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234567 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345678 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456789 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.1234567890 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.12345678901 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("to_unixtime(TIMESTAMP '2020-05-10 12:34:56.123456789012 Asia/Kathmandu')")))).matches("1589093396.1234567e0");
    }

    @Test
    public void testOrdering() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00 America/New_York', TIMESTAMP '2020-05-10 01:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00 America/New_York', TIMESTAMP '2020-05-10 02:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00 America/New_York', TIMESTAMP '2020-05-10 03:00:00 America/Los_Angeles' ) t(value)ORDER BY value")))).ordered().matches("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00 America/New_York', TIMESTAMP '2020-05-10 02:00:00 America/New_York', TIMESTAMP '2020-05-10 03:00:00 America/New_York', TIMESTAMP '2020-05-10 01:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00 America/Los_Angeles' ) t(value)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 01:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 02:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 03:00:00.000000 America/Los_Angeles' ) t(value)ORDER BY value")))).ordered().matches("SELECT value FROM (VALUES TIMESTAMP '2020-05-10 01:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 02:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 03:00:00.000000 America/New_York', TIMESTAMP '2020-05-10 01:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 02:00:00.000000 America/Los_Angeles', TIMESTAMP '2020-05-10 03:00:00.000000 America/Los_Angeles' ) t(value)");
    }

    @Test
    public void testJoin() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM (VALUES TIMESTAMP '2020-05-10 04:00:00 America/New_York') t(v) JOIN (VALUES TIMESTAMP '2020-05-10 01:00:00 America/Los_Angeles') u(v) USING (v)")))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM (VALUES TIMESTAMP '2020-05-10 04:00:00.000000 America/New_York') t(v) JOIN (VALUES TIMESTAMP '2020-05-10 01:00:00.000000 America/Los_Angeles') u(v) USING (v)")))).matches("VALUES BIGINT '1'");
    }

    private BiFunction<Session, QueryRunner, Object> timestampWithTimeZone(int precision, int year, int month, int day, int hour, int minute, int second, long picoOfSecond, TimeZoneKey timeZoneKey) {
        return (session, queryRunner) -> {
            ZonedDateTime base = ZonedDateTime.of(year, month, day, hour, minute, second, 0, timeZoneKey.getZoneId());
            long epochMillis = base.toEpochSecond() * 1000L + picoOfSecond / 1000000000L;
            int picosOfMilli = (int)(picoOfSecond % 1000000000L);
            return SqlTimestampWithTimeZone.newInstance((int)precision, (long)epochMillis, (int)picosOfMilli, (TimeZoneKey)timeZoneKey);
        };
    }
}

